/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.tests;

import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDUtil;
import org.eclipse.wst.dtd.core.tests.internal.DTDCoreTestsPlugin;

public class DTDParserTest
extends TestCase {
    private static final String UNEXPECTED_FILE_CONTENTS = "Unexpected file contents";

    public void testMultipleCommentParsing() throws IOException {
        DTDUtil util = new DTDUtil();
        String sampleDTDpath = "/resources/dtdParserTest/sample.dtd";
        URL bundleURL = DTDCoreTestsPlugin.getDefault().getBundle().getEntry(sampleDTDpath);
        DTDParserTest.assertNotNull((String)(String.valueOf(sampleDTDpath) + " not found in bundle"), (Object)bundleURL);
        URL fileURL = FileLocator.toFileURL((URL)bundleURL);
        util.parse(fileURL.toExternalForm());
        DTDFile dtdFile = util.getDTDFile();
        DTDParserTest.assertEquals((String)UNEXPECTED_FILE_CONTENTS, (int)1, (int)dtdFile.getDTDContent().size());
        Object object = dtdFile.getDTDContent().get(0);
        DTDParserTest.assertTrue((String)UNEXPECTED_FILE_CONTENTS, (boolean)(object instanceof DTDElement));
        DTDElement dtdElement = (DTDElement)object;
        String comment = dtdElement.getComment();
        DTDParserTest.assertEquals((String)"Comment value was not as expected", (String)" line one \n line two ", (String)comment);
    }
}

