/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************
 *
 **/
/**
  * Object window()
  * @type window
  * @super Object
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535873.aspx
*/

function window(){};
window.prototype= new Object();
/**
  * Property closed
  * @type Boolean
  * @returns {Boolean}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533574.aspx
*/

window.prototype.closed=false;
/**
  * Property defaultStatus
  * @type String
  * @returns {String}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533717.aspx
*/

window.prototype.defaultStatus="";
/**
  * Property dialogArguments
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533723.aspx
*/

window.prototype.dialogArguments=new Object();
/**
  * Property dialogHeight
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533724.aspx
*/

window.prototype.dialogHeight=new Object();
/**
  * Property dialogLeft
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533725.aspx
*/

window.prototype.dialogLeft=new Object();
/**
  * Property dialogTop
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533726.aspx
*/

window.prototype.dialogTop=new Object();
/**
  * Property dialogWidth
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533727.aspx
*/

window.prototype.dialogWidth=new Object();
/**
  * Property frameElement
  * @type frame
  * @returns {frame}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533771.aspx
*/

window.prototype.frameElement=new frame();
/**
  * Property frame
  * @type frame
  * @returns {frame}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535250.aspx
*/

window.prototype.frame= new frame();
/**
  * Property iframe
  * @type iframe
  * @returns {iframe}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535258.aspx
*/

window.prototype.iframe= new iframe();
/**
  * Property document
  * @type document
  * @returns {document}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531073.aspx
*/

window.prototype.document= new document();
/**
  * Property length
  * @type Number
  * @returns {Number}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534101.aspx
*/

window.prototype.length=0;
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534187.aspx
*/

window.prototype.name="";
/**
  * Property offscreenBuffering
  * @type Boolean
  * @returns {Boolean}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534198.aspx
*/

window.prototype.offscreenBuffering=false;
/**
  * Property opener
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534309.aspx
*/

window.prototype.opener=new Object();
/**
  * Property parent
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534326.aspx
*/

window.prototype.parent=new Object();
/**
  * Property returnValue
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534371.aspx
*/

window.prototype.returnValue=new Object();
/**
  * Property screenLeft
  * @type Number
  * @returns {Number}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534389.aspx
*/

window.prototype.screenLeft=0;
/**
  * Property screenTop
  * @type Number
  * @returns {Number}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534390.aspx
*/

window.prototype.screenTop=0;
/**
  * Property self
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534627.aspx
*/

window.prototype.self=new Object();
/**
  * Property status
  * @type String
  * @returns {String}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534648.aspx
*/

window.prototype.status="";
/**
  * Property top
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534687.aspx
*/

window.prototype.top=new Object();

/**
  * Property XMLHttpRequest
  * @type XMLHttpRequest
  * @returns {XMLHttpRequest}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535874.aspx
*/

window.prototype.XMLHttpRequest= new XMLHttpRequest();
/**
  * Property frames
  * @type frames
  * @returns {frames}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537459.aspx
*/

window.prototype.frames= new frames();
/**
  * function alert(sMessage)
  * @param {String} sMessage
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535933.aspx
*/

window.prototype.alert=function(sMessage){};
/**
  * function attachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {Boolean} fpNotify
  * @type Boolean
  * @returns {Boolean}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536343.aspx
*/

window.prototype.attachEvent=function(sEvent,fpNotify){};
/**
  * function blur()
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536347.aspx
*/

window.prototype.blur=function(){};
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

window.prototype.onblur= new onblur();
/**
  * function clearInterval(iIntervalID)
  * @param {Number} iIntervalID
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536353.aspx
*/

window.prototype.clearInterval=function(iIntervalID){};
/**
  * function setInterval(vCode,iMilliSeconds,sLanguage)
  * @param {Variant} vCode
  * @param {Number} iMilliSeconds
  * @param {String} sLanguage
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536749.aspx
*/

window.prototype.setInterval=function(vCode,iMilliSeconds,sLanguage){};
/**
  * function clearTimeout(iTimeoutID)
  * @param {Number} iTimeoutID
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536357.aspx
*/

window.prototype.clearTimeout=function(iTimeoutID){};
/**
  * function setTimeout(vCode,iMilliSeconds,sLanguage)
  * @param {Variant} vCode
  * @param {Number} iMilliSeconds
  * @param {String} sLanguage
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536753.aspx
*/

window.prototype.setTimeout=function(vCode,iMilliSeconds,sLanguage){};
/**
  * function close()
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536367.aspx
*/

window.prototype.close=function(){};
/**
  * function confirm(sMessage)
  * @param {String} sMessage
  * @type Boolean
  * @returns {Boolean}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536376.aspx
*/

window.prototype.confirm=function(sMessage){};
/**
  * function createPopup(vArgs)
  * @param {popup} vArgs
  * @type popup
  * @returns {popup}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536392.aspx
*/

window.prototype.createPopup=function(vArgs){};
/**
  * Property popup
  * @type popup
  * @returns {popup}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535882.aspx
*/

window.prototype.popup= new popup();
/**
  * function detachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {attachEvent} fpNotify
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536411.aspx
*/

window.prototype.detachEvent=function(sEvent,fpNotify){};
/**
  * function execScript(sExpression,sLanguage)
  * @param {String} sExpression
  * @param {String} sLanguage
  * @type null
  * @returns {null}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536420.aspx
*/

window.prototype.execScript=function(sExpression,sLanguage){};
/**
  * function focus()
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536425.aspx
*/

window.prototype.focus=function(){};
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

window.prototype.onfocus= new onfocus();
/**
  * function moveBy(iX,iY)
  * @param {Number} iX
  * @param {Number} iY
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536618.aspx
*/

window.prototype.moveBy=function(iX,iY){};
/**
  * function moveTo(iX,iY)
  * @param {Number} iX
  * @param {Number} iY
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536626.aspx
*/

window.prototype.moveTo=function(iX,iY){};
/**
  * function navigate(sURL)
  * @param {String} sURL
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536638.aspx
*/

window.prototype.navigate=function(sURL){};
/**
  * function open(sURL,sName,sURL,sFeature,bReplace,sURL)
  * @param {String} sURL
  * @param {String} sName
  * @param {String} sURL
  * @param {Back} sFeature
  * @param {Boolean} bReplace
  * @param {open} sURL
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536651.aspx
*/

window.prototype.open=function(sURL,sName,sURL,sFeature,bReplace,sURL){};
/**
  * function print()
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536672.aspx
*/

window.prototype.print=function(){};
/**
  * function prompt(sMessage,sDefaultValue)
  * @param {String} sMessage
  * @param {String} sDefaultValue
  * @type String
  * @returns {String}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536673.aspx
*/

window.prototype.prompt=function(sMessage,sDefaultValue){};
/**
  * function resizeBy(iX,iY)
  * @param {Number} iX
  * @param {Number} iY
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536722.aspx
*/

window.prototype.resizeBy=function(iX,iY){};
/**
  * function resizeTo(iWidth,iHeight)
  * @param {Number} iWidth
  * @param {Number} iHeight
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536723.aspx
*/

window.prototype.resizeTo=function(iWidth,iHeight){};
/**
  * function scroll(iX,iY)
  * @param {Number} iX
  * @param {Number} iY
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536726.aspx
*/

window.prototype.scroll=function(iX,iY){};
/**
  * function scrollBy(iX,iY)
  * @param {Number} iX
  * @param {Number} iY
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536728.aspx
*/

window.prototype.scrollBy=function(iX,iY){};
/**
  * function scrollTo(iX,iY)
  * @param {Number} iX
  * @param {Number} iY
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536731.aspx
*/

window.prototype.scrollTo=function(iX,iY){};
/**
  * function setActive()
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536738.aspx
*/

window.prototype.setActive=function(){};
/**
  * function showHelp(sURL,vContextID)
  * @param {String} sURL
  * @param {Variant} vContextID
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536758.aspx
*/

window.prototype.showHelp=function(sURL,vContextID){};
/**
  * function showModalDialog(sURL,vArguments)
  * @param {String} sURL
  * @param {String} vArguments
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536759.aspx
*/

window.prototype.showModalDialog=function(sURL,vArguments){};
/**
  * function showModelessDialog(sURL,vArguments,sFeatures)
  * @param {String} sURL
  * @param {Variant} vArguments
  * @param {Variant} sFeatures
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536761.aspx
*/

window.prototype.showModelessDialog=function(sURL,vArguments,sFeatures){};
/**
  * Property clientInformation
  * @type clientInformation
  * @returns {clientInformation}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535860.aspx
*/

window.prototype.clientInformation= new clientInformation();
/**
  * Property clipboardData
  * @type clipboardData
  * @returns {clipboardData}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535220.aspx
*/

window.prototype.clipboardData= new clipboardData();
/**
  * Property document
  * @type document
  * @returns {document}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531073.aspx
*/

window.prototype.document= new document();
/**
  * Property event
  * @type event
  * @returns {event}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535863.aspx
*/

window.prototype.event= new event();
/**
  * Property external
  * @type external
  * @returns {external}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535246.aspx
*/

window.prototype.external= new external();
/**
  * Property history
  * @type history
  * @returns {history}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535864.aspx
*/

window.prototype.history= new history();
/**
  * Property location
  * @type location
  * @returns {location}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535866.aspx
*/

window.prototype.location= new location();
/**
  * Property navigator
  * @type navigator
  * @returns {navigator}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535867.aspx
*/

window.prototype.navigator= new navigator();
/**
  * Property screen
  * @type screen
  * @returns {screen}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535868.aspx
*/

window.prototype.screen= new screen();
/**
  * Property onactivate
  * @type onactivate
  * @returns {onactivate}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536787.aspx
*/

window.prototype.onactivate= new onactivate();
/**
  * Property activeElement
  * @type Object
  * @returns {Object}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533065.aspx
*/

window.prototype.activeElement=new Object();
/**
  * Property onafterprint
  * @type onafterprint
  * @returns {onafterprint}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536788.aspx
*/

window.prototype.onafterprint= new onafterprint();
/**
  * Property onbeforedeactivate
  * @type onbeforedeactivate
  * @returns {onbeforedeactivate}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536903.aspx
*/

window.prototype.onbeforedeactivate= new onbeforedeactivate();
/**
  * Property onbeforeprint
  * @type onbeforeprint
  * @returns {onbeforeprint}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536906.aspx
*/

window.prototype.onbeforeprint= new onbeforeprint();
/**
  * Property onbeforeunload
  * @type onbeforeunload
  * @returns {onbeforeunload}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536907.aspx
*/

window.prototype.onbeforeunload= new onbeforeunload();
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

window.prototype.onblur= new onblur();
/**
  * Property oncontrolselect
  * @type oncontrolselect
  * @returns {oncontrolselect}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537844.aspx
*/

window.prototype.oncontrolselect= new oncontrolselect();
/**
  * Property ondeactivate
  * @type ondeactivate
  * @returns {ondeactivate}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536922.aspx
*/

window.prototype.ondeactivate= new ondeactivate();
/**
  * Property onerror
  * @type onerror
  * @returns {onerror}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536930.aspx
*/

window.prototype.onerror= new onerror();
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

window.prototype.onfocus= new onfocus();
/**
  * Property onhelp
  * @type onhelp
  * @returns {onhelp}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536937.aspx
*/

window.prototype.onhelp= new onhelp();
/**
  * Property onload
  * @type onload
  * @returns {onload}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536942.aspx
*/

window.prototype.onload= new onload();
/**
  * Property onmoveend
  * @type onmoveend
  * @returns {onmoveend}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536953.aspx
*/

window.prototype.onmoveend= new onmoveend();
/**
  * Property onmovestart
  * @type onmovestart
  * @returns {onmovestart}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536954.aspx
*/

window.prototype.onmovestart= new onmovestart();
/**
  * Property onresize
  * @type onresize
  * @returns {onresize}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536959.aspx
*/

window.prototype.onresize= new onresize();
/**
  * Property onresizeend
  * @type onresizeend
  * @returns {onresizeend}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536960.aspx
*/

window.prototype.onresizeend= new onresizeend();
/**
  * Property onscroll
  * @type onscroll
  * @returns {onscroll}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536966.aspx
*/

window.prototype.onscroll= new onscroll();
/**
  * Property onunload
  * @type onunload
  * @returns {onunload}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536973.aspx
*/

window.prototype.onunload= new onunload();
/**
  * Property frames
  * @type frames
  * @returns {frames}
  * @memberOf window
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537459.aspx
*/

window.prototype.frames= new frames();
