/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.QueryRedirector;

public class DeleteAllQuery
extends ModifyAllQuery {
    protected List<Object> objects;
    protected boolean isInMemoryOnly;

    public DeleteAllQuery() {
    }

    public DeleteAllQuery(Class referenceClass) {
        super(referenceClass);
    }

    public DeleteAllQuery(Class referenceClass, Expression selectionCriteria) {
        super(referenceClass, selectionCriteria);
    }

    public boolean isInMemoryOnly() {
        return this.isInMemoryOnly;
    }

    public void setIsInMemoryOnly(boolean isInMemoryOnly) {
        this.isInMemoryOnly = isInMemoryOnly;
    }

    @Override
    public boolean isDeleteAllQuery() {
        return true;
    }

    @Override
    public Object executeInUnitOfWork(UnitOfWorkImpl unitOfWork, AbstractRecord translationRow) throws DatabaseException {
        if (this.objects != null) {
            if (unitOfWork.isAfterWriteChangesButBeforeCommit()) {
                throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWork.getLifecycle(), "executeQuery(DeleteAllQuery)");
            }
            if (!unitOfWork.getCommitManager().isActive()) {
                return unitOfWork.getParent().executeQuery((DatabaseQuery)this, translationRow);
            }
            this.result = (Integer)super.execute(unitOfWork, translationRow);
            return this.result;
        }
        return super.executeInUnitOfWork(unitOfWork, translationRow);
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.objects != null) {
            if (this.isExpressionQuery() && this.getSelectionCriteria() == null) {
                throw QueryException.deleteAllQuerySpecifiesObjectsButNotSelectionCriteria(this.getDescriptor(), this, this.objects.toString());
            }
            try {
                DescriptorEvent event;
                this.session.beginTransaction();
                if (this.descriptor.getEventManager().hasAnyEventListeners()) {
                    for (Object object : this.objects) {
                        event = new DescriptorEvent(object);
                        event.setEventCode(2);
                        event.setSession(this.session);
                        event.setQuery(this);
                        this.descriptor.getEventManager().executeEvent(event);
                    }
                }
                this.result = this.isInMemoryOnly ? Integer.valueOf(0) : this.queryMechanism.deleteAll();
                if (this.descriptor.getEventManager().hasAnyEventListeners()) {
                    for (Object object : this.objects) {
                        event = new DescriptorEvent(object);
                        event.setEventCode(3);
                        event.setSession(this.session);
                        event.setQuery(this);
                        this.descriptor.getEventManager().executeEvent(event);
                    }
                }
                if (this.shouldMaintainCache()) {
                    for (Object deleted : this.objects) {
                        if (this.session.isUnitOfWork()) {
                            deleted = this.descriptor.getObjectBuilder().unwrapObject(deleted, this.getSession());
                            ((UnitOfWorkImpl)this.session).addObjectDeletedDuringCommit(deleted, this.descriptor);
                            continue;
                        }
                        this.session.getIdentityMapAccessor().removeFromIdentityMap(deleted);
                    }
                }
                this.session.commitTransaction();
            }
            catch (RuntimeException exception) {
                this.session.rollbackTransaction();
                throw exception;
            }
        } else {
            this.result = this.isInMemoryOnly ? Integer.valueOf(0) : this.queryMechanism.deleteAll();
            this.mergeChangesIntoSharedCache();
        }
        return this.result;
    }

    public void executeDeleteAll(AbstractSession session, AbstractRecord translationRow, Vector objects) throws DatabaseException {
        this.checkPrepare(session, translationRow);
        DeleteAllQuery queryToExecute = (DeleteAllQuery)this.clone();
        queryToExecute.setTranslationRow(translationRow);
        queryToExecute.setSession(session);
        queryToExecute.setObjects(objects);
        queryToExecute.prepareForExecution();
        queryToExecute.executeDatabaseQuery();
    }

    @Override
    protected QueryRedirector getDefaultRedirector() {
        if (this.objects == null) {
            return null;
        }
        return this.descriptor.getDefaultDeleteObjectQueryRedirector();
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    @Override
    protected void prepare() throws QueryException {
        super.prepare();
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            ClassDescriptor referenceDescriptor = this.getSession().getDescriptor(this.getReferenceClass());
            if (referenceDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(referenceDescriptor);
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.getDescriptor(), this);
        }
        this.getQueryMechanism().prepareDeleteAll();
    }

    public void setObjects(List<Object> objectCollection) {
        this.objects = objectCollection;
    }
}

