/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumLineBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.model.IgnoreCountData;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.ui.propertypages.Messages;

public class JsLineBreakpointPage
extends PropertyPage {
    private final List<String> errorMessages = new ArrayList<String>(2);
    private Button enabledCheckbox;
    private Button ignoreCountCheckbox;
    private Text ignoreCountText;
    private Button conditionCheckbox;
    private Text conditionText;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComposite = JsLineBreakpointPage.createComposite(parent, 2, 1);
        try {
            this.createBreakpointDataControls(mainComposite);
            this.createInfoControls(mainComposite);
            this.createEnabledControls(mainComposite);
            this.createIgnoreCountControls(mainComposite);
            this.createConditionControls(mainComposite);
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log((Throwable)e);
        }
        this.setValid(true);
        return mainComposite;
    }

    public boolean performOk() {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JsLineBreakpointPage.this.storePrefs();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null, 0, null);
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log((Throwable)e);
        }
        return super.performOk();
    }

    private void storePrefs() throws CoreException {
        String text;
        int ignoreCountValue;
        ChromiumLineBreakpoint breakpoint = this.getBreakpoint();
        breakpoint.setEnabled(this.enabledCheckbox.getSelection());
        try {
            ignoreCountValue = Integer.valueOf(this.ignoreCountText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            ignoreCountValue = -1;
        }
        IgnoreCountData.State ignoreCountState = this.ignoreCountCheckbox.getSelection() ? IgnoreCountData.State.ENABLED : IgnoreCountData.State.DISABLED;
        IgnoreCountData ignoreCountData = new IgnoreCountData(ignoreCountValue, ignoreCountState);
        breakpoint.setIgnoreCountData(ignoreCountData);
        String condition = null;
        if (this.conditionCheckbox.getSelection() && (text = this.conditionText.getText().trim()).length() > 0) {
            condition = text;
        }
        breakpoint.setCondition(condition);
    }

    private void createBreakpointDataControls(Composite mainComposite) {
    }

    private void createInfoControls(Composite parent) {
        Composite infoComposite = JsLineBreakpointPage.createComposite(parent, 2, 2);
        Label resourceLabel = new Label(infoComposite, 0);
        resourceLabel.setText(Messages.JsLineBreakpointPage_ResourceLabel);
        Label resourceNameLabel = new Label(infoComposite, 0);
        resourceNameLabel.setText(this.getBreakpoint().getMarker().getResource().getName());
        Label lineNumberLabel = new Label(infoComposite, 0);
        lineNumberLabel.setText(Messages.JsLineBreakpointPage_LineNumberLabel);
        Label lineNumberValueLabel = new Label(infoComposite, 0);
        String lineNumber = Messages.JsLineBreakpointPage_UnknownLineNumber;
        try {
            lineNumber = String.valueOf(this.getBreakpoint().getLineNumber());
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log((Throwable)e);
        }
        lineNumberValueLabel.setText(lineNumber);
    }

    private void createEnabledControls(Composite parent) throws CoreException {
        this.enabledCheckbox = new Button(parent, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.enabledCheckbox.setLayoutData((Object)gd);
        this.enabledCheckbox.setSelection(this.getBreakpoint().isEnabled());
        this.enabledCheckbox.setText(Messages.JavascriptLineBreakpointPage_Enabled);
    }

    private void createIgnoreCountControls(Composite parent) throws CoreException {
        this.ignoreCountCheckbox = new Button(parent, 32);
        IgnoreCountData ignoreCountData = this.getBreakpoint().getIgnoreCountData();
        int ignoreCount = ignoreCountData.getValue();
        IgnoreCountData.State state = ignoreCountData.getState();
        if (state == IgnoreCountData.State.RESET) {
            state = IgnoreCountData.State.DISABLED;
        }
        this.ignoreCountCheckbox.setSelection(state == IgnoreCountData.State.ENABLED);
        this.ignoreCountCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsLineBreakpointPage.this.ignoreCountText.setEnabled(JsLineBreakpointPage.this.ignoreCountCheckbox.getSelection());
                JsLineBreakpointPage.this.ignoreCountChanged();
            }
        });
        this.ignoreCountCheckbox.setText(Messages.JavascriptLineBreakpointPage_IgnoreCount);
        this.ignoreCountText = new Text(parent, 2052);
        this.ignoreCountText.setLayoutData((Object)new GridData(4, 4, false, false));
        this.ignoreCountText.setTextLimit(10);
        this.ignoreCountText.setEnabled(this.ignoreCountCheckbox.getSelection());
        if (ignoreCount > 0) {
            this.ignoreCountText.setText(String.valueOf(ignoreCount));
        }
        this.ignoreCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsLineBreakpointPage.this.ignoreCountChanged();
            }
        });
    }

    private void ignoreCountChanged() {
        boolean isOn = this.ignoreCountCheckbox.getSelection();
        if (!isOn) {
            this.removeErrorMessage(Messages.JavascriptLineBreakpointPage_IgnoreCountErrorMessage);
            return;
        }
        String value = this.ignoreCountText.getText();
        if (!ChromiumDebugPluginUtil.isInteger((String)value)) {
            this.addErrorMessage(Messages.JavascriptLineBreakpointPage_IgnoreCountErrorMessage);
            return;
        }
        int ignoreCount = Integer.valueOf(value);
        if (ignoreCount < 1) {
            this.addErrorMessage(Messages.JavascriptLineBreakpointPage_IgnoreCountErrorMessage);
        } else {
            this.removeErrorMessage(Messages.JavascriptLineBreakpointPage_IgnoreCountErrorMessage);
        }
    }

    private void addErrorMessage(String message) {
        this.errorMessages.remove(message);
        this.errorMessages.add(message);
        this.setErrorMessage(message);
    }

    private void removeErrorMessage(String message) {
        this.errorMessages.remove(message);
        if (this.errorMessages.isEmpty()) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(this.errorMessages.get(this.errorMessages.size() - 1));
        }
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setValid(newMessage == null);
    }

    private void createConditionControls(Composite parent) {
        this.conditionCheckbox = new Button(parent, 32);
        this.conditionCheckbox.setSelection(this.getBreakpoint().getCondition() != null);
        this.conditionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JsLineBreakpointPage.this.conditionText.setEnabled(JsLineBreakpointPage.this.conditionCheckbox.getSelection());
                JsLineBreakpointPage.this.conditionChanged();
            }
        });
        this.conditionCheckbox.setText(Messages.JavascriptLineBreakpointPage_EnableCondition);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.conditionCheckbox.setLayoutData((Object)gd);
        this.conditionText = new Text(parent, 2050);
        gd = new GridData(4, 4, true, true, 2, 1);
        this.conditionText.setLayoutData((Object)gd);
        this.conditionText.setTextLimit(300);
        this.conditionText.setFont(JFaceResources.getTextFont());
        this.conditionText.setEnabled(this.conditionCheckbox.getSelection());
        this.conditionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsLineBreakpointPage.this.conditionChanged();
            }
        });
        this.conditionText.setText(JsLineBreakpointPage.maskNull(this.getBreakpoint().getCondition()));
    }

    private static String maskNull(String value) {
        return value == null ? "" : value;
    }

    private void conditionChanged() {
        boolean isOn = this.conditionCheckbox.getSelection();
        if (!isOn) {
            this.removeErrorMessage(Messages.JavascriptLineBreakpointPage_BreakpointConditionErrorMessage);
            return;
        }
        String value = this.conditionText.getText();
        if (value == null) {
            this.addErrorMessage(Messages.JavascriptLineBreakpointPage_BreakpointConditionErrorMessage);
        } else {
            this.removeErrorMessage(Messages.JavascriptLineBreakpointPage_BreakpointConditionErrorMessage);
        }
    }

    static Composite createComposite(Composite parent, int columns, int horizontalSpan) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    protected ChromiumLineBreakpoint getBreakpoint() {
        return (ChromiumLineBreakpoint)this.getElement();
    }
}

