/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.liveedit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.debug.core.model.PushChangesPlan;
import org.eclipse.wst.jsdt.chromium.debug.core.model.SourceWrapSupport;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.LiveEditDiffViewer;
import org.eclipse.wst.jsdt.chromium.debug.ui.liveedit.Messages;

public class PushResultParser {
    static LiveEditDiffViewer.Input createViewerInput(UpdatableScript.ChangeDescription changeDescription, PushChangesPlan changesPlan, boolean previewMode) {
        int newPositionOffset;
        int oldPositionOffset;
        UpdatableScript.TextualDiff textualDiff;
        String newSource;
        String oldSource;
        SourceWrapSupport.Wrapper.Match wrapperMatch = changesPlan.getSourceWrapperMatch();
        String newSourceRaw = changesPlan.getNewSource();
        String oldSourceRaw = changesPlan.getScript().getSource();
        if (wrapperMatch == null) {
            oldSource = oldSourceRaw;
            newSource = newSourceRaw;
            textualDiff = changeDescription.getTextualDiff();
            oldPositionOffset = 0;
            newPositionOffset = 0;
        } else {
            String oldSourceComment = NLS.bind((String)Messages.PushResultParser_WRAPPING_DETECTED, (Object)wrapperMatch.getWrapper().getName());
            oldSource = String.valueOf(oldSourceComment) + oldSourceRaw;
            oldPositionOffset = oldSourceComment.length();
            String newSourceComment = Messages.PushResultParser_WRAPPING_AUTOGENERATED;
            newSource = String.valueOf(newSourceComment) + wrapperMatch.wrap(newSourceRaw);
            newPositionOffset = newSourceComment.length();
            textualDiff = PushResultParser.shiftNewPositions(changeDescription.getTextualDiff(), oldSourceComment.length(), newSourceComment.length(), wrapperMatch.getPrefixLength(), wrapperMatch.getSuffixLength(), oldSourceRaw.length(), newSourceRaw.length());
        }
        TreeBuilder builder = new TreeBuilder(previewMode, oldPositionOffset, newPositionOffset);
        final LiveEditDiffViewer.FunctionNode rootFunction = builder.build(changeDescription);
        return new InputBase(newSource, oldSource){

            @Override
            public LiveEditDiffViewer.FunctionNode getRootFunction() {
                return rootFunction;
            }

            @Override
            public UpdatableScript.TextualDiff getTextualDiff() {
                return textualDiff;
            }
        };
    }

    static LiveEditDiffViewer.Input createCompileErrorViewerInput(final UpdatableScript.CompileErrorFailure compileError, PushChangesPlan changesPlan, boolean previewMode) {
        final String newSource = changesPlan.getNewSource();
        final String oldSource = changesPlan.getScript().getSource();
        final int startOffset = compileError.getStartPosition().getOffset();
        final int endOffset = compileError.getEndPosition() == null ? startOffset + 1 : compileError.getEndPosition().getOffset();
        final LiveEditDiffViewer.SourcePosition sourcePosition = new LiveEditDiffViewer.SourcePosition(){

            @Override
            public int getStart() {
                return startOffset;
            }

            @Override
            public int getEnd() {
                return endOffset;
            }
        };
        final UpdatableScript.TextualDiff fakeTextualDiff = new UpdatableScript.TextualDiff(){

            public List<Long> getChunks() {
                return Arrays.asList(0L, oldSource.length(), newSource.length());
            }
        };
        final LiveEditDiffViewer.FunctionNode fakeFunctionNode = new LiveEditDiffViewer.FunctionNode(){

            @Override
            public String getName() {
                return compileError.getCompilerMessage();
            }

            @Override
            public String getStatus() {
                return Messages.PushResultParser_COMPILE_ERROR;
            }

            @Override
            public List<? extends LiveEditDiffViewer.FunctionNode> children() {
                return Collections.emptyList();
            }

            @Override
            public LiveEditDiffViewer.SourcePosition getPosition(LiveEditDiffViewer.Side side) {
                switch (side) {
                    case NEW: {
                        return sourcePosition;
                    }
                }
                return null;
            }

            @Override
            public LiveEditDiffViewer.FunctionNode getParent() {
                return null;
            }
        };
        return new InputBase(newSource, oldSource){

            @Override
            public LiveEditDiffViewer.FunctionNode getRootFunction() {
                return fakeFunctionNode;
            }

            @Override
            public UpdatableScript.TextualDiff getTextualDiff() {
                return fakeTextualDiff;
            }
        };
    }

    private static UpdatableScript.TextualDiff shiftNewPositions(UpdatableScript.TextualDiff textualDiff, int oldCommentLength, int newCommentLength, int prefixLength, int suffixLength, int originalOldLength, int originalNewLength) {
        List originalChunks = textualDiff.getChunks();
        final ArrayList<Long> shiftedChunks = new ArrayList<Long>(originalChunks.size() + 3 + 3);
        shiftedChunks.add(0L);
        shiftedChunks.add(Long.valueOf(oldCommentLength + prefixLength));
        shiftedChunks.add(Long.valueOf(newCommentLength + prefixLength));
        int i = 0;
        while (i < originalChunks.size()) {
            shiftedChunks.add((Long)originalChunks.get(i + 0) + (long)oldCommentLength);
            shiftedChunks.add((Long)originalChunks.get(i + 1) + (long)oldCommentLength);
            shiftedChunks.add((Long)originalChunks.get(i + 2) + (long)newCommentLength);
            i += 3;
        }
        shiftedChunks.add((long)originalOldLength + (long)oldCommentLength - (long)suffixLength);
        shiftedChunks.add((long)originalOldLength + (long)oldCommentLength);
        shiftedChunks.add((long)originalNewLength + (long)newCommentLength + (long)prefixLength + (long)suffixLength);
        return new UpdatableScript.TextualDiff(){

            public List<Long> getChunks() {
                return shiftedChunks;
            }
        };
    }

    private static abstract class InputBase
    implements LiveEditDiffViewer.Input {
        private final String newSource;
        private final String oldSource;

        InputBase(String newSource, String oldSource) {
            this.newSource = newSource;
            this.oldSource = oldSource;
        }

        @Override
        public LiveEditDiffViewer.SourceText getNewSource() {
            return new LiveEditDiffViewer.SourceText(){

                @Override
                public String getText() {
                    return newSource;
                }

                @Override
                public String getTitle() {
                    return Messages.PushResultParser_LOCAL_FILE;
                }
            };
        }

        @Override
        public LiveEditDiffViewer.SourceText getOldSource() {
            return new LiveEditDiffViewer.SourceText(){

                @Override
                public String getText() {
                    return oldSource;
                }

                @Override
                public String getTitle() {
                    return Messages.PushResultParser_SCRIPT_IN_VM;
                }
            };
        }
    }

    private static class TreeBuilder {
        private final StatusRenderer statusRenderer;
        private final boolean hideOldVersion;
        private final int oldPositionOffset;
        private final int newPositionOffset;
        private static final StatusRenderer PREVIEW_STATUS_RENDERER = new StatusRenderer(){

            @Override
            String getStatus(UpdatableScript.FunctionNode<?> rawFunction, NodeImpl nodeImpl) {
                UpdatableScript.OldFunctionNode asOldFunction = rawFunction.asOldFunction();
                if (asOldFunction == null) {
                    return Messages.PushResultParser_NEW_FUNCTION;
                }
                switch (rawFunction.asOldFunction().getStatus()) {
                    case UNCHANGED: {
                        return "";
                    }
                    case NESTED_CHANGED: {
                        return Messages.PushResultParser_PREVIEW_CHANGED;
                    }
                    case CODE_PATCHED: {
                        return Messages.PushResultParser_PREVIEW_PATCHED;
                    }
                    case DAMAGED: {
                        String message = nodeImpl.getPosition(LiveEditDiffViewer.Side.NEW) == null ? Messages.PushResultParser_PREVIEW_DAMAGED : Messages.PushResultParser_PREVIEW_DAMAGED_2;
                        String explanation = rawFunction.asOldFunction().getStatusExplanation();
                        if (explanation != null) {
                            message = String.valueOf(message) + "\n[" + explanation + "]";
                        }
                        return message;
                    }
                }
                return Messages.PushResultParser_PREVIEW_UNKNOWN;
            }
        };
        private static final StatusRenderer RESULT_STATUS_RENDERER = new StatusRenderer(){

            @Override
            String getStatus(UpdatableScript.FunctionNode<?> rawFunction, NodeImpl nodeImpl) {
                UpdatableScript.OldFunctionNode asOldFunction = rawFunction.asOldFunction();
                if (asOldFunction == null) {
                    return Messages.PushResultParser_RESULT_NEW_FUNCTION;
                }
                switch (asOldFunction.getStatus()) {
                    case UNCHANGED: {
                        return "";
                    }
                    case NESTED_CHANGED: {
                        return Messages.PushResultParser_RESULT_CHANGED;
                    }
                    case CODE_PATCHED: {
                        return Messages.PushResultParser_RESULT_PATHCED;
                    }
                    case DAMAGED: {
                        String message = nodeImpl.getNewPositionInternal() == null ? Messages.PushResultParser_RESULT_DAMAGED : Messages.PushResultParser_RESULT_DAMAGED_2;
                        String explanation = asOldFunction.getStatusExplanation();
                        if (explanation != null) {
                            message = String.valueOf(message) + "\n[" + explanation + "]";
                        }
                        return message;
                    }
                }
                return Messages.PushResultParser_RESULT_UNKNOWN;
            }
        };

        public TreeBuilder(boolean previewOnly, int oldPositionOffset, int newPositionOffset) {
            this.statusRenderer = previewOnly ? PREVIEW_STATUS_RENDERER : RESULT_STATUS_RENDERER;
            this.hideOldVersion = !previewOnly;
            this.oldPositionOffset = oldPositionOffset;
            this.newPositionOffset = newPositionOffset;
        }

        public LiveEditDiffViewer.FunctionNode build(UpdatableScript.ChangeDescription changeDescription) {
            return this.buildNode(changeDescription.getChangeTree(), Messages.PushResultParser_SCRIPT);
        }

        private NodeImpl buildNode(UpdatableScript.OldFunctionNode oldFunction, String predefinedFunctionName) {
            ArrayList<Object> childListFirst = new ArrayList<Object>();
            for (UpdatableScript.OldFunctionNode oldChild : oldFunction.children()) {
                NodeImpl nodeImpl = this.buildNode(oldChild, null);
                childListFirst.add(nodeImpl);
            }
            ArrayList<NodeImpl> childListSecond = new ArrayList<NodeImpl>();
            for (UpdatableScript.NewFunctionNode newChild : oldFunction.newChildren()) {
                NodeImpl nodeImpl = this.buildNode(newChild, this.newPositionOffset);
                childListSecond.add(nodeImpl);
            }
            ArrayList childList = new ArrayList();
            int pos1 = 0;
            int pos2 = 0;
            while (true) {
                if (pos1 == childListFirst.size()) {
                    childList.addAll(childListSecond.subList(pos2, childListSecond.size()));
                    break;
                }
                if (pos2 == childListSecond.size()) {
                    childList.addAll(childListFirst.subList(pos1, childListFirst.size()));
                    break;
                }
                LiveEditDiffViewer.SourcePosition firstChildSourcePos = ((NodeImpl)childListFirst.get(pos1)).getPosition(LiveEditDiffViewer.Side.NEW);
                if (firstChildSourcePos == null) {
                    childList.add((NodeImpl)childListFirst.get(pos1));
                    ++pos1;
                    continue;
                }
                if (firstChildSourcePos.getStart() < ((NodeImpl)childListSecond.get(pos2)).getPosition(LiveEditDiffViewer.Side.NEW).getStart()) {
                    childList.add((NodeImpl)childListFirst.get(pos1));
                    ++pos1;
                    continue;
                }
                childList.add((NodeImpl)childListSecond.get(pos2));
                ++pos2;
            }
            return new NodeImpl((UpdatableScript.FunctionNode)oldFunction, TreeBuilder.createPosition(oldFunction.getPositions(), this.oldPositionOffset), TreeBuilder.createPosition(oldFunction.getNewPositions(), this.newPositionOffset), childList, predefinedFunctionName);
        }

        private NodeImpl buildNode(UpdatableScript.NewFunctionNode newFunction, int newPositionOffset) {
            ArrayList<NodeImpl> childList = new ArrayList<NodeImpl>();
            for (UpdatableScript.NewFunctionNode newChild : newFunction.children()) {
                NodeImpl nodeImpl = this.buildNode(newChild, newPositionOffset);
                childList.add(nodeImpl);
            }
            return new NodeImpl((UpdatableScript.FunctionNode)newFunction, null, TreeBuilder.createPosition(newFunction.getPositions(), newPositionOffset), childList, null);
        }

        private static LiveEditDiffViewer.SourcePosition createPosition(final UpdatableScript.FunctionPositions positions, final int offset) {
            if (positions == null) {
                return null;
            }
            return new LiveEditDiffViewer.SourcePosition(){

                @Override
                public int getStart() {
                    return (int)positions.getStart() + offset;
                }

                @Override
                public int getEnd() {
                    return (int)positions.getEnd() + offset;
                }
            };
        }

        private class NodeImpl
        implements LiveEditDiffViewer.FunctionNode {
            private final UpdatableScript.FunctionNode<?> rawFunction;
            private final String name;
            private final LiveEditDiffViewer.SourcePosition oldPosition;
            private final LiveEditDiffViewer.SourcePosition newPosition;
            private final List<? extends LiveEditDiffViewer.FunctionNode> childList;
            private LiveEditDiffViewer.FunctionNode parent = null;

            private NodeImpl(UpdatableScript.FunctionNode<?> rawFunction, LiveEditDiffViewer.SourcePosition oldPosition, LiveEditDiffViewer.SourcePosition newPosition, List<? extends NodeImpl> childList, String predefinedFunctionName) {
                this.rawFunction = rawFunction;
                this.name = predefinedFunctionName == null ? rawFunction.getName() : predefinedFunctionName;
                this.oldPosition = oldPosition;
                this.newPosition = newPosition;
                this.childList = childList;
                for (NodeImpl nodeImpl : childList) {
                    nodeImpl.parent = this;
                }
            }

            @Override
            public List<? extends LiveEditDiffViewer.FunctionNode> children() {
                return this.childList;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getStatus() {
                return TreeBuilder.this.statusRenderer.getStatus(this.rawFunction, this);
            }

            @Override
            public LiveEditDiffViewer.FunctionNode getParent() {
                return this.parent;
            }

            @Override
            public LiveEditDiffViewer.SourcePosition getPosition(LiveEditDiffViewer.Side side) {
                switch (side) {
                    case OLD: {
                        if (this.newPosition != null && TreeBuilder.this.hideOldVersion && this.rawFunction.asOldFunction() != null && this.rawFunction.asOldFunction().getStatus() != UpdatableScript.ChangeStatus.DAMAGED) {
                            return null;
                        }
                        return this.oldPosition;
                    }
                    case NEW: {
                        return this.newPosition;
                    }
                }
                throw new RuntimeException();
            }

            protected LiveEditDiffViewer.SourcePosition getOldPositionInternal() {
                return this.oldPosition;
            }

            protected LiveEditDiffViewer.SourcePosition getNewPositionInternal() {
                return this.newPosition;
            }
        }

        private static abstract class StatusRenderer {
            private StatusRenderer() {
            }

            abstract String getStatus(UpdatableScript.FunctionNode<?> var1, NodeImpl var2);
        }
    }
}

