/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.preferences;

import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.internal.schema.catalog.EntryParser;
import org.eclipse.wst.json.core.internal.schema.catalog.UserEntries;
import org.eclipse.wst.json.core.internal.schema.catalog.UserEntry;
import org.eclipse.wst.json.schemaprocessor.internal.JSONSchemaProcessor;
import org.eclipse.wst.json.ui.internal.JSONUIMessages;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.json.ui.internal.preferences.EntryDialog;

public class JSONCatalogPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TreeViewer viewer;
    private UserEntries entries;
    private UserEntry selectedEntry;

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.storePreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    private void storePreferences() {
        IEclipsePreferences prefs = JSONCatalogPreferencePage.getPreferences();
        try {
            String value = new EntryParser().serialize(this.entries.getEntries());
            prefs.put("catalogEntries", value);
            JSONCorePlugin.getDefault().clearCatalogCache();
            JSONSchemaProcessor.clearCache();
        }
        catch (Exception e) {
            JSONCatalogPreferencePage.logException(e);
        }
    }

    private static IEclipsePreferences getPreferences() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.wst.json.ui");
        return preferences;
    }

    private static void logException(Exception e) {
        Status status = new Status(4, "org.eclipse.wst.json.ui", e.getLocalizedMessage(), (Throwable)e);
        JSONUIPlugin.getDefault().getLog().log((IStatus)status);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Group entriesGroup = new Group(composite, 0);
        entriesGroup.setText(JSONUIMessages.JSON_Catalog_Entries);
        GridLayout gl = new GridLayout(2, false);
        entriesGroup.setLayout((Layout)gl);
        entriesGroup.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer((Composite)entriesGroup, 2816);
        this.viewer.setContentProvider((IContentProvider)new EntriesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EntriesLabelProvider());
        this.entries = new UserEntries();
        this.entries.getEntries().addAll(EntryParser.getUserEntries());
        this.viewer.setInput((Object)this.entries);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.expandAll();
        Composite buttonComposite = new Composite((Composite)entriesGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(JSONUIMessages.Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String fileMatch;
                EntryDialog dialog = new EntryDialog(JSONCatalogPreferencePage.this.getShell(), null, JSONCatalogPreferencePage.this.entries);
                int ok = dialog.open();
                if (ok == 0 && (fileMatch = dialog.getFileMatch()) != null) {
                    URI url = dialog.getURL();
                    UserEntry entry = new UserEntry();
                    entry.setUrl(url);
                    entry.setFileMatch(fileMatch);
                    JSONCatalogPreferencePage.this.entries.add(entry);
                    JSONCatalogPreferencePage.this.viewer.refresh();
                }
            }
        });
        final Button editButton = new Button(buttonComposite, 8);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.setText(JSONUIMessages.Edit);
        editButton.setEnabled(false);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String fileMatch;
                if (JSONCatalogPreferencePage.this.selectedEntry == null) {
                    return;
                }
                EntryDialog dialog = new EntryDialog(JSONCatalogPreferencePage.this.getShell(), JSONCatalogPreferencePage.this.selectedEntry, JSONCatalogPreferencePage.this.entries);
                int ok = dialog.open();
                if (ok == 0 && (fileMatch = dialog.getFileMatch()) != null) {
                    URI url = dialog.getURL();
                    UserEntry entry = JSONCatalogPreferencePage.this.selectedEntry;
                    entry.setUrl(url);
                    entry.setFileMatch(fileMatch);
                    JSONCatalogPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(JSONUIMessages.Remove);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JSONCatalogPreferencePage.this.selectedEntry != null) {
                    JSONCatalogPreferencePage.this.entries.getEntries().remove(JSONCatalogPreferencePage.this.selectedEntry);
                    JSONCatalogPreferencePage.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection treeSelection;
                Object object;
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
                JSONCatalogPreferencePage.this.selectedEntry = null;
                ISelection selection = event.getSelection();
                if (selection instanceof ITreeSelection && (object = (treeSelection = (ITreeSelection)selection).getFirstElement()) instanceof UserEntry) {
                    JSONCatalogPreferencePage.this.selectedEntry = (UserEntry)object;
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                }
            }
        });
        return composite;
    }

    class EntriesContentProvider
    implements ITreeContentProvider {
        EntriesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof UserEntries) {
                return ((UserEntries)parentElement).getEntries().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof UserEntries;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class EntriesLabelProvider
    extends LabelProvider {
        EntriesLabelProvider() {
        }

        public Image getImage(Object element) {
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof UserEntry) {
                UserEntry entry = (UserEntry)element;
                String result = entry.getFileMatch();
                return result;
            }
            return super.getText(element);
        }
    }
}

