/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.ui.internal.contentoutline.IStyledJFaceNodeAdapter;
import org.eclipse.wst.json.ui.internal.contentoutline.JFaceNodeAdapterFactory;
import org.eclipse.wst.json.ui.internal.contentoutline.RefreshStructureJob;
import org.eclipse.wst.json.ui.internal.editor.JSONEditorPluginImageHelper;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;

public class JFaceNodeAdapter
implements IJFaceNodeAdapter,
IStyledJFaceNodeAdapter {
    static final Class ADAPTER_KEY = IJFaceNodeAdapter.class;
    private static final boolean DEBUG = JFaceNodeAdapter.getDebugValue();
    JFaceNodeAdapterFactory fAdapterFactory;
    RefreshStructureJob fRefreshJob = null;

    private static boolean getDebugValue() {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/outline");
        boolean result = value != null && value.equalsIgnoreCase("true");
        return result;
    }

    public JFaceNodeAdapter(JFaceNodeAdapterFactory adapterFactory) {
        this.fAdapterFactory = adapterFactory;
    }

    public Object[] getChildren(Object object) {
        ArrayList<IJSONNode> v = new ArrayList<IJSONNode>();
        if (object instanceof IJSONNode) {
            IJSONNode node = (IJSONNode)object;
            if (node.getNodeType() == 2) {
                node = ((IJSONPair)node).getValue();
            }
            if (node != null) {
                IJSONNode child = node.getFirstChild();
                while (child != null) {
                    IJSONNode n = child;
                    v.add(n);
                    child = child.getNextSibling();
                }
            }
        }
        return v.toArray();
    }

    public Object[] getElements(Object node) {
        return this.getChildren(node);
    }

    public Image getLabelImage(Object node) {
        Image image = null;
        if (node instanceof IJSONNode && (image = null) == null) {
            image = this.createImage((IJSONNode)node);
        }
        return image;
    }

    protected Image createImage(IJSONNode node) {
        Image image = null;
        switch (node.getNodeType()) {
            case 2: {
                IJSONPair pair = (IJSONPair)node;
                short nodeType = pair.getNodeValueType();
                image = JSONEditorPluginImageHelper.getInstance().getImage(nodeType);
                break;
            }
            default: {
                image = JSONEditorPluginImageHelper.getInstance().getImage(node.getNodeType());
            }
        }
        return image;
    }

    public String getLabelText(Object node) {
        return this.getStyledLabelText(node).getString();
    }

    @Override
    public StyledString getStyledLabelText(Object element) {
        StyledString styledString = new StyledString();
        if (element instanceof IJSONNode) {
            IJSONNode node = (IJSONNode)element;
            switch (node.getNodeType()) {
                case 2: {
                    IJSONPair pair = (IJSONPair)node;
                    String name = pair.getName();
                    if (name == null) break;
                    styledString.append(name);
                    String value = pair.getSimpleValue();
                    if (value == null) break;
                    styledString.append(" : ");
                    StyledString.Styler styler = this.fAdapterFactory.getStyler(pair.getValueRegionType());
                    styledString.append(value, styler);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    String value = ((IJSONValue)node).getSimpleValue();
                    if (value == null) break;
                    styledString.append(" : ");
                    StyledString.Styler styler = this.fAdapterFactory.getStyler(((IJSONValue)node).getValueRegionType());
                    styledString.append(value, styler);
                }
            }
        }
        return styledString;
    }

    public Object getParent(Object object) {
        if (object instanceof IJSONNode) {
            IJSONNode node = (IJSONNode)object;
            return node.getParentOrPairNode();
        }
        return null;
    }

    private synchronized RefreshStructureJob getRefreshJob() {
        if (this.fRefreshJob == null) {
            this.fRefreshJob = new RefreshStructureJob();
        }
        return this.fRefreshJob;
    }

    public boolean hasChildren(Object object) {
        IJSONNode node = (IJSONNode)object;
        if (node.getNodeType() == 2) {
            node = ((IJSONPair)node).getValue();
        }
        if (node == null) {
            return false;
        }
        IJSONNode child = node.getFirstChild();
        return child != null;
    }

    public boolean isAdapterForType(Object type) {
        if (type == null) {
            return false;
        }
        return type.equals(ADAPTER_KEY);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof IJSONNode) {
            Collection listeners = this.fAdapterFactory.getListeners();
            for (Object listener : listeners) {
                StructuredViewer structuredViewer;
                if (!(listener instanceof StructuredViewer) || eventType != 4 && eventType != 5 && eventType != 1) continue;
                if (DEBUG) {
                    System.out.println("JFaceNodeAdapter notified on event type > " + eventType);
                }
                if ((structuredViewer = (StructuredViewer)listener).getControl() == null) continue;
                this.getRefreshJob().refresh(structuredViewer, (IJSONNode)notifier);
            }
        }
    }
}

