/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;
import org.eclipse.jpt.jaxb.core.context.TypeName;

public class JavaTypeName
implements TypeName {
    protected String packageName;
    protected String qualifiedName;

    public JavaTypeName(JavaResourceAbstractType resourceType) {
        this.packageName = this.buildPackageName(resourceType);
        this.qualifiedName = this.buildQualifiedName(resourceType);
    }

    protected String buildPackageName(JavaResourceAbstractType resourceType) {
        return resourceType.getTypeBinding().getPackageName();
    }

    protected String buildQualifiedName(JavaResourceAbstractType resourceType) {
        return resourceType.getTypeBinding().getQualifiedName();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getSimpleName() {
        return TypeDeclarationTools.simpleName((String)this.qualifiedName);
    }

    @Override
    public String getTypeQualifiedName() {
        return this.packageName.length() == 0 ? this.qualifiedName : this.qualifiedName.substring(this.packageName.length() + 1);
    }

    @Override
    public String getFullyQualifiedName() {
        return this.qualifiedName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return ObjectTools.equals((Object)this.packageName, (Object)((JavaTypeName)obj).packageName) && ObjectTools.equals((Object)this.qualifiedName, (Object)((JavaTypeName)obj).qualifiedName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + ObjectTools.hashCode((Object)this.packageName);
        result = 31 * result + ObjectTools.hashCode((Object)this.qualifiedName);
        return result;
    }
}

