/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.stack;

import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.stack.Stack;

public class ListStack<E>
implements Stack<E>,
Serializable {
    private List<E> list;
    private static final long serialVersionUID = 1L;

    public ListStack(List<E> list) {
        this.list = list;
    }

    @Override
    public void push(E element) {
        this.list.add(element);
    }

    @Override
    public E pop() {
        int size = this.list.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return this.list.remove(--size);
    }

    @Override
    public E peek() {
        int size = this.list.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return this.list.get(--size);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return ListTools.reverse(this.list).toString();
    }
}

