/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import org.eclipse.jpt.common.utility.internal.reference.AbstractBooleanReference;
import org.eclipse.jpt.common.utility.reference.ModifiableBooleanReference;

public abstract class AbstractModifiableBooleanReference
extends AbstractBooleanReference
implements ModifiableBooleanReference {
    protected AbstractModifiableBooleanReference() {
    }

    @Override
    public boolean flip() {
        boolean v = !this.getValue();
        this.setValue(v);
        return v;
    }

    @Override
    public boolean and(boolean b) {
        boolean v = this.getValue() && b;
        this.setValue(v);
        return v;
    }

    @Override
    public boolean or(boolean b) {
        boolean v = this.getValue() || b;
        this.setValue(v);
        return v;
    }

    @Override
    public boolean xor(boolean b) {
        boolean v = this.getValue() ^ b;
        this.setValue(v);
        return v;
    }

    @Override
    public boolean setNot(boolean value) {
        return this.setValue(!value);
    }

    @Override
    public boolean setTrue() {
        return this.setValue(true);
    }

    @Override
    public boolean setFalse() {
        return this.setValue(false);
    }

    @Override
    public boolean commit(boolean newValue, boolean expectedValue) {
        if (this.getValue() == expectedValue) {
            this.setValue(newValue);
            return true;
        }
        return false;
    }

    @Override
    public boolean swap(ModifiableBooleanReference other) {
        boolean otherValue;
        if (other == this) {
            return this.getValue();
        }
        boolean thisValue = this.getValue();
        if (thisValue != (otherValue = other.getValue())) {
            other.setValue(thisValue);
            this.setValue(otherValue);
        }
        return otherValue;
    }
}

