/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import org.eclipse.jpt.common.utility.predicate.IntPredicate;
import org.eclipse.jpt.common.utility.reference.IntReference;

public abstract class AbstractIntReference
implements IntReference {
    protected AbstractIntReference() {
    }

    @Override
    public boolean equals(int i) {
        return this.getValue() == i;
    }

    @Override
    public boolean notEqual(int i) {
        return this.getValue() != i;
    }

    @Override
    public boolean isZero() {
        return this.getValue() == 0;
    }

    @Override
    public boolean isNotZero() {
        return this.getValue() != 0;
    }

    @Override
    public boolean isGreaterThan(int i) {
        return this.getValue() > i;
    }

    @Override
    public boolean isGreaterThanOrEqual(int i) {
        return this.getValue() >= i;
    }

    @Override
    public boolean isLessThan(int i) {
        return this.getValue() < i;
    }

    @Override
    public boolean isLessThanOrEqual(int i) {
        return this.getValue() <= i;
    }

    @Override
    public boolean isPositive() {
        return this.isGreaterThan(0);
    }

    @Override
    public boolean isNotPositive() {
        return this.isLessThanOrEqual(0);
    }

    @Override
    public boolean isNegative() {
        return this.isLessThan(0);
    }

    @Override
    public boolean isNotNegative() {
        return this.isGreaterThanOrEqual(0);
    }

    @Override
    public boolean isMemberOf(IntPredicate predicate) {
        return predicate.evaluate(this.getValue());
    }

    @Override
    public boolean isNotMemberOf(IntPredicate predicate) {
        return !this.isMemberOf(predicate);
    }

    @Override
    public int compareTo(IntReference other) {
        int otherValue;
        int thisValue = this.getValue();
        return thisValue < (otherValue = other.getValue()) ? -1 : (thisValue == otherValue ? 0 : 1);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.getValue()) + ']';
    }
}

