/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class MethodClosure<A>
implements Closure<A>,
Serializable {
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final Object[] arguments;
    private static final long serialVersionUID = 1L;

    public MethodClosure(String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        if (methodName == null || ArrayTools.isOrContainsNull(parameterTypes) || arguments == null) {
            throw new NullPointerException();
        }
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    @Override
    public void execute(A argument) {
        ObjectTools.execute(argument, this.methodName, this.parameterTypes, this.arguments);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodClosure)) {
            return false;
        }
        MethodClosure other = (MethodClosure)o;
        return ObjectTools.equals(this.methodName, other.methodName) && Arrays.equals(this.parameterTypes, other.parameterTypes) && Arrays.equals(this.arguments, other.arguments);
    }

    public int hashCode() {
        return this.methodName.hashCode() ^ Arrays.hashCode(this.parameterTypes) ^ Arrays.hashCode(this.arguments);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, ClassTools.buildMethodSignature(this.methodName, this.parameterTypes));
    }
}

