/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.wst.sse.core.internal.util.PathHelper;

public class URLHelper {
    private static final String FILE_PROTOCOL_SEARCH_SIG = "file:/";
    private static final String FILE_PROTOCOL_SIG = "file:///";
    private static String RELATIVE_PATH_SIG = "..";
    private static final String FORWARD_SLASH = "/";
    private URL fBaseUrl = null;
    private String fBaseUrlString = null;
    private URL fDocRoot = null;
    private String fDocRootString = null;

    public URLHelper(String baseUrl) {
        this.initialize(baseUrl, null);
    }

    public URLHelper(String baseUrl, String docRoot) {
        this.initialize(baseUrl, docRoot);
    }

    public String adjustFileProtocolUrl(String url) {
        if (((String)url).startsWith(FILE_PROTOCOL_SEARCH_SIG)) {
            url = FILE_PROTOCOL_SIG + ((String)url).substring(FILE_PROTOCOL_SEARCH_SIG.length());
        }
        return url;
    }

    private String convert(String url, URL baseUrl, String urlString) {
        Object absUrl = url;
        if (baseUrl != null) {
            try {
                if (baseUrl.getProtocol().equalsIgnoreCase("file")) {
                    if (url.startsWith(FORWARD_SLASH)) {
                        url = url.substring(1);
                    }
                    String tempUrl = url;
                    if ("".equals(url)) {
                        tempUrl = " ";
                    }
                    URL newUrl = new URL(baseUrl, tempUrl);
                    absUrl = this.adjustFileProtocolUrl(newUrl.toString());
                } else {
                    URL newUrl = new URL(this.fBaseUrl, url);
                    absUrl = newUrl.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {}
            absUrl = PathHelper.switchToForwardSlashes((String)absUrl);
        } else {
            if (urlString != null) {
                url = PathHelper.removeLeadingSeparator((String)url);
                File fle = new File(urlString, url);
                absUrl = fle.getPath();
            }
            if (((String)(absUrl = PathHelper.switchToForwardSlashes((String)absUrl))).endsWith(FORWARD_SLASH + RELATIVE_PATH_SIG)) {
                absUrl = (String)absUrl + FORWARD_SLASH;
            }
        }
        absUrl = PathHelper.adjustPath((String)absUrl);
        return absUrl;
    }

    private void initialize(String baseUrl, String docRoot) {
        String temp;
        try {
            temp = PathHelper.appendTrailingURLSlash((String)baseUrl);
            this.fBaseUrl = new URL(temp);
        }
        catch (MalformedURLException malformedURLException) {}
        if (this.fBaseUrl == null) {
            this.fBaseUrlString = baseUrl;
        }
        if (docRoot != null) {
            try {
                temp = PathHelper.appendTrailingURLSlash((String)docRoot);
                this.fDocRoot = new URL(temp);
            }
            catch (MalformedURLException malformedURLException) {}
            if (this.fDocRoot == null) {
                this.fDocRootString = docRoot;
            }
        }
    }

    public String toAbsolute(String url) {
        String absUrl = url;
        URL newUrl = null;
        try {
            newUrl = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {}
        if (newUrl == null) {
            absUrl = this.fDocRoot == null && this.fDocRootString == null ? this.convert(url, this.fBaseUrl, this.fBaseUrlString) : (url.startsWith(FORWARD_SLASH) ? this.convert(url, this.fDocRoot, this.fDocRootString) : this.convert(url, this.fBaseUrl, this.fBaseUrlString));
        }
        return absUrl;
    }

    public String toRelative(String url, String documentUrl) {
        String output = url;
        try {
            URL inputUrl = new URL(url);
            URL docUrl = new URL(documentUrl);
            if (!inputUrl.getProtocol().equals(docUrl.getProtocol()) || !inputUrl.getHost().equals(docUrl.getHost()) || inputUrl.getPort() != docUrl.getPort()) {
                return output;
            }
            String inputName = inputUrl.getFile();
            String docName = docUrl.getFile();
            output = PathHelper.convertToRelative((String)inputName, (String)docName);
        }
        catch (MalformedURLException malformedURLException) {
            output = null;
        }
        return output;
    }
}

