/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentFamilyType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererClassType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererTypeType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.AddEditRendererDialog;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RendererSection
extends AbstractFacesConfigSection {
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private TableViewer tableViewer;
    private Button removeButton;
    private Button editButton;

    public RendererSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, null, null);
        this.getSection().setText(EditorMessages.RendererSection_Name);
        this.getSection().setDescription(EditorMessages.RendererSection_Description);
    }

    @Override
    protected void createContents(Composite container, FormToolkit toolkit) {
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        container.setLayout((Layout)gl);
        GridData td = new GridData(1808);
        container.setLayoutData((Object)td);
        toolkit.paintBordersFor(container);
        Composite RendererSection2 = toolkit.createComposite(container);
        GridLayout gl2 = new GridLayout();
        gl2.horizontalSpacing = 0;
        gl2.verticalSpacing = 0;
        gl2.marginWidth = 0;
        gl2.marginHeight = 0;
        gl2.numColumns = 2;
        RendererSection2.setLayout((Layout)gl2);
        GridData gd = new GridData(1810);
        RendererSection2.setLayoutData((Object)gd);
        this.createTableSection(RendererSection2, toolkit);
        this.createButtonsSection(RendererSection2, toolkit);
    }

    private void createTableSection(Composite container, FormToolkit toolkit) {
        Composite tableContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1808);
        tableContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(tableContainer);
        GridLayout gl = new GridLayout();
        tableContainer.setLayout((Layout)gl);
        Table table = new Table(tableContainer, 68352);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableColumn nameCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        nameCol.setText(EditorMessages.RendererSection_Table_NameColumn);
        TableColumn valueCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        valueCol.setText(EditorMessages.RendererSection_Table_ComponentFamilyColumn);
        TableColumn suggestedValueCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        suggestedValueCol.setText(EditorMessages.RendererSection_Table_TypeColumn);
        TableColumn classCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        classCol.setText(EditorMessages.RendererSection_Table_ClassColumn);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RendererSection.this.updateButtons();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (((IStructuredSelection)RendererSection.this.tableViewer.getSelection()).size() > 0) {
                    RendererSection.this.editButtonSelected();
                }
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FacesConfigPackage.eINSTANCE.getRendererType().isInstance(element);
            }
        });
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void updateButtons() {
        if (((IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void createButtonsSection(Composite container, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1042);
        operationContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        Button addButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Add_more, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        addButton.setLayoutData((Object)gd);
        this.editButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Edit_more, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Remove, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RendererSection.this.addButtonSelected();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RendererSection.this.editButtonSelected();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RendererSection.this.removeButtonSelected();
            }
        });
    }

    private EReference getEReference() {
        EReference reference = null;
        if (this.getInput() instanceof RenderKitType) {
            reference = FacesConfigPackage.eINSTANCE.getRenderKitType_Renderer();
        }
        return reference;
    }

    @Override
    public void refreshAll() {
        this.tableViewer.setInput(this.getInput());
        this.updateButtons();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.tableViewer.refresh();
        this.updateButtons();
    }

    private void addButtonSelected() {
        Shell shell = EditorPlugin.getActiveShell();
        AddEditRendererDialog dialog = new AddEditRendererDialog(shell, this.getPage(), true);
        dialog.setProject((IProject)this.getPage().getEditor().getAdapter(IProject.class));
        if (dialog.open() == 0) {
            Command addCommand;
            RendererType newRenderer = FacesConfigFactory.eINSTANCE.createRendererType();
            if (dialog.getRendererName().length() > 0) {
                DisplayNameType diaplayName = FacesConfigFactory.eINSTANCE.createDisplayNameType();
                diaplayName.setTextContent(dialog.getRendererName());
                newRenderer.getDisplayName().add((Object)diaplayName);
            }
            if (dialog.getRendererClass().length() > 0) {
                RendererClassType RendererClassType2 = FacesConfigFactory.eINSTANCE.createRendererClassType();
                RendererClassType2.setTextContent(dialog.getRendererClass());
                newRenderer.setRendererClass(RendererClassType2);
            }
            if (dialog.getComponentFamily().length() > 0) {
                ComponentFamilyType componentFamilyType = FacesConfigFactory.eINSTANCE.createComponentFamilyType();
                componentFamilyType.setTextContent(dialog.getComponentFamily());
                newRenderer.setComponentFamily(componentFamilyType);
            }
            if (dialog.getRendererType().length() > 0) {
                RendererTypeType rendererType = FacesConfigFactory.eINSTANCE.createRendererTypeType();
                rendererType.setTextContent(dialog.getRendererType());
                newRenderer.setRendererType(rendererType);
            }
            if ((addCommand = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getInput(), (Object)this.getEReference(), (Object)newRenderer)).canExecute()) {
                this.getEditingDomain().getCommandStack().execute(addCommand);
            }
        }
    }

    private void editButtonSelected() {
        RendererType renderer = (RendererType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        Assert.isNotNull((Object)renderer);
        Shell shell = EditorPlugin.getActiveShell();
        AddEditRendererDialog dialog = new AddEditRendererDialog(shell, this.getPage(), false);
        dialog.setProject((IProject)this.getPage().getEditor().getAdapter(IProject.class));
        if (renderer.getDisplayName() != null && renderer.getDisplayName().size() > 0) {
            String name = ((DisplayNameType)renderer.getDisplayName().get(0)).getTextContent();
            if (name == null) {
                name = "";
            }
            dialog.setRendererName(name);
        }
        if (renderer.getRendererClass() != null) {
            dialog.setRendererClass(renderer.getRendererClass().getTextContent());
        }
        if (renderer.getComponentFamily() != null) {
            dialog.setComponentFamily(renderer.getComponentFamily().getTextContent());
        }
        if (renderer.getRendererType() != null) {
            dialog.setRendererType(renderer.getRendererType().getTextContent());
        }
        if (dialog.open() == 0) {
            ArrayList<Command> commands = new ArrayList<Command>(4);
            if (renderer.getDisplayName() != null && renderer.getDisplayName().size() > 0) {
                DisplayNameType diaplayName = FacesConfigFactory.eINSTANCE.createDisplayNameType();
                diaplayName.setTextContent(dialog.getRendererName());
                Command cmd1 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)renderer.getDisplayName().get(0), (Object)FacesConfigPackage.eINSTANCE.getRendererType_DisplayName(), (Object)diaplayName);
                commands.add(cmd1);
            } else if (dialog.getRendererName().length() > 0) {
                DisplayNameType displayName = FacesConfigFactory.eINSTANCE.createDisplayNameType();
                displayName.setTextContent(dialog.getRendererName());
                EList dl = renderer.getDisplayName();
                dl.add((Object)displayName);
                Command cmd2 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)renderer.getDisplayName(), (Object)FacesConfigPackage.eINSTANCE.getRendererType_DisplayName(), (Collection)dl);
                commands.add(cmd2);
            }
            if (renderer.getRendererClass() != null) {
                Command cmd3 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)renderer.getRendererClass(), (Object)FacesConfigPackage.eINSTANCE.getRendererClassType_TextContent(), (Object)dialog.getRendererClass());
                commands.add(cmd3);
            } else if (dialog.getRendererClass().length() > 0) {
                RendererClassType RendererClassType2 = FacesConfigFactory.eINSTANCE.createRendererClassType();
                RendererClassType2.setTextContent(dialog.getRendererClass());
                Command cmd4 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)renderer, (Object)FacesConfigPackage.eINSTANCE.getRendererType_RendererClass(), (Object)RendererClassType2);
                commands.add(cmd4);
            }
            if (renderer.getComponentFamily() != null) {
                Command cmd5 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)renderer.getComponentFamily(), (Object)FacesConfigPackage.eINSTANCE.getDefaultValueType_TextContent(), (Object)dialog.getComponentFamily());
                commands.add(cmd5);
            } else if (dialog.getComponentFamily().length() > 0) {
                ComponentFamilyType componentFamily = FacesConfigFactory.eINSTANCE.createComponentFamilyType();
                componentFamily.setTextContent(dialog.getComponentFamily());
                Command cmd6 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)renderer, (Object)FacesConfigPackage.eINSTANCE.getRendererType_ComponentFamily(), (Object)componentFamily);
                commands.add(cmd6);
            }
            if (renderer.getRendererType() != null) {
                Command cmd7 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)renderer.getRendererType(), (Object)FacesConfigPackage.eINSTANCE.getSuggestedValueType_TextContent(), (Object)dialog.getRendererType());
                commands.add(cmd7);
            } else if (dialog.getRendererType().length() > 0) {
                RendererTypeType rendererType = FacesConfigFactory.eINSTANCE.createRendererTypeType();
                rendererType.setTextContent(dialog.getRendererType());
                Command cmd8 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)renderer, (Object)FacesConfigPackage.eINSTANCE.getRendererType_RendererType(), (Object)rendererType);
                commands.add(cmd8);
            }
            CompoundCommand command = new CompoundCommand(commands);
            if (command.canExecute()) {
                this.getEditingDomain().getCommandStack().execute((Command)command);
                this.tableViewer.refresh((Object)renderer);
            }
        }
    }

    private void removeButtonSelected() {
        RendererType Renderer = (RendererType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        Assert.isNotNull((Object)Renderer);
        Command removeCommand = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getInput(), (Object)this.getEReference(), (Object)Renderer);
        if (removeCommand.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(removeCommand);
            this.refreshAll();
        }
    }

    @Override
    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    @Override
    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }
}

