/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceTracker;
import org.eclipse.jst.jsf.common.internal.resource.WorkspaceMediator;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.ILibraryChangeHandler;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TaglibFileTracker;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.WebappConfiguration;

class TaglibResourceManager
extends ResourceManager<IFile> {
    private ILibraryChangeHandler _handler;
    private final WebappConfiguration _webAppConfiguration;

    public TaglibResourceManager(IProject project, ILibraryChangeHandler handler, WorkspaceMediator wsMediator, WebappConfiguration webAppConfiguration) {
        super(project.getWorkspace());
        this._handler = handler;
        this._webAppConfiguration = webAppConfiguration;
    }

    public List<IFile> getResources() {
        return this._webAppConfiguration.getFiles();
    }

    public void initResources() {
        this._webAppConfiguration.start();
        this._webAppConfiguration.addListener(new WebappConfiguration.WebappListener(){

            @Override
            public void webappChanged(WebappConfiguration.WebappListener.WebappChangeEvent event) {
                for (IFile file : event.getRemoved()) {
                    if (!TaglibResourceManager.this.isInstance((IResource)file)) continue;
                    TaglibFileTracker tracker = (TaglibFileTracker)TaglibResourceManager.this.unmanageResource((IResource)file);
                    TaglibResourceManager.this._handler.removed(tracker.getUri(), file);
                }
                for (IFile file : event.getAdded()) {
                    TaglibResourceManager.this._handler.added(file);
                }
            }
        });
        List<IFile> files = this._webAppConfiguration.getFiles();
        for (IFile file : files) {
            try {
                this.getInstance((IResource)file);
            }
            catch (ObjectManager.ManagedObjectException e) {
                FaceletCorePlugin.log("While starting the taglib resource manager", e);
            }
        }
    }

    protected ResourceTracker createNewInstance(IResource resource) {
        if (resource.getType() == 1) {
            return new TaglibFileTracker((IFile)resource, this, this._handler);
        }
        throw new IllegalArgumentException();
    }

    public void dispose() {
        this._webAppConfiguration.dispose();
        super.dispose();
    }
}

