/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelGridDeleteRowCommand
extends DesignerCommand {
    Element _panelGridEle;
    int _rowIndex;

    public PanelGridDeleteRowCommand(IHTMLGraphicalViewer viewer, Element panelGrid, int index) {
        super(CommandResources.getString("PanelGridDeleteRowCommand.Label.DeleteRow"), viewer);
        this._panelGridEle = panelGrid;
        this._rowIndex = index;
    }

    protected void doExecute() {
        boolean hasHeaderRow = JSFDOMUtil.findFacet(this._panelGridEle, "header") != null;
        int columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGridEle, (String)"columns", (int)1);
        if (columns < 1) {
            columns = 1;
        }
        List children = JSFDOMUtil.getUIComponentChildren(this._panelGridEle);
        int numRows = (children.size() + columns - 1) / columns;
        int removeRow = this._rowIndex;
        if (hasHeaderRow) {
            if (removeRow == 0) {
                this.removeHeader();
                this.formatNode(this._panelGridEle);
                return;
            }
            --removeRow;
        }
        if (removeRow < numRows) {
            ArrayList toRemove = new ArrayList();
            int max = columns * (removeRow + 1);
            max = Math.min(max, children.size());
            int i = columns * removeRow;
            while (i < max) {
                toRemove.add(children.get(i));
                ++i;
            }
            i = 0;
            int size = toRemove.size();
            while (i < size) {
                this._panelGridEle.removeChild((Node)toRemove.get(i));
                ++i;
            }
            this.formatNode(this._panelGridEle);
        } else {
            this.removeFooter();
            this.formatNode(this._panelGridEle);
        }
    }

    public boolean canExecute() {
        if (this._rowIndex < 0) {
            return false;
        }
        return super.canExecute();
    }

    private void removeFooter() {
        Element ele = JSFDOMUtil.findFacet(this._panelGridEle, "footer");
        if (ele != null) {
            this._panelGridEle.removeChild(ele);
        }
    }

    private void removeHeader() {
        Element ele = JSFDOMUtil.findFacet(this._panelGridEle, "header");
        if (ele != null) {
            this._panelGridEle.removeChild(ele);
        }
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._panelGridEle);
    }
}

