/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;

public class DataTableDeleteHeaderCommand
extends DesignerCommand {
    boolean _isHeader;
    private Element _dataTable;

    public DataTableDeleteHeaderCommand(IHTMLGraphicalViewer viewer, Element dataTable, boolean isHeader) {
        super(isHeader ? CommandResources.getString("DataTableDeleteHeaderCommand.Label.DeleteHeader") : CommandResources.getString("DataTableDeleteHeaderCommand.Label.DeleteFooter"), viewer);
        this._isHeader = isHeader;
        this._dataTable = dataTable;
    }

    public boolean canExecute() {
        if (this._isHeader) {
            boolean hasHeader;
            boolean bl = hasHeader = JSFDOMUtil.findFacet(this._dataTable, "header") != null;
            if (!hasHeader) {
                return false;
            }
        } else {
            boolean hasFooter;
            boolean bl = hasFooter = JSFDOMUtil.findFacet(this._dataTable, "footer") != null;
            if (!hasFooter) {
                return false;
            }
        }
        return super.canExecute();
    }

    protected void doExecute() {
        String type = this._isHeader ? "header" : "footer";
        Element ele = JSFDOMUtil.findFacet(this._dataTable, type);
        if (ele != null) {
            this._dataTable.removeChild(ele);
        }
        this.formatNode(this._dataTable);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._dataTable);
    }
}

