/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.core.internal.bindings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.core.internal.bindings.AbstractJNDIBindingsHelper;
import org.eclipse.jst.j2ee.core.internal.bindings.IJNDIBindingsHelper;
import org.eclipse.jst.j2ee.core.internal.plugin.J2EECorePlugin;

public class JNDIBindingsHelperManager {
    private List allHelpers;
    private IJNDIBindingsHelper defaultHelper;
    private static final int TYPE_PROJECT = 0;
    private static final int TYPE_ARCHIVE = 1;
    private static JNDIBindingsHelperManager instance = null;
    protected String TAG_J2EE_BINDINGS_HELPER = "jndiBindingsHelpers";

    public static JNDIBindingsHelperManager getInstance() {
        if (instance == null) {
            instance = new JNDIBindingsHelperManager();
        }
        return instance;
    }

    public IJNDIBindingsHelper[] getBindingsHelpers(IProject project) {
        return this.getBindingsHelpers(0, project);
    }

    public IJNDIBindingsHelper[] getBindingsHelpers(Archive archive) {
        return this.getBindingsHelpers(1, archive);
    }

    private IJNDIBindingsHelper[] getBindingsHelpers(int type, Object obj) {
        List helpers = this.getHelpers();
        ArrayList<IJNDIBindingsHelper> appliesHelpers = new ArrayList<IJNDIBindingsHelper>();
        IJNDIBindingsHelper helper = null;
        int i = 0;
        while (i < helpers.size()) {
            helper = (IJNDIBindingsHelper)helpers.get(i);
            if (type == 0 && helper.appliesFor((IProject)obj) || 1 == type && helper.appliesFor((Archive)obj)) {
                appliesHelpers.add(helper);
            }
            ++i;
        }
        if (appliesHelpers.size() == 0) {
            appliesHelpers.add(this.getDefaultHelper());
        }
        IJNDIBindingsHelper[] helpersArray = new IJNDIBindingsHelper[appliesHelpers.size()];
        int i2 = 0;
        while (i2 < helpersArray.length) {
            helpersArray[i2] = (IJNDIBindingsHelper)appliesHelpers.get(i2);
            ++i2;
        }
        return helpersArray;
    }

    private IJNDIBindingsHelper getDefaultHelper() {
        if (this.defaultHelper == null) {
            this.defaultHelper = new AbstractJNDIBindingsHelper(){

                @Override
                public boolean appliesFor(IProject project) {
                    return true;
                }

                @Override
                public boolean appliesFor(Archive archive) {
                    return true;
                }
            };
        }
        return this.defaultHelper;
    }

    private List getHelpers() {
        if (this.allHelpers == null) {
            BindingsHelperRegistry registry = new BindingsHelperRegistry();
            registry.readRegistry();
            this.allHelpers = registry.getHelpers();
        }
        return this.allHelpers;
    }

    private class BindingsHelperRegistry
    extends RegistryReader {
        private String ATT_CLASS;
        private String TAG_BINDINGS_HELPER;
        private List helpers;

        private BindingsHelperRegistry() {
            super("org.eclipse.jst.j2ee.core", JNDIBindingsHelperManager.this.TAG_J2EE_BINDINGS_HELPER);
            this.ATT_CLASS = "class";
            this.TAG_BINDINGS_HELPER = "jndiBindingsHelper";
            this.helpers = new ArrayList();
        }

        public boolean readElement(IConfigurationElement element) {
            if (this.TAG_BINDINGS_HELPER.equals(element.getName())) {
                try {
                    this.addHelper((IJNDIBindingsHelper)element.createExecutableExtension(this.ATT_CLASS));
                }
                catch (CoreException e) {
                    J2EECorePlugin.logError(e);
                    return false;
                }
                return true;
            }
            return false;
        }

        public List getHelpers() {
            return this.helpers;
        }

        private void addHelper(IJNDIBindingsHelper helper) {
            this.helpers.add(helper);
        }
    }
}

