/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.resource.ResourceMappingFile;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.wizards.SelectMappingFileDialog;
import org.eclipse.jpt.jpa.ui.wizards.entity.JptJpaUiWizardsEntityMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.preferences.JPAEditorPreferencesPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JPADiagramPropertyPage
extends PropertyPage {
    public static final String PROJECT_SETTINGS_PATH = "/.settings/org.eclipse.jpt.jpadiagrameditor.ui";
    protected IProject project = null;
    protected boolean isJPA10Project = false;
    private Properties editorProps;
    private Text txtDefaultFolderField;
    private Text txtDefaultEntityPackageField;
    private Text txtDefaultTableNamePrefix;
    private Button checkDirectEditAffectsClass;
    private Group groupAccessType;
    private Group groupCollectionType;
    private Button btnFieldBasedAccess;
    private Button btnPropertyBasedAccess;
    private Button btnCollectionType;
    private Button btnListType;
    private Button btnSetType;
    private Button btnMapType;
    private Button checkOneToManyOldStyle;
    private Label displayNameLabel;
    private Button xmlSupportButton;
    private Text ormXmlName;
    private Button browseButton;
    private boolean propsModified = false;
    private static final String QUALIFIER = "org.eclipse.jpt.jpadiagrameditor.ui";
    public static final QualifiedName PROP_DEFAULT_DIAGRAM_FOLDER = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "diagramFolder");
    public static final QualifiedName PROP_DEFAULT_PACKAGE = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "defaultPackage");
    public static final QualifiedName PROP_DEFAULT_TABLE_NAME_PREFIX = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "defaultTableNamePrefix");
    public static final QualifiedName PROP_DIRECT_EDIT_AFFECTS_CLASS = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "directEditAffectsClass");
    public static final QualifiedName PROP_ACCESS_TYPE = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "accessType");
    public static final QualifiedName PROP_COLLECTION_TYPE = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "collectionType");
    public static final QualifiedName PROP_ONE_TO_MANY_OLD_STYLE = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "oneToManyOldStyle");
    public static final QualifiedName PROP_ORM_XML_FILE_NAME = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "ormXmlFileName");
    public static final QualifiedName PROP_SUPPORT_ORM_XML = new QualifiedName("org.eclipse.jpt.jpadiagrameditor.ui", "supportOrmXml");
    private IPreferenceStore store = JPADiagramEditorPlugin.getDefault().getPreferenceStore();

    protected Control createContents(Composite parent) {
        Composite composite = this.createCompositeContainer(parent);
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
        this.isJPA10Project = JPAEditorUtil.checkJPAFacetVersion(this.project, "1.0");
        this.loadProperties();
        this.createDefaultFolderControl(composite);
        this.createDefaultPackageControl(composite);
        this.createDefaultTableNamePrefixControl(composite);
        this.createDirectEditAffectsClassControl(composite);
        this.createAccessTypeControl(composite);
        this.createDefaultCollectionTypeControl(composite);
        if (!this.isJPA10Project) {
            this.createOneToManyOldStyleControl(composite);
        }
        this.createXMLstorageControl(composite);
        Dialog.applyDialogFont((Control)composite);
        this.validatePage();
        return composite;
    }

    private Composite createCompositeContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        return composite;
    }

    private void createDefaultFolderControl(Composite composite) {
        Label lblDefaultFolder = new Label(composite, 4);
        lblDefaultFolder.setText(JPAEditorMessages.JPAEditorPreferencesPage_defaultFolderControlLabel);
        lblDefaultFolder.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_defaultFolderControlTooltip);
        GridData gd = new GridData();
        lblDefaultFolder.setLayoutData((Object)gd);
        this.txtDefaultFolderField = new Text(composite, 0x800804);
        lblDefaultFolder.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_defaultFolderControlTooltip);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.txtDefaultFolderField.setLayoutData((Object)gd);
        String defaultFolder = this.editorProps.getProperty(PROP_DEFAULT_DIAGRAM_FOLDER.getLocalName());
        this.txtDefaultFolderField.setText(defaultFolder);
        this.txtDefaultFolderField.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_defaultFolderControlTooltip);
        this.txtDefaultFolderField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPADiagramPropertyPage.this.validatePage();
                JPADiagramPropertyPage.this.propsModified = true;
            }
        });
    }

    private void createDefaultPackageControl(Composite composite) {
        Label lblDefaultPackage = new Label(composite, 4);
        lblDefaultPackage.setText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageToUse);
        lblDefaultPackage.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        GridData gd = new GridData();
        lblDefaultPackage.setLayoutData((Object)gd);
        this.txtDefaultEntityPackageField = new Text(composite, 0x800804);
        lblDefaultPackage.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.txtDefaultEntityPackageField.setLayoutData((Object)gd);
        String defaultPackageName = this.editorProps.getProperty(PROP_DEFAULT_PACKAGE.getLocalName());
        this.txtDefaultEntityPackageField.setText(defaultPackageName);
        this.txtDefaultEntityPackageField.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultPackageMsg);
        this.txtDefaultEntityPackageField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPADiagramPropertyPage.this.validatePage();
                JPADiagramPropertyPage.this.propsModified = true;
            }
        });
    }

    private void createDefaultTableNamePrefixControl(Composite composite) {
        Label lblDefaultTableNamePrfix = new Label(composite, 4);
        lblDefaultTableNamePrfix.setText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNameLabel);
        lblDefaultTableNamePrfix.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        GridData gd = new GridData();
        lblDefaultTableNamePrfix.setLayoutData((Object)gd);
        this.txtDefaultTableNamePrefix = new Text(composite, 0x800800);
        lblDefaultTableNamePrfix.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        this.txtDefaultTableNamePrefix.setLayoutData((Object)gd);
        String defaultTableNamePrefix = this.editorProps.getProperty(PROP_DEFAULT_TABLE_NAME_PREFIX.getLocalName());
        this.txtDefaultTableNamePrefix.setText(defaultTableNamePrefix);
        this.txtDefaultTableNamePrefix.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultTableNamePrefixMsg);
        this.txtDefaultTableNamePrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPADiagramPropertyPage.this.validatePage();
                JPADiagramPropertyPage.this.propsModified = true;
            }
        });
    }

    private void createDirectEditAffectsClassControl(Composite composite) {
        this.checkDirectEditAffectsClass = new Button(composite, 0x800020);
        this.checkDirectEditAffectsClass.setText(JPAEditorMessages.JPAEditorPreferencesPage_directEditAffectsClass);
        this.checkDirectEditAffectsClass.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_directEditAffectsClassTooltip);
        this.checkDirectEditAffectsClass.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        boolean defaultDirectEditAffectsClass = Boolean.parseBoolean(this.editorProps.getProperty(PROP_DIRECT_EDIT_AFFECTS_CLASS.getLocalName()));
        this.checkDirectEditAffectsClass.setSelection(defaultDirectEditAffectsClass);
        this.checkDirectEditAffectsClass.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createOneToManyOldStyleControl(Composite composite) {
        this.checkOneToManyOldStyle = new Button(composite, 0x800020);
        this.checkOneToManyOldStyle.setText(JPAEditorMessages.JPAEditorPropertyPage_oneToManyOldStyle);
        this.checkOneToManyOldStyle.setToolTipText(JPAEditorMessages.JPAEditorPropertyPage_oneToManyOldStyleTooltip);
        this.checkOneToManyOldStyle.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        boolean defaultDirectEditAffectsClass = Boolean.parseBoolean(this.editorProps.getProperty(PROP_ONE_TO_MANY_OLD_STYLE.getLocalName()));
        this.checkOneToManyOldStyle.setSelection(defaultDirectEditAffectsClass);
        this.checkOneToManyOldStyle.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createDefaultCollectionTypeControl(Composite composite) {
        this.groupCollectionType = new Group(composite, 0);
        this.groupCollectionType.setText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultCollectionTypeSectionTittle);
        this.groupCollectionType.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_DefaultCollectionTypeSectionDescription);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.groupCollectionType.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        this.groupCollectionType.setLayout((Layout)gl);
        String defaultCollectionType = this.editorProps.getProperty(PROP_COLLECTION_TYPE.getLocalName());
        this.createCollectionTypeButton(composite, gd, defaultCollectionType);
        this.createListTypeButton(composite, gd, defaultCollectionType);
        this.createSetTypeButton(composite, gd, defaultCollectionType);
        this.createMapTypeButton(composite, gd, defaultCollectionType);
    }

    private void createAccessTypeControl(Composite composite) {
        this.groupAccessType = new Group(composite, 0);
        this.groupAccessType.setText(JPAEditorMessages.JPAEditorPreferencesPage_entityAccessTypeButtonGroupLabel);
        this.groupAccessType.setToolTipText(JPAEditorMessages.JPAEditorPreferencesPage_entityAccessTypeButtonGroupTooltip);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.groupAccessType.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        this.groupAccessType.setLayout((Layout)gl);
        String defaultAccessType = this.editorProps.getProperty(PROP_ACCESS_TYPE.getLocalName());
        this.createFieldAccessButton(composite, gd, defaultAccessType);
        this.createPropertyAccessButton(composite, gd, defaultAccessType);
    }

    private void createCollectionTypeButton(Composite composite, GridData gd, String defaultCollectionType) {
        this.btnCollectionType = new Button((Composite)this.groupCollectionType, 0x800010);
        this.btnCollectionType.setText("java.util.&Collection");
        gd = new GridData();
        this.btnCollectionType.setLayoutData((Object)gd);
        this.btnCollectionType.setSelection(defaultCollectionType.equals("collection"));
        this.btnCollectionType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createListTypeButton(Composite composite, GridData gd, String defaultCollectionType) {
        this.btnListType = new Button((Composite)this.groupCollectionType, 0x800010);
        this.btnListType.setText("java.util.&List");
        gd = new GridData();
        this.btnListType.setLayoutData((Object)gd);
        this.btnListType.setSelection(defaultCollectionType.equals("list"));
        this.btnListType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createSetTypeButton(Composite composite, GridData gd, String defaultCollectionType) {
        this.btnSetType = new Button((Composite)this.groupCollectionType, 0x800010);
        this.btnSetType.setText("java.util.&Set");
        gd = new GridData();
        this.btnSetType.setLayoutData((Object)gd);
        this.btnSetType.setSelection(defaultCollectionType.equals("set"));
        this.btnSetType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createMapTypeButton(Composite composite, GridData gd, String defaultCollectionType) {
        this.btnMapType = new Button((Composite)this.groupCollectionType, 0x800010);
        this.btnMapType.setText("java.util.&Map");
        gd = new GridData();
        this.btnMapType.setLayoutData((Object)gd);
        this.btnMapType.setSelection(defaultCollectionType.equals("map"));
        this.btnMapType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createFieldAccessButton(Composite composite, GridData gd, String defaultAccessType) {
        this.btnFieldBasedAccess = new Button((Composite)this.groupAccessType, 0x800010);
        this.btnFieldBasedAccess.setText(JPAEditorMessages.JPAEditorPreferencesPage_entityFieldBasedAccessButtonLabel);
        gd = new GridData();
        this.btnFieldBasedAccess.setLayoutData((Object)gd);
        this.btnFieldBasedAccess.setSelection(defaultAccessType.equals("field"));
        this.btnFieldBasedAccess.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createPropertyAccessButton(Composite composite, GridData gd, String defaultAccessType) {
        this.btnPropertyBasedAccess = new Button((Composite)this.groupAccessType, 0x800010);
        this.btnPropertyBasedAccess.setText(JPAEditorMessages.JPAEditorPreferencesPage_entityPropertyBasedAccessButtonLabel);
        gd = new GridData();
        this.btnPropertyBasedAccess.setLayoutData((Object)gd);
        this.btnPropertyBasedAccess.setSelection(defaultAccessType.equals("property"));
        this.btnPropertyBasedAccess.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void performDefaults() {
        boolean xmlSupport;
        String defaultFolder = this.store.getString("org.eclipse.jpt.jpadiagrameditor.ui.diagramfolder");
        this.txtDefaultFolderField.setText(defaultFolder);
        String defaultPackageName = this.store.getString("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultPackage");
        this.txtDefaultEntityPackageField.setText(defaultPackageName);
        String defaultTableNamePrefix = this.store.getString("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultTableNamePrefix");
        this.txtDefaultTableNamePrefix.setText(defaultTableNamePrefix);
        boolean defaultDirectEditAffectsClass = this.store.getBoolean("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultDirectEditClassName");
        this.checkDirectEditAffectsClass.setSelection(defaultDirectEditAffectsClass);
        String defaultAccessType = this.store.getString("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultEntityAccessType");
        this.btnFieldBasedAccess.setSelection(defaultAccessType.equals("field"));
        this.btnPropertyBasedAccess.setSelection(defaultAccessType.equals("property"));
        String defaultCollectionType = this.store.getString("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultCollectionType");
        this.btnCollectionType.setSelection(defaultCollectionType.equals("collection"));
        this.btnListType.setSelection(defaultCollectionType.equals("list"));
        this.btnSetType.setSelection(defaultCollectionType.equals("set"));
        this.btnMapType.setSelection(defaultCollectionType.equals("map"));
        boolean defaultOneToManyOldStyle = this.store.getBoolean("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultOneToManyOldStyle");
        if (!this.isJPA10Project) {
            this.checkOneToManyOldStyle.setSelection(defaultOneToManyOldStyle);
        }
        if (xmlSupport = this.store.getBoolean("org.eclipse.jpt.jpadiagrameditor.ui.supportOrmXml")) {
            String ormXml = this.store.getString("org.eclipse.jpt.jpadiagrameditor.ui.ormXmlFileName");
            this.ormXmlName.setText(ormXml);
        }
        super.performDefaults();
    }

    protected synchronized void validatePage() {
        IStatus statFolder = JPAEditorPreferencesPage.validateDefaultFolder(this.txtDefaultFolderField.getText().trim(), this.project.getName());
        IStatus statPack = JPAEditorPreferencesPage.validateDefaultPackage(this.txtDefaultEntityPackageField.getText().trim());
        IStatus statPref = JPAEditorPreferencesPage.validateTableNamePrefix(this.txtDefaultTableNamePrefix.getText().trim());
        IStatus statOrmXml = this.validateXmlName(this.ormXmlName.getText().trim());
        if (statFolder.getSeverity() == 4) {
            this.setErrorMessage(statFolder.getMessage());
            this.setValid(false);
            return;
        }
        if (statPack.getSeverity() == 4) {
            this.setErrorMessage(statPack.getMessage());
            this.setValid(false);
            return;
        }
        if (statPref.getSeverity() == 4) {
            this.setErrorMessage(statPref.getMessage());
            this.setValid(false);
            return;
        }
        if (statOrmXml.getSeverity() == 4) {
            this.setErrorMessage(statOrmXml.getMessage());
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
        if (statPack.getSeverity() == 2) {
            this.setMessage(statPack.getMessage(), 2);
            return;
        }
        if (statPref.getSeverity() == 2) {
            this.setMessage(statPref.getMessage(), 2);
            return;
        }
        this.setMessage(null, 0);
    }

    protected void performApply() {
        this.saveSettingsIfModified();
    }

    public boolean performOk() {
        return this.saveSettingsIfModified();
    }

    private boolean saveSettingsIfModified() {
        if (this.propsModified) {
            boolean saved = this.saveSettings();
            this.propsModified = !saved;
            return saved;
        }
        return true;
    }

    private boolean saveSettings() {
        this.putNewValsInProps();
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        Path path = new Path(PROJECT_SETTINGS_PATH);
        IFile quartzDataXMLFile = project.getFile((IPath)path);
        File file = new File(quartzDataXMLFile.getLocation().toOSString());
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.editorProps.store(os, "This file contains JPA Diagram Editor settings");
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)JPAEditorMessages.JPADiagramPropertyPage_errSavePropsMsgTitle, (String)JPAEditorMessages.JPADiagramPropertyPage_errSavePropsMsgText);
            return false;
        }
    }

    private void putNewValsInProps() {
        this.editorProps.put(PROP_DEFAULT_DIAGRAM_FOLDER.getLocalName(), this.txtDefaultFolderField.getText().trim());
        this.editorProps.put(PROP_DEFAULT_PACKAGE.getLocalName(), this.txtDefaultEntityPackageField.getText().trim());
        this.editorProps.put(PROP_DEFAULT_TABLE_NAME_PREFIX.getLocalName(), this.txtDefaultTableNamePrefix.getText().trim());
        this.editorProps.put(PROP_DIRECT_EDIT_AFFECTS_CLASS.getLocalName(), "" + this.checkDirectEditAffectsClass.getSelection());
        this.editorProps.put(PROP_ACCESS_TYPE.getLocalName(), this.btnFieldBasedAccess.getSelection() ? "field" : "property");
        this.editorProps.put(PROP_COLLECTION_TYPE.getLocalName(), this.getCollectionProperty());
        if (!this.isJPA10Project) {
            this.editorProps.put(PROP_ONE_TO_MANY_OLD_STYLE.getLocalName(), "" + this.checkOneToManyOldStyle.getSelection());
        }
        this.editorProps.put(PROP_SUPPORT_ORM_XML.getLocalName(), "" + this.xmlSupportButton.getSelection());
        this.editorProps.put(PROP_ORM_XML_FILE_NAME.getLocalName(), this.ormXmlName.getText().trim());
    }

    private String getCollectionProperty() {
        if (this.btnCollectionType.getSelection()) {
            return "collection";
        }
        if (this.btnListType.getSelection()) {
            return "list";
        }
        if (this.btnSetType.getSelection()) {
            return "set";
        }
        if (this.btnMapType.getSelection()) {
            return "map";
        }
        return null;
    }

    private Properties createDefaultProps() {
        return JPADiagramPropertyPage.createDefaultProps(this.store);
    }

    private static Properties createDefaultProps(IPreferenceStore store) {
        Properties editorDefaultProps = new Properties();
        editorDefaultProps.setProperty(PROP_DEFAULT_DIAGRAM_FOLDER.getLocalName(), store.getString("org.eclipse.jpt.jpadiagrameditor.ui.diagramfolder"));
        editorDefaultProps.setProperty(PROP_DEFAULT_PACKAGE.getLocalName(), store.getString("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultPackage"));
        editorDefaultProps.setProperty(PROP_DEFAULT_TABLE_NAME_PREFIX.getLocalName(), store.getString("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultTableNamePrefix"));
        editorDefaultProps.setProperty(PROP_DIRECT_EDIT_AFFECTS_CLASS.getLocalName(), "" + store.getBoolean("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultDirectEditClassName"));
        editorDefaultProps.setProperty(PROP_ACCESS_TYPE.getLocalName(), store.getString("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultEntityAccessType"));
        editorDefaultProps.setProperty(PROP_COLLECTION_TYPE.getLocalName(), store.getString("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultCollectionType"));
        editorDefaultProps.setProperty(PROP_ONE_TO_MANY_OLD_STYLE.getLocalName(), "" + store.getBoolean("org.eclipse.jpt.jpadiagrameditor.ui.entity.defaultOneToManyOldStyle"));
        editorDefaultProps.setProperty(PROP_SUPPORT_ORM_XML.getLocalName(), "" + store.getBoolean("org.eclipse.jpt.jpadiagrameditor.ui.supportOrmXml"));
        editorDefaultProps.setProperty(PROP_ORM_XML_FILE_NAME.getLocalName(), store.getString("org.eclipse.jpt.jpadiagrameditor.ui.ormXmlFileName"));
        return editorDefaultProps;
    }

    private void loadProperties() {
        Path path;
        Properties defaultProps = this.createDefaultProps();
        this.editorProps = new Properties(defaultProps);
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        IFile editorProjectProperties = project.getFile((IPath)(path = new Path(PROJECT_SETTINGS_PATH)));
        File propertiesFile = new File(editorProjectProperties.getLocation().toOSString());
        if (propertiesFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propertiesFile);
                this.editorProps.load(is);
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Properties loadProperties(IProject project) {
        File propertiesFile;
        IPreferenceStore store = JPADiagramEditorPlugin.getDefault().getPreferenceStore();
        Properties defaultProps = JPADiagramPropertyPage.createDefaultProps(store);
        Properties editorProps = new Properties(defaultProps);
        Path path = new Path(PROJECT_SETTINGS_PATH);
        IFile editorProjectProperties = project.getFile((IPath)path);
        if (editorProjectProperties.getLocation() != null && (propertiesFile = new File(editorProjectProperties.getLocation().toOSString())).exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propertiesFile);
                editorProps.load(is);
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
        return editorProps;
    }

    public static String getDefaultFolder(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.getDefaultFolder(project, props);
    }

    public static String getDefaultPackage(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.getDefaultPackage(project, props);
    }

    public static String getDefaultTablePrefixName(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.getDefaultTablePrefixName(project, props);
    }

    public static boolean doesDirecteEditingAffectClassNameByDefault(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.doesDirecteEditingAffectClassNameByDefault(project, props);
    }

    public static boolean isAccessFieldBased(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.isAccessFieldBased(project, props);
    }

    public static boolean isCollectionType(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.isCollectionType(project, props);
    }

    public static boolean isListType(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.isListType(project, props);
    }

    public static boolean isSetType(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.isSetType(project, props);
    }

    public static boolean isMapType(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.isMapType(project, props);
    }

    public static boolean shouldOneToManyUnidirBeOldStyle(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.shouldOneToManyUnidirBeOldStyle(project, props);
    }

    public static String getOrmXmlFileName(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.getOrmXmlFileName(project, props);
    }

    public static boolean doesSupportOrmXml(IProject project) {
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        return JPADiagramPropertyPage.doesSupportOrmXml(project, props);
    }

    public static String getDefaultFolder(IProject project, Properties props) {
        return props.getProperty(PROP_DEFAULT_DIAGRAM_FOLDER.getLocalName());
    }

    public static String getDefaultPackage(IProject project, Properties props) {
        return props.getProperty(PROP_DEFAULT_PACKAGE.getLocalName());
    }

    public static String getDefaultTablePrefixName(IProject project, Properties props) {
        return props.getProperty(PROP_DEFAULT_TABLE_NAME_PREFIX.getLocalName());
    }

    public static boolean doesDirecteEditingAffectClassNameByDefault(IProject project, Properties props) {
        return Boolean.parseBoolean(props.getProperty(PROP_DIRECT_EDIT_AFFECTS_CLASS.getLocalName()));
    }

    public static boolean isAccessFieldBased(IProject project, Properties props) {
        String accessType = props.getProperty(PROP_ACCESS_TYPE.getLocalName());
        return accessType.equals("field");
    }

    public static boolean isCollectionType(IProject project, Properties props) {
        String accessType = props.getProperty(PROP_COLLECTION_TYPE.getLocalName());
        return accessType.equals("collection");
    }

    public static boolean isListType(IProject project, Properties props) {
        String accessType = props.getProperty(PROP_COLLECTION_TYPE.getLocalName());
        return accessType.equals("list");
    }

    public static boolean isSetType(IProject project, Properties props) {
        String accessType = props.getProperty(PROP_COLLECTION_TYPE.getLocalName());
        return accessType.equals("set");
    }

    public static boolean isMapType(IProject project, Properties props) {
        String accessType = props.getProperty(PROP_COLLECTION_TYPE.getLocalName());
        return accessType.equals("map");
    }

    public static boolean shouldOneToManyUnidirBeOldStyle(IProject project, Properties props) {
        return Boolean.parseBoolean(props.getProperty(PROP_ONE_TO_MANY_OLD_STYLE.getLocalName()));
    }

    public static String getOrmXmlFileName(IProject project, Properties props) {
        return props.getProperty(PROP_ORM_XML_FILE_NAME.getLocalName());
    }

    public static boolean doesSupportOrmXml(IProject project, Properties props) {
        return Boolean.parseBoolean(props.getProperty(PROP_SUPPORT_ORM_XML.getLocalName()));
    }

    private void createXMLstorageControl(Composite parent) {
        Group group = this.createGroup(parent, JptJpaUiWizardsEntityMessages.XML_STORAGE_GROUP);
        this.xmlSupportButton = this.createCheckButton((Composite)group, JptJpaUiWizardsEntityMessages.XML_SUPPORT);
        this.createBrowseGroup((Composite)group, JPAEditorMessages.JPADiagramPropertyPage_ChooseXMLLabel);
        this.xmlSupportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = JPADiagramPropertyPage.this.xmlSupportButton.getSelection();
                JPADiagramPropertyPage.this.enableMappingXMLChooseGroup(isChecked);
                JPADiagramPropertyPage.this.validatePage();
                JPADiagramPropertyPage.this.propsModified = true;
            }
        });
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(text);
        group.setToolTipText(JPAEditorMessages.JPADiagramPropertyPage_ChooseXMLGroupTooltip);
        return group;
    }

    private Button createCheckButton(Composite parent, String text) {
        Button button = new Button(parent, 32);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        button.setLayoutData((Object)groupGridData);
        button.setText(text);
        button.setToolTipText(JPAEditorMessages.JPADiagramPropertyPage_ChooseXMLCheckboxTooltip);
        button.setSelection(JPADiagramPropertyPage.doesSupportOrmXml(this.project));
        return button;
    }

    private void createBrowseGroup(Composite parent, String label) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        this.displayNameLabel = new Label(composite, 16384);
        this.displayNameLabel.setText(label);
        this.displayNameLabel.setToolTipText(JPAEditorMessages.JPADiagramPropertyPage_ChooseXMLTooltip);
        this.displayNameLabel.setLayoutData((Object)new GridData(32));
        this.ormXmlName = new Text(composite, 2052);
        this.ormXmlName.setLayoutData((Object)new GridData(768));
        String ormXmlFileName = this.editorProps.getProperty(PROP_ORM_XML_FILE_NAME.getLocalName());
        this.ormXmlName.setText(ormXmlFileName);
        this.ormXmlName.setToolTipText(JPAEditorMessages.JPADiagramPropertyPage_ChooseXMLTooltip);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(JPAEditorMessages.JPADiagramPropertyPage_ChooseXmlBrowseButton);
        this.browseButton.setToolTipText(JPAEditorMessages.JPADiagramPropertyPage_ChooseXMLTooltip);
        GridData browseButtonData = new GridData(256);
        browseButtonData.horizontalSpan = 1;
        this.browseButton.setLayoutData((Object)browseButtonData);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JPADiagramPropertyPage.this.handleChooseXmlButtonPressed();
                JPADiagramPropertyPage.this.propsModified = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.ormXmlName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JPADiagramPropertyPage.this.validatePage();
                JPADiagramPropertyPage.this.propsModified = true;
            }
        });
        this.enableMappingXMLChooseGroup(this.xmlSupportButton.getSelection());
    }

    private void handleChooseXmlButtonPressed() {
        if (this.project == null) {
            return;
        }
        JpaProject jpaProject = this.getJpaProject(this.project);
        if (jpaProject == null) {
            return;
        }
        ViewerFilter filter = this.getDialogViewerFilter(jpaProject);
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        SelectMappingFileDialog dialog = new SelectMappingFileDialog(this.getShell(), this.project, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(JptJpaUiWizardsEntityMessages.MAPPING_XML_TITLE);
        dialog.setMessage(JptJpaUiWizardsEntityMessages.CHOOSE_MAPPING_XML_MESSAGE);
        dialog.addFilter(filter);
        String ormFileName = this.ormXmlName.getText();
        JptXmlResource resource = jpaProject.getMappingFileXmlResource((IPath)new Path(ormFileName));
        IFile initialSelection = resource != null ? resource.getFile() : null;
        dialog.setInput((Object)this.project);
        if (initialSelection != null) {
            dialog.setInitialSelection((Object)initialSelection);
        }
        if (dialog.open() == 0) {
            boolean noNameChange = false;
            if (this.ormXmlName.getText().equals(dialog.getChosenName())) {
                noNameChange = true;
            }
            this.ormXmlName.setText(dialog.getChosenName());
            if (noNameChange) {
                this.validatePage();
            }
        }
    }

    protected ViewerFilter getDialogViewerFilter(JpaProject jpaProject) {
        return new XmlMappingFileViewerFilter(jpaProject, ResourceMappingFile.Root.CONTENT_TYPE);
    }

    private void enableMappingXMLChooseGroup(boolean enabled) {
        this.displayNameLabel.setEnabled(enabled);
        this.ormXmlName.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    protected JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    private IStatus validateXmlName(String xmlName) {
        if (this.xmlSupportButton.getSelection()) {
            JptXmlResource ormXmlResource;
            JptXmlResource jptXmlResource = ormXmlResource = StringTools.isBlank((String)xmlName) ? null : this.getOrmXmlResource(xmlName);
            if (ormXmlResource == null) {
                return new Status(4, QUALIFIER, JPAEditorMessages.JPADiagramPropertyPage_NotExistsXmlErrorMsg);
            }
            JpaProject jpaProject = this.getJpaProject(this.project);
            if (jpaProject == null || jpaProject.getJpaFile(ormXmlResource.getFile()).getRootStructureNodesSize() == 0) {
                return new Status(4, QUALIFIER, JPAEditorMessages.JPADiagramPropertyPage_NotAddedXMLErrorMsg);
            }
        }
        return Status.OK_STATUS;
    }

    private JptXmlResource getOrmXmlResource(String xmlName) {
        JpaProject jpaProject = this.getJpaProject(this.project);
        return jpaProject == null ? null : jpaProject.getMappingFileXmlResource((IPath)new Path(xmlName));
    }
}

