/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.wst.command.internal.env.context.PersistentContext;
import org.eclipse.wst.common.environment.EnvironmentService;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.ws.internal.WstWSPluginMessages;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;

public class PersistentWSIContext
extends PersistentContext {
    public static final String STOP_NON_WSI = "0";
    public static final String WARN_NON_WSI = "1";
    public static final String IGNORE_NON_WSI = "2";
    public static final String FOLLOW_WSI_PREFERENCE = "3";
    private static final String[] ENUM_ID_VALUES = new String[]{"org.eclipse.wst.sug.require", "org.eclipse.wst.sug.suggest", "org.eclipse.wst.sug.ignore"};
    private static final String[] CONTEXT_IDS = new String[]{"0", "1", "2"};
    protected QualifiedName name = new QualifiedName("org.eclipse.wst.ws", this.non_wsi_compliance);
    protected String non_wsi_compliance = "nonWSISSBPCompliance";
    private static final String NON_WSI_SSBP_COMPLIANCE = "nonWSISSBPCompliance";
    protected String wsiWarning_ = WstWSPluginMessages.WSI_SSBP_WARNING;
    protected String wsiError_ = WstWSPluginMessages.WSI_SSBP_ERROR;

    public PersistentWSIContext() {
        super((Plugin)WSPlugin.getInstance());
    }

    public void load() {
    }

    public void updateWSICompliances(String value) {
        this.setValue(this.non_wsi_compliance, value);
    }

    public String getPersistentWSICompliance() {
        String property = this.getValueAsString(this.non_wsi_compliance);
        if (property == null || property.equals("")) {
            this.setValue(this.non_wsi_compliance, WARN_NON_WSI);
            return WARN_NON_WSI;
        }
        return property;
    }

    public boolean StopNonWSICompliances() {
        return STOP_NON_WSI.equals(this.getPersistentWSICompliance());
    }

    public boolean WarnNonWSICompliances() {
        return WARN_NON_WSI.equals(this.getPersistentWSICompliance());
    }

    public boolean IgnoreNonWSICompliances() {
        return IGNORE_NON_WSI.equals(this.getPersistentWSICompliance());
    }

    public void updateProjectWSICompliances(IProject project, String value) {
        try {
            project.setPersistentProperty(this.name, value);
        }
        catch (CoreException coreException) {
            System.out.println("No such Project");
            ILog log = EnvironmentService.getEclipseLog();
            log.log(1, 5084, (Object)this, "updateProjectWSICompliances", (Object)("No such Project " + project));
        }
    }

    public boolean projectStopNonWSICompliances(IProject project) {
        return STOP_NON_WSI.equals(this.getProjectPersistentProperty(project));
    }

    public boolean projectWarnNonWSICompliances(IProject project) {
        return WARN_NON_WSI.equals(this.getProjectPersistentProperty(project));
    }

    public boolean projectIgnoreNonWSICompliances(IProject project) {
        return IGNORE_NON_WSI.equals(this.getProjectPersistentProperty(project));
    }

    public boolean projectFollowWSIPreferance(IProject project) {
        try {
            String property = project.getPersistentProperty(this.name);
            return property == null || property.equals("") || property.equals(FOLLOW_WSI_PREFERENCE);
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    private String getProjectPersistentProperty(IProject project) {
        String property = this.getProjectWSICompliance(project);
        if (property.equals(FOLLOW_WSI_PREFERENCE)) {
            property = this.getPersistentWSICompliance();
        }
        return property;
    }

    public String getProjectWSICompliance(IProject project) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        IServicePolicy servicePolicy = platform.getServicePolicy(this.getServicePolicyId());
        String currentStateID = servicePolicy.getPolicyStateEnum(project).getCurrentItem().getId();
        String property = FOLLOW_WSI_PREFERENCE;
        int index = 0;
        while (index < ENUM_ID_VALUES.length) {
            if (ENUM_ID_VALUES[index].equals(currentStateID)) {
                property = CONTEXT_IDS[index];
                break;
            }
            ++index;
        }
        return property;
    }

    protected String getServicePolicyId() {
        return "org.eclipse.wst.ws.service.policy.ui.servicepols.wsiprofilecomp.wsissbp";
    }

    public QualifiedName getName() {
        return this.name;
    }

    public String getWarning() {
        return this.wsiWarning_;
    }

    public String getError() {
        return this.wsiError_;
    }
}

