/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.io.BufferedReader;
import java.io.StringReader;
import java.text.ParseException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UpdateAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.CategoryModel;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;

public class UpdateRegistryAction
extends UpdateAction {
    public UpdateRegistryAction(Controller controller) {
        super(controller, false);
    }

    @Override
    protected boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String nameModifiedState = parser.getParameter("nameModified");
        String name = parser.getParameter("advancedRegistryName");
        String[] userDefinedCategoryTModelKeys = parser.getParameterValues("categoryTModelKey");
        String[] userDefinedCategoryData = parser.getParameterValues("categoryFileName");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        if (nameModifiedState != null && name != null) {
            boolean isModified = Boolean.valueOf(nameModifiedState);
            String newName = isModified ? name : (String)formToolPI.getProperty("advancedRegistryName");
            this.propertyTable_.put("advancedRegistryName", newName);
            if (!Validator.validateString(name)) {
                inputsValid = false;
                formToolPI.flagError("advancedRegistryName");
                messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_NAME"));
            }
        } else {
            this.removeProperty("advancedRegistryName");
        }
        if (userDefinedCategoryTModelKeys != null && userDefinedCategoryData != null) {
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            int i = 0;
            while (i < userDefinedCategoryTModelKeys.length) {
                CategoryModel userDefinedCategory = regElement.getUserDefinedCategory(userDefinedCategoryTModelKeys[i]);
                userDefinedCategory.setColumnDelimiter("#");
                userDefinedCategory.setStringDelimiter("\"");
                String displayName = userDefinedCategory.getDisplayName();
                if (userDefinedCategoryData[i] == null || userDefinedCategoryData[i].length() < 1) {
                    inputsValid = false;
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_USER_DEFINED_CATEGORY_DATA_FILE", displayName));
                    formToolPI.flagRowError((Object)"userDefinedCategories", userDefinedCategoryTModelKeys[i]);
                } else {
                    byte rc = userDefinedCategory.loadData(new BufferedReader(new StringReader(userDefinedCategoryData[i])));
                    switch (rc) {
                        case 0: {
                            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_USER_DEFINED_CATEGORY_DATA_LOADED", displayName));
                            break;
                        }
                        case 1: {
                            inputsValid = false;
                            ParseException pe = (ParseException)userDefinedCategory.getErrorException();
                            String[] args1 = new String[]{String.valueOf(pe.getErrorOffset()), displayName, pe.getMessage(), userDefinedCategory.getCategoryKey()};
                            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_USER_DEFINED_CATEGORY_DATA_FILE_FORMAT", args1));
                            formToolPI.flagRowError((Object)"userDefinedCategories", userDefinedCategoryTModelKeys[i]);
                            break;
                        }
                        default: {
                            inputsValid = false;
                            String[] args2 = new String[]{displayName, userDefinedCategory.getErrorException().getMessage(), userDefinedCategory.getCategoryKey()};
                            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_USER_DEFINED_CATEGORY_DATA_FILE_KEY", args2));
                            formToolPI.flagRowError((Object)"userDefinedCategories", userDefinedCategoryTModelKeys[i]);
                        }
                    }
                }
                ++i;
            }
        }
        return inputsValid;
    }

    @Override
    public final boolean refreshFromRegistry() {
        return true;
    }

    @Override
    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        String name = (String)this.propertyTable_.get("advancedRegistryName");
        RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
        regElement.setName(name);
        this.regNode_.getTreeElement().setName(name);
        messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_REGISTRY_UPDATED", name));
        return true;
    }
}

