/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition2;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.dom.IDOMRefPosition;
import org.eclipse.jst.pagedesigner.parts.NodeEditPart;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMPositionHelper {
    public static DesignPosition toDesignRefPosition(DOMRefPosition position) {
        Node node = position.getReferenceNode();
        while (true) {
            IDOMNode container;
            EditPart part;
            if ((part = (EditPart)(container = (IDOMNode)node.getParentNode()).getAdapterFor(EditPart.class)) != null) {
                EditPart child = DOMPositionHelper.findEditPart(part, node);
                if (child != null) {
                    return new DesignRefPosition(child, position.isForward());
                }
                return DesignPosition.INVALID;
            }
            node = node.getParentNode();
        }
    }

    public static DesignPosition toDesignPosition(IDOMPosition position) {
        if (position == null) {
            return null;
        }
        if (position instanceof DOMRefPosition) {
            return DOMPositionHelper.toDesignRefPosition((DOMRefPosition)position);
        }
        while (true) {
            IDOMNode container;
            EditPart part;
            if ((part = (EditPart)(container = (IDOMNode)position.getContainerNode()).getAdapterFor(EditPart.class)) != null) {
                if (container instanceof Text) {
                    String textData = ((Text)container).getData();
                    String displayData = ((TextEditPart)part).getTextData();
                    return new DesignPosition(part, DOMPositionHelper.textDataOffsetToDisplayOffset(textData, displayData, position.getOffset()));
                }
                Node pre = position.getPreviousSiblingNode();
                while (pre != null) {
                    int index = DOMPositionHelper.findChildEditPartIndex(part, pre);
                    if (index != -1) {
                        return new DesignPosition(part, index + 1);
                    }
                    pre = pre.getPreviousSibling();
                }
                return new DesignPosition(part, 0);
            }
            position = new DOMRefPosition(position.getContainerNode(), false);
        }
    }

    public static DesignPosition toDesignPosition1(IDOMPosition position) {
        if (position instanceof DOMRefPosition) {
            return DOMPositionHelper.toDesignRefPosition((DOMRefPosition)position);
        }
        IDOMNode container = (IDOMNode)position.getContainerNode();
        EditPart part = (EditPart)container.getAdapterFor(EditPart.class);
        if (part != null) {
            if (container instanceof Text) {
                String textData = ((Text)container).getData();
                String displayData = ((TextEditPart)part).getTextData();
                return new DesignPosition(part, DOMPositionHelper.textDataOffsetToDisplayOffset(textData, displayData, position.getOffset()));
            }
            Node pre = position.getPreviousSiblingNode();
            while (pre != null) {
                int index = DOMPositionHelper.findChildEditPartIndex(part, pre);
                if (index != -1) {
                    return new DesignPosition(part, index + 1);
                }
                pre = pre.getPreviousSibling();
            }
            return new DesignPosition(part, 0);
        }
        return DesignPosition.INVALID;
    }

    static int findChildEditPartIndex(EditPart parent, Node node) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((EditPart)children.get(i)).getModel() == node) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static EditPart findEditPart(EditPart parent, Node node) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart part = (EditPart)children.get(i);
            if (part.getModel() == node) {
                return part;
            }
            ++i;
        }
        return null;
    }

    public static IDOMPosition toDOMRefPosition(DesignRefPosition position) {
        EditPart sibling = position.getRefPart();
        if (sibling != null) {
            return new DOMRefPosition((Node)sibling.getModel(), position.caretIsAtRight());
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static IDOMPosition toDOMPosition(DesignPosition position) {
        if (!EditValidateUtil.validPosition(position)) {
            return null;
        }
        if (position instanceof DesignRefPosition) {
            return DOMPositionHelper.toDOMRefPosition((DesignRefPosition)position);
        }
        EditPart part = position.getContainerPart();
        if (part instanceof TextEditPart) {
            Text text = (Text)((TextEditPart)part).getIDOMNode();
            int offset = position.getOffset();
            if (offset == 0) {
                return new DOMPosition(text, 0);
            }
            String displayData = ((TextEditPart)part).getTextData();
            String nodeData = text.getData();
            if (offset >= displayData.length()) {
                return new DOMPosition(text, nodeData.length());
            }
            int index = DOMPositionHelper.displayOffsetToTextDataOffset(displayData, nodeData, offset);
            return new DOMPosition(text, index);
        }
        EditPart sibling = position.getSiblingEditPart(true);
        if (sibling instanceof NodeEditPart) {
            return new DOMRefPosition(((NodeEditPart)sibling).getDOMNode(), false);
        }
        sibling = position.getSiblingEditPart(false);
        if (sibling instanceof NodeEditPart) {
            return new DOMRefPosition(((NodeEditPart)sibling).getDOMNode(), true);
        }
        return new DOMPosition(((NodeEditPart)part).getDOMNode(), 0);
    }

    public static IDOMPosition splitText(IDOMPosition position) {
        Node container = position.getContainerNode();
        if (container instanceof Text) {
            int offset = position.getOffset();
            if (offset <= 0) {
                return new DOMRefPosition(container, false);
            }
            String textData = ((Text)container).getData();
            if (offset >= textData.length()) {
                return new DOMRefPosition(container, true);
            }
            ((Text)container).splitText(offset);
            return new DOMRefPosition(container, true);
        }
        return position;
    }

    public static IDOMPosition removeRange(DOMRange range) {
        boolean ordered = range.isOrdered();
        IDOMPosition end = ordered ? range.getEndPosition() : range.getStartPosition();
        return end;
    }

    public static IDOMPosition mergeIntoText(IDOMPosition position) {
        if (position.getContainerNode() instanceof Text) {
            return position;
        }
        Node pre = position.getPreviousSiblingNode();
        if (pre instanceof Text) {
            return new DOMPosition(pre, ((Text)pre).getData().length());
        }
        Node after = position.getNextSiblingNode();
        if (after instanceof Text) {
            return new DOMPosition(after, 0);
        }
        return position;
    }

    public static int displayOffsetToTextDataOffset(String displayData, String nodeData, int offset) {
        char[] display = displayData.toCharArray();
        if (offset >= display.length) {
            return nodeData.length();
        }
        char[] node = nodeData.toCharArray();
        int nodeDataLength = node.length;
        int displayIndex = 0;
        int nodeIndex = 0;
        while (displayIndex < offset && nodeIndex < nodeDataLength) {
            if (display[displayIndex] == node[nodeIndex]) {
                ++displayIndex;
                ++nodeIndex;
                continue;
            }
            if (HTMLUtil.isHTMLWhitespace(node[nodeIndex])) {
                if (HTMLUtil.isHTMLWhitespace(display[displayIndex])) {
                    ++displayIndex;
                    ++nodeIndex;
                    continue;
                }
                ++nodeIndex;
                continue;
            }
            ++displayIndex;
            ++nodeIndex;
        }
        if (nodeIndex >= nodeDataLength) {
            return nodeDataLength;
        }
        if (display[offset] != ' ') {
            while (nodeIndex < nodeDataLength && HTMLUtil.isHTMLWhitespace(node[nodeIndex])) {
                ++nodeIndex;
            }
        }
        return nodeIndex;
    }

    public static int textDataOffsetToDisplayOffset(String nodeData, String displayData, int offset) {
        if (offset >= nodeData.length()) {
            return displayData.length();
        }
        char[] node = nodeData.toCharArray();
        char[] display = displayData.toCharArray();
        int displayIndex = 0;
        int nodeIndex = 0;
        int displayDataLength = display.length;
        while (nodeIndex < offset && displayIndex < displayDataLength) {
            if (display[displayIndex] == node[nodeIndex]) {
                ++displayIndex;
                ++nodeIndex;
                continue;
            }
            if (HTMLUtil.isHTMLWhitespace(node[nodeIndex])) {
                if (HTMLUtil.isHTMLWhitespace(display[displayIndex])) {
                    ++displayIndex;
                    ++nodeIndex;
                    continue;
                }
                ++nodeIndex;
                continue;
            }
            ++displayIndex;
            ++nodeIndex;
        }
        return displayIndex;
    }

    public static IDOMPosition toDOMRefPosition(IDOMPosition position) {
        if (position.isText()) {
            return position;
        }
        if (position instanceof IDOMRefPosition) {
            return position;
        }
        if (position.getNextSiblingNode() != null) {
            return new DOMRefPosition(position.getNextSiblingNode(), false);
        }
        if (position.getPreviousSiblingNode() != null) {
            return new DOMRefPosition(position.getPreviousSiblingNode(), true);
        }
        return new DOMRefPosition2(position.getContainerNode(), true);
    }
}

