/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.property.LengthMeta;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class FontSizeMeta
extends LengthMeta {
    private static final String[] KEYWORDS = new String[]{"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "larger", "smaller"};
    public static final double MEDIUM_VAL_INT = 16.0;
    private static final double SCALING_FACTOR = 1.2;
    private static final double[] FACTORS = new double[]{0.6, 0.89, 1.0, 1.2, 1.5, 2.0, 3.0};
    private static final double[] CSS_ABSOLUTE_FACTORS = new double[]{0.63, 0.82, 1.0, 1.12, 1.5, 2.0, 3.0};
    private static final int MIN_SIZE_FOR_SMALLER = 1;
    private static final int MIN_SIZE_FOR_LARGER = 9;

    public FontSizeMeta() {
        super(true, new Length(16, false));
    }

    @Override
    protected ICSSFont getBaseFont(ICSSStyle style) {
        return style.getParentStyle().getCSSFont();
    }

    @Override
    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    @Override
    public int getPercentageType() {
        return 3;
    }

    @Override
    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        Object obj = super.calculateCSSValueResult(value, propertyName, style);
        if (obj instanceof Length) {
            return obj;
        }
        return this.convertKeyword(obj, style);
    }

    protected Length convertKeyword(Object fontsizeobj, ICSSStyle style) {
        int fontsize;
        int parentfontsize = style.getParentStyle().getCSSFont().getFontSize();
        if (fontsizeobj instanceof Length) {
            fontsize = ((Length)fontsizeobj).getValue();
        } else if ("xx-small".equals(fontsizeobj)) {
            fontsize = (int)(16.0 * CSS_ABSOLUTE_FACTORS[0]);
        } else if ("x-small".equals(fontsizeobj)) {
            fontsize = (int)(16.0 * CSS_ABSOLUTE_FACTORS[1]);
        } else if ("small".equals(fontsizeobj)) {
            fontsize = (int)(16.0 * CSS_ABSOLUTE_FACTORS[2]);
        } else if ("medium".equals(fontsizeobj)) {
            fontsize = (int)Math.round(16.0 * CSS_ABSOLUTE_FACTORS[3]);
        } else if ("large".equals(fontsizeobj)) {
            fontsize = (int)(16.0 * CSS_ABSOLUTE_FACTORS[4]);
        } else if ("x-large".equals(fontsizeobj)) {
            fontsize = (int)(16.0 * CSS_ABSOLUTE_FACTORS[5]);
        } else if ("xx-large".equals(fontsizeobj)) {
            fontsize = (int)(16.0 * CSS_ABSOLUTE_FACTORS[6]);
        } else if ("smaller".equals(fontsizeobj)) {
            fontsize = (int)((double)parentfontsize / 1.2);
            if (fontsize < 1) {
                fontsize = 1;
            }
        } else if ("larger".equals(fontsizeobj)) {
            fontsize = (int)((double)parentfontsize * 1.2);
            if (fontsize < 9) {
                fontsize = 9;
            }
        } else {
            fontsize = parentfontsize;
        }
        return new Length(fontsize, false);
    }

    @Override
    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        String size;
        if (("font".equalsIgnoreCase(htmltag) || "basefont".equalsIgnoreCase(htmltag)) && (size = DOMUtil.getAttributeIgnoreCase(element, "size")) != null) {
            size = size.trim();
            try {
                int fontSize = 0;
                fontSize = size.startsWith("+") ? Integer.parseInt(size.substring(1)) + 3 : (size.startsWith("-") ? 3 - Integer.parseInt(size.substring(1)) : Integer.parseInt(size));
                if (fontSize < 1) {
                    fontSize = 1;
                }
                if (fontSize > 7) {
                    fontSize = 7;
                }
                return new Length((int)Math.round(FACTORS[fontSize - 1] * 16.0), false);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }
}

