/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.misc;

import org.eclipse.persistence.internal.libraries.antlr.runtime.misc.FastQueue;

public abstract class LookaheadStream<T>
extends FastQueue<T> {
    public static final int UNINITIALIZED_EOF_ELEMENT_INDEX = Integer.MAX_VALUE;
    protected int currentElementIndex = 0;
    protected T prevElement;
    public T eof = null;
    protected int lastMarker;
    protected int markDepth = 0;

    @Override
    public void reset() {
        super.reset();
        this.currentElementIndex = 0;
        this.p = 0;
        this.prevElement = null;
    }

    public abstract T nextElement();

    public abstract boolean isEOF(T var1);

    @Override
    public T remove() {
        Object t = this.elementAt(0);
        ++this.p;
        if (this.p == this.data.size() && this.markDepth == 0) {
            this.prevElement = t;
            this.clear();
        }
        return t;
    }

    public void consume() {
        this.syncAhead(1);
        this.remove();
        ++this.currentElementIndex;
    }

    protected void syncAhead(int n) {
        int n2 = this.p + n - 1 - this.data.size() + 1;
        if (n2 > 0) {
            this.fill(n2);
        }
    }

    public void fill(int n) {
        for (int i = 1; i <= n; ++i) {
            T t = this.nextElement();
            if (this.isEOF(t)) {
                this.eof = t;
            }
            this.data.add(t);
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("streams are of unknown size");
    }

    public T LT(int n) {
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            return this.LB(-n);
        }
        this.syncAhead(n);
        if (this.p + n - 1 > this.data.size()) {
            return this.eof;
        }
        return this.elementAt(n - 1);
    }

    public int index() {
        return this.currentElementIndex;
    }

    public int mark() {
        ++this.markDepth;
        this.lastMarker = this.p;
        return this.lastMarker;
    }

    public void release(int n) {
    }

    public void rewind(int n) {
        --this.markDepth;
        int n2 = this.p - n;
        this.currentElementIndex -= n2;
        this.p = n;
    }

    public void rewind() {
        int n = this.p - this.lastMarker;
        this.currentElementIndex -= n;
        this.p = this.lastMarker;
    }

    public void seek(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("can't seek before the beginning of the input");
        }
        int n2 = this.currentElementIndex - n;
        if (this.p - n2 < 0) {
            throw new UnsupportedOperationException("can't seek before the beginning of this stream's buffer");
        }
        this.p -= n2;
        this.currentElementIndex = n;
    }

    protected T LB(int n) {
        assert (n > 0);
        int n2 = this.p - n;
        if (n2 == -1) {
            return this.prevElement;
        }
        if (n2 >= 0) {
            return (T)this.data.get(n2);
        }
        if (n2 < -1) {
            throw new UnsupportedOperationException("can't look more than one token before the beginning of this stream's buffer");
        }
        throw new UnsupportedOperationException("can't look past the end of this stream's buffer using LB(int)");
    }
}

