/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.gen.internal.ORMGenColumn;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.ORMGenTable;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.ColumnGenPanel;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.SWTUtil;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TableGenPanel;
import org.eclipse.jpt.jpa.ui.wizards.gen.JptJpaUiWizardsEntityGenMessages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TablesAndColumnsCustomizationWizardPage
extends NewTypeWizardPage {
    private JpaProject jpaProject;
    private TreeViewer tableColumnTreeViewer;
    protected Composite detailPanel;
    protected StackLayout detailPanelStatckLayout;
    protected Composite tableGenDetatilGroup;
    protected ColumnGenPanel columnGenPanel;
    protected Composite columnGenDetatilGroup;
    protected TableGenPanel tableGenPanel;
    protected ORMGenTable selectedTable;
    private ORMGenCustomizer customizer;
    protected final ResourceManager resourceManager;

    public TablesAndColumnsCustomizationWizardPage(JpaProject jpaProject, ResourceManager resourceManager) {
        super(true, "TablesAndColumnsCustomizationWizardPage");
        this.jpaProject = jpaProject;
        this.resourceManager = resourceManager;
        this.setTitle(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLES_AND_COLUMNS_PAGE_TITLE);
        this.setMessage(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLES_AND_COLUMNS_PAGE_DESC);
    }

    public void init(IStructuredSelection selection) {
        if (this.jpaProject != null) {
            IJavaProject jelem = this.jpaProject.getJavaProject();
            this.initContainerPage((IJavaElement)jelem);
            this.initTypePage((IJavaElement)jelem);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        WorkbenchTools.setHelp((Control)composite, (String)JpaHelpContextIds.GENERATE_ENTITIES_WIZARD_CUSTOMIZE_INDIVIDUAL_ENTITIES);
        this.createTableAndColumnsListPanel(composite, 1);
        SWTUtil.createLabel(composite, 1, "");
        SWTUtil.createSeparator(composite, 1);
        this.createGenerateDetailGroup(composite, 1);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    private void createTableAndColumnsListPanel(Composite parent, int columns) {
        Label label = new Label(parent, columns);
        label.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_TABLES_AND_COLUMNS_PAGE_LABEL_TABLE_AND_COLUMNS);
        SWTUtil.fillColumns((Control)label, columns);
        GridData data = new GridData();
        data.horizontalSpan = columns;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 200;
        data.grabExcessVerticalSpace = true;
        this.tableColumnTreeViewer = new TreeViewer(parent);
        this.tableColumnTreeViewer.getTree().setLayoutData((Object)data);
        this.tableColumnTreeViewer.setContentProvider((IContentProvider)new TableColumnTreeContentProvider());
        this.tableColumnTreeViewer.setLabelProvider((IBaseLabelProvider)new TableColumnTreeLabelProvider());
        this.tableColumnTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TablesAndColumnsCustomizationWizardPage.this.updateDetailPanel(event.getSelection());
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ORMGenCustomizer customizer = this.getCustomizer();
            if (this.customizer != customizer) {
                this.customizer = customizer;
                this.tableColumnTreeViewer.setInput((Object)customizer);
            } else {
                this.tableColumnTreeViewer.refresh();
            }
            List tableNames = this.customizer.getTableNames();
            ORMGenTable ormGenTable = this.customizer.getTable((String)tableNames.get(0));
            this.updateTabelGenDetail(ormGenTable);
        }
    }

    private void updateDetailPanel(ISelection selection) {
        TreeSelection ts = (TreeSelection)selection;
        Object selectedObject = ts.getFirstElement();
        if (selectedObject instanceof ORMGenTable) {
            this.updateTabelGenDetail((ORMGenTable)selectedObject);
        } else if (selectedObject instanceof ORMGenColumn) {
            this.updateColumnGenDetail((ORMGenColumn)selectedObject);
        }
    }

    protected void updateColumnGenDetail(ORMGenColumn column) {
        if (this.columnGenDetatilGroup == null) {
            this.columnGenDetatilGroup = new Composite(this.detailPanel, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            this.columnGenDetatilGroup.setLayout((Layout)gridLayout);
            this.columnGenPanel = new ColumnGenPanel(this.columnGenDetatilGroup, 4, this.getCustomizer(), this, false);
        }
        this.columnGenPanel.setColumn(column);
        this.detailPanelStatckLayout.topControl = this.columnGenDetatilGroup;
        this.detailPanel.layout();
        this.detailPanel.getParent().layout();
    }

    protected void updateTabelGenDetail(ORMGenTable table) {
        this.selectedTable = table;
        if (this.tableGenDetatilGroup == null) {
            this.tableGenDetatilGroup = new Composite(this.detailPanel, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 4;
            this.tableGenDetatilGroup.setLayout((Layout)gridLayout);
            this.tableGenPanel = new TableGenPanel(this.tableGenDetatilGroup, 4, false, (WizardPage)this);
            this.createDomainJavaClassesPropertiesGroup(this.tableGenDetatilGroup, 4);
        }
        this.tableGenPanel.setORMGenTable(table);
        this.tableGenPanel.updateControls();
        this.detailPanelStatckLayout.topControl = this.tableGenDetatilGroup;
        this.detailPanel.layout();
        String baseClass = StringTools.isBlank((String)table.getExtends()) ? "" : table.getExtends();
        this.setSuperClass(baseClass, true);
        this.setSuperInterfaces(table.getImplements(), true);
        this.detailPanel.getParent().layout();
    }

    protected void createDomainJavaClassesPropertiesGroup(Composite composite, int columns) {
        Group parent = new Group(composite, 0);
        parent.setText(JptJpaUiWizardsEntityGenMessages.GENERATE_ENTITIES_WIZARD_DEFAULT_TABLE_PAGE_DOMAIN_JAVA_CLASS);
        parent.setLayout((Layout)new GridLayout(columns, false));
        SWTUtil.fillColumns((Control)parent, columns);
        this.createSuperClassControls((Composite)parent, columns);
        this.createSuperInterfacesControls((Composite)parent, columns);
        Control[] controls = parent.getChildren();
        if (controls.length > 1 && controls[1] instanceof Text) {
            Text text = (Text)parent.getChildren()[1];
            LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
            LayoutUtil.setHorizontalGrabbing((Control)text);
        }
    }

    protected IStatus superClassChanged() {
        String oldBaseClass;
        IStatus status = super.superClassChanged();
        String baseClass = this.getSuperClass();
        if (baseClass != null && this.selectedTable != null && !baseClass.equals(oldBaseClass = this.selectedTable.getExtends())) {
            this.selectedTable.setExtends(baseClass);
        }
        return status;
    }

    protected IStatus superInterfacesChanged() {
        IStatus status = super.superInterfacesChanged();
        List superInterfaces = this.getSuperInterfaces();
        if (this.selectedTable != null) {
            this.selectedTable.setImplements(superInterfaces);
        }
        return status;
    }

    public boolean addSuperInterface(String superInterface) {
        super.addSuperInterface(superInterface);
        List interfaces = this.getSuperInterfaces();
        if (this.selectedTable != null) {
            this.selectedTable.setImplements(interfaces);
        }
        return true;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (this.fSuperClassStatus.matches(4)) {
            this.updateStatus(this.fSuperClassStatus);
        } else {
            this.setMessage("", 0);
            this.setErrorMessage(null);
        }
    }

    protected ORMGenCustomizer getCustomizer() {
        return this.getWizard().getCustomizer();
    }

    public GenerateEntitiesFromSchemaWizard getWizard() {
        return (GenerateEntitiesFromSchemaWizard)super.getWizard();
    }

    public boolean isDynamic() {
        return false;
    }

    private void createGenerateDetailGroup(Composite parent, int columns) {
        this.detailPanel = new Composite(parent, 0);
        SWTUtil.fillColumns((Control)this.detailPanel, columns);
        this.detailPanelStatckLayout = new StackLayout();
        this.detailPanel.setLayout((Layout)this.detailPanelStatckLayout);
        Composite emptyPanel = new Composite(this.detailPanel, 0);
        emptyPanel.setLayoutData((Object)new GridData());
        this.detailPanelStatckLayout.topControl = emptyPanel;
        this.detailPanel.layout();
    }

    public final void performHelp() {
        WorkbenchTools.displayHelp((String)this.getWizard().getHelpContextID());
    }

    class TableColumnTreeContentProvider
    implements ITreeContentProvider {
        TableColumnTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ORMGenCustomizer) {
                ORMGenCustomizer input = (ORMGenCustomizer)inputElement;
                List tableNameList = input.getGenTableNames();
                ArrayList<ORMGenTable> ret = new ArrayList<ORMGenTable>();
                for (String t : tableNameList) {
                    ORMGenTable ormGenTable = TablesAndColumnsCustomizationWizardPage.this.getCustomizer().getTable(t);
                    ret.add(ormGenTable);
                }
                return ret.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ORMGenTable) {
                ORMGenTable table = (ORMGenTable)parentElement;
                List columns = table.getColumns();
                ArrayList<ORMGenColumn> ret = new ArrayList<ORMGenColumn>();
                for (ORMGenColumn col : columns) {
                    if (col.isForeignKey()) continue;
                    if (col.isPrimaryKey()) {
                        ret.add(0, col);
                        continue;
                    }
                    ret.add(col);
                }
                return ret.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ORMGenColumn) {
                return null;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ORMGenTable;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class TableColumnTreeLabelProvider
    extends LabelProvider {
        TableColumnTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ORMGenTable) {
                return TablesAndColumnsCustomizationWizardPage.this.resourceManager.createImage(JptJpaUiImages.ENTITY_GEN_TABLE);
            }
            if (element instanceof ORMGenColumn) {
                ORMGenColumn col = (ORMGenColumn)element;
                return col.isPrimaryKey() ? TablesAndColumnsCustomizationWizardPage.this.resourceManager.createImage(JptJpaUiImages.ENTITY_GEN_KEY_COLUMN) : TablesAndColumnsCustomizationWizardPage.this.resourceManager.createImage(JptJpaUiImages.ENTITY_GEN_COLUMN);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ORMGenTable) {
                return ((ORMGenTable)element).getName();
            }
            if (element instanceof ORMGenColumn) {
                return ((ORMGenColumn)element).getName();
            }
            return super.getText(element);
        }
    }
}

