/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.plugin;

import java.util.Hashtable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.internal.ui.text.JavaReconciler;
import org.eclipse.jpt.common.core.internal.utility.JptPlugin;
import org.eclipse.jpt.common.ui.internal.JptUIPlugin;
import org.eclipse.jpt.common.ui.internal.swt.widgets.Adapter;
import org.eclipse.jpt.common.utility.internal.reference.AbstractBooleanReference;
import org.eclipse.jpt.common.utility.reference.BooleanReference;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.ui.internal.InternalJpaWorkbench;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.BundleContext;

public class JptJpaUiPlugin
extends JptUIPlugin {
    private final Hashtable<IWorkbench, InternalJpaWorkbench> jpaWorkbenches = new Hashtable();
    private final FocusIsNotInDaliViewFlag focusIsNotInDaliViewFlag = new FocusIsNotInDaliViewFlag();
    private final AsyncEventListenerFlag asyncEventListenerFlag = new AsyncEventListenerFlag((BooleanReference)this.focusIsNotInDaliViewFlag);
    private volatile Display display;
    private final Listener focusListener = new FocusListener();
    private static JptJpaUiPlugin INSTANCE;
    private static final Object DALI_UI_DATA;

    static {
        DALI_UI_DATA = new Object();
    }

    public static JptJpaUiPlugin instance() {
        return INSTANCE;
    }

    protected void setInstance(JptPlugin plugin) {
        INSTANCE = (JptJpaUiPlugin)plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getJpaProjectManager().addJavaEventListenerFlag((BooleanReference)this.asyncEventListenerFlag);
        this.display = Display.getCurrent();
        if (this.display != null && !this.display.isDisposed()) {
            this.display.addFilter(15, this.focusListener);
        }
    }

    private JpaProjectManager getJpaProjectManager() {
        return this.getJpaWorkspace().getJpaProjectManager();
    }

    private JpaWorkspace getJpaWorkspace() {
        return (JpaWorkspace)ResourcesPlugin.getWorkspace().getAdapter(JpaWorkspace.class);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.disposeJpaWorkbenches();
            if (this.display != null && !this.display.isDisposed()) {
                this.display.removeFilter(15, this.focusListener);
            }
            this.getJpaProjectManager().removeJavaEventListenerFlag((BooleanReference)this.asyncEventListenerFlag);
        }
        finally {
            this.display = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalJpaWorkbench getJpaWorkbench(IWorkbench workbench) {
        Hashtable<IWorkbench, InternalJpaWorkbench> hashtable = this.jpaWorkbenches;
        synchronized (hashtable) {
            return this.getJpaWorkbench_(workbench);
        }
    }

    private InternalJpaWorkbench getJpaWorkbench_(IWorkbench workbench) {
        InternalJpaWorkbench jpaWorkbench = this.jpaWorkbenches.get(workbench);
        if (jpaWorkbench == null && this.isActive()) {
            jpaWorkbench = this.buildJpaWorkbench(workbench);
            this.jpaWorkbenches.put(workbench, jpaWorkbench);
        }
        return jpaWorkbench;
    }

    private InternalJpaWorkbench buildJpaWorkbench(IWorkbench workbench) {
        return new InternalJpaWorkbench(workbench);
    }

    private void disposeJpaWorkbenches() {
        for (InternalJpaWorkbench jpaWorkbench : this.jpaWorkbenches.values()) {
            try {
                jpaWorkbench.dispose();
            }
            catch (Throwable ex) {
                this.logError(ex);
            }
        }
        this.jpaWorkbenches.clear();
    }

    public boolean focusIsNotInDaliView() {
        return this.focusIsNotInDaliViewFlag.getValue();
    }

    void focusIn(Control control) {
        this.focusIsNotInDaliViewFlag.setValue(this.controlIsNonDali(control));
        this.focusIsNotInDaliViewFlag.control = control;
    }

    private boolean controlIsNonDali(Control control) {
        return !this.controlIsDali(control);
    }

    /*
     * Unable to fully structure code
     */
    private boolean controlIsDali(Control control) {
        id = this.getPluginID();
        if (id != null) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if (control.getData(id) == JptJpaUiPlugin.DALI_UI_DATA) {
                return true;
            }
            control = control.getParent();
lbl7:
            // 2 sources

            ** while (control != null)
        }
lbl8:
        // 1 sources

        return false;
    }

    public void controlAffectsJavaSource(Control control) {
        String id = this.getPluginID();
        if (id != null) {
            control.setData(id, DALI_UI_DATA);
        }
    }

    static class AsyncEventListenerFlag
    extends AbstractBooleanReference {
        private final BooleanReference focusIsNotInDaliViewFlag;
        private static final String JAVA_RECONCILER_THREAD_NAME = JavaReconciler.class.getName();

        AsyncEventListenerFlag(BooleanReference focusIsNotInDaliViewFlag) {
            this.focusIsNotInDaliViewFlag = focusIsNotInDaliViewFlag;
        }

        public boolean getValue() {
            if (Thread.currentThread().getName().equals(JAVA_RECONCILER_THREAD_NAME)) {
                return this.focusIsNotInDaliViewFlag.getValue();
            }
            return true;
        }
    }

    static class FocusIsNotInDaliViewFlag
    extends AbstractBooleanReference {
        private volatile boolean value = true;
        volatile Control control;

        FocusIsNotInDaliViewFlag() {
        }

        public boolean getValue() {
            return this.value;
        }

        public boolean setValue(boolean value) {
            boolean old = this.value;
            this.value = value;
            return old;
        }
    }

    class FocusListener
    extends Adapter {
        FocusListener() {
        }

        public void handleEvent(Event event) {
            JptJpaUiPlugin.this.focusIn((Control)event.widget);
        }
    }
}

