/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.PrimaryKeyJoinColumnDialog;
import org.eclipse.jpt.jpa.ui.internal.details.PrimaryKeyJoinColumnStateObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractPrimaryKeyJoinColumnsComposite<T extends Entity>
extends Pane<T> {
    protected ModifiableCollectionValueModel<SpecifiedPrimaryKeyJoinColumn> selectedPkJoinColumnsModel;

    public AbstractPrimaryKeyJoinColumnsComposite(Pane<? extends T> subjectHolder, Composite parent) {
        super(subjectHolder, parent);
    }

    SpecifiedPrimaryKeyJoinColumn addJoinColumn(PrimaryKeyJoinColumnStateObject stateObject) {
        SpecifiedPrimaryKeyJoinColumn joinColumn = ((Entity)this.getSubject()).addSpecifiedPrimaryKeyJoinColumn();
        stateObject.updateJoinColumn((SpecifiedBaseJoinColumn)joinColumn);
        return joinColumn;
    }

    SpecifiedPrimaryKeyJoinColumn addPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.getShell(), this.getResourceManager(), (Entity)this.getSubject());
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog.wasConfirmed() ? this.addJoinColumn((PrimaryKeyJoinColumnStateObject)dialog.getSubject()) : null;
    }

    protected abstract ListValueModel<? extends PrimaryKeyJoinColumn> buildDefaultJoinColumnsListHolder();

    private ModifiableCollectionValueModel<SpecifiedPrimaryKeyJoinColumn> buildSelectedJoinColumnsModel() {
        return new SimpleCollectionValueModel();
    }

    String buildJoinColumnLabel(PrimaryKeyJoinColumn joinColumn) {
        if (joinColumn.isVirtual()) {
            return NLS.bind((String)JptJpaUiDetailsMessages.PRIMARY_KEY_JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS_DEFAULT, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptJpaUiDetailsMessages.PRIMARY_KEY_JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS_BOTH_DEFAULT, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptJpaUiDetailsMessages.PRIMARY_KEY_JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS_FIRST_DEFAULT, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptJpaUiDetailsMessages.PRIMARY_KEY_JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS_SECOND_DEFAULT, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptJpaUiDetailsMessages.PRIMARY_KEY_JOIN_COLUMNS_COMPOSITE_MAPPING_BETWEEN_TWO_PARAMS, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private AddRemovePane.Adapter<SpecifiedPrimaryKeyJoinColumn> buildJoinColumnsAdapter() {
        return new AddRemovePane.AbstractAdapter<SpecifiedPrimaryKeyJoinColumn>(){

            public SpecifiedPrimaryKeyJoinColumn addNewItem() {
                return AbstractPrimaryKeyJoinColumnsComposite.this.addPrimaryKeyJoinColumn();
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return JptJpaUiDetailsMessages.PRIMARY_KEY_JOIN_COLUMNS_COMPOSITE_EDIT;
            }

            public void optionOnSelection(CollectionValueModel<SpecifiedPrimaryKeyJoinColumn> selectedItemsModel) {
                AbstractPrimaryKeyJoinColumnsComposite.this.editPrimaryKeyJoinColumn((SpecifiedPrimaryKeyJoinColumn)selectedItemsModel.iterator().next());
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<SpecifiedPrimaryKeyJoinColumn> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<SpecifiedPrimaryKeyJoinColumn> selectedItemsModel) {
                SpecifiedPrimaryKeyJoinColumn joinColumn = (SpecifiedPrimaryKeyJoinColumn)selectedItemsModel.iterator().next();
                ((Entity)AbstractPrimaryKeyJoinColumnsComposite.this.getSubject()).removeSpecifiedPrimaryKeyJoinColumn(joinColumn);
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return AbstractPrimaryKeyJoinColumnsComposite.this.buildJoinColumnLabel((PrimaryKeyJoinColumn)element);
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultPrimaryKeyJoinColumnHolder();
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        list.add(this.buildDefaultJoinColumnsListHolder());
        return CompositeListValueModel.forModels(list);
    }

    private ListValueModel<PrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildPrimaryKeyJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    ListValueModel<SpecifiedPrimaryKeyJoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<Entity, SpecifiedPrimaryKeyJoinColumn>(this.getSubjectHolder(), new String[]{"specifiedPrimaryKeyJoinColumns"}){

            protected ListIterable<SpecifiedPrimaryKeyJoinColumn> getListIterable() {
                return new SuperListIterableWrapper(((Entity)this.subject).getSpecifiedPrimaryKeyJoinColumns());
            }

            protected int size_() {
                return ((Entity)this.subject).getSpecifiedPrimaryKeyJoinColumnsSize();
            }
        };
    }

    void editJoinColumn(PrimaryKeyJoinColumnStateObject stateObject) {
        stateObject.updateJoinColumn((SpecifiedBaseJoinColumn)stateObject.getJoinColumn());
    }

    void editPrimaryKeyJoinColumn(SpecifiedPrimaryKeyJoinColumn joinColumn) {
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.getShell(), this.getResourceManager(), (Entity)this.getSubject(), joinColumn);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.wasConfirmed()) {
            this.editJoinColumn((PrimaryKeyJoinColumnStateObject)dialog.getSubject());
        }
    }

    protected void initialize() {
        super.initialize();
        this.selectedPkJoinColumnsModel = this.buildSelectedJoinColumnsModel();
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, JptJpaUiDetailsMessages.PRIMARY_KEY_JOIN_COLUMNS_COMPOSITE_PRIMARY_KEY_JOIN_COLUMN);
    }

    protected void initializeLayout(Composite container) {
        this.addCheckBox(container, JptJpaUiDetailsMessages.PRIMARY_KEY_JOIN_COLUMNS_COMPOSITE_OVERRIDE_DEFAULT_PRIMARY_KEY_JOIN_COLUMNS, this.buildOverrideDefaultJoinColumnHolder(), null);
        new AddRemoveListPane((Pane)this, container, this.buildJoinColumnsAdapter(), this.buildPrimaryKeyJoinColumnsListModel(), this.selectedPkJoinColumnsModel, this.buildJoinColumnsListLabelProvider(), this.buildOverrideDefaultJoinColumnHolder(), JpaHelpContextIds.MAPPING_JOIN_TABLE_COLUMNS);
    }

    void updatePrimaryKeyJoinColumns(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            if (selected) {
                ((Entity)this.getSubject()).convertDefaultPrimaryKeyJoinColumnsToSpecified();
            } else {
                ((Entity)this.getSubject()).clearSpecifiedPrimaryKeyJoinColumns();
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    private class OverrideDefaultPrimaryKeyJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements ModifiablePropertyValueModel<Boolean> {
        public OverrideDefaultPrimaryKeyJoinColumnHolder() {
            super(AbstractPrimaryKeyJoinColumnsComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            if (this.listModel.size() > 0) {
                return true;
            }
            return false;
        }

        public void setValue(Boolean value) {
            AbstractPrimaryKeyJoinColumnsComposite.this.updatePrimaryKeyJoinColumns(value);
        }
    }
}

