/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.common.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.ArithmeticBinaryOperator;

abstract class NoDivArithmeticBinaryOperator
extends ArithmeticBinaryOperator {
    NoDivArithmeticBinaryOperator(DiagnosticFactory diagnosticFactory) {
        super(diagnosticFactory);
    }

    @Override
    protected abstract Long doRealOperation(Long var1, Long var2);

    @Override
    protected abstract Double doRealOperation(Double var1, Double var2);

    @Override
    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return new IntegerLiteralType(0L);
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstArg) || "Ljava.math.BigDecimal;".equals(boxedSecondArg)) {
            return this.handleNumericArithmetic(firstArg, secondArg, BigDecimal.class);
        }
        if ("Ljava.lang.Double;".equals(boxedFirstArg) || "Ljava.lang.Double;".equals(boxedSecondArg) || "Ljava.lang.Float;".equals(boxedFirstArg) || "Ljava.lang.Float;".equals(boxedSecondArg)) {
            if ("Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
                return this.handleNumericArithmetic(firstArg, secondArg, BigDecimal.class);
            }
            return this.handleNumericArithmetic(firstArg, secondArg, Double.class);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.handleNumericArithmetic(firstArg, secondArg, BigInteger.class);
        }
        return this.handleNumericArithmetic(firstArg, secondArg, Long.class);
    }

    @Override
    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if ("Ljava.lang.Object;".equals(firstArg.getSignature()) || "Ljava.lang.Object;".equals(secondArg.getSignature())) {
            return Diagnostic.OK_INSTANCE;
        }
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return this._diagnosticFactory.create_BINARY_OP_BOTH_OPERANDS_NULL(this.getOperatorName());
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDecimal;".equals(boxedFirstArg) || "Ljava.math.BigDecimal;".equals(boxedSecondArg)) {
            return this.validateNumericArithmetic(firstArg, secondArg, BigDecimal.class);
        }
        if ("Ljava.lang.Double;".equals(boxedFirstArg) || "Ljava.lang.Double;".equals(boxedSecondArg) || "Ljava.lang.Float;".equals(boxedFirstArg) || "Ljava.lang.Float;".equals(boxedSecondArg)) {
            if ("Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
                return this.validateNumericArithmetic(firstArg, secondArg, BigDecimal.class);
            }
            return this.validateNumericArithmetic(firstArg, secondArg, Double.class);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.validateNumericArithmetic(firstArg, secondArg, BigInteger.class);
        }
        return this.validateNumericArithmetic(firstArg, secondArg, Long.class);
    }

    protected ValueType handleNumericArithmetic(ValueType firstArg, ValueType secondArg, Class numberType) {
        block12: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
                if (!(firstArg instanceof LiteralType) || !(secondArg instanceof LiteralType)) break block12;
                try {
                    Number firstValue = ((LiteralType)firstArg).coerceToNumber(numberType);
                    Number secondValue = ((LiteralType)secondArg).coerceToNumber(numberType);
                    FloatLiteralType result = null;
                    if (numberType == Double.class) {
                        Double resultValue = this.doRealOperation((Double)firstValue, (Double)secondValue);
                        result = new FloatLiteralType(resultValue.doubleValue());
                    } else if (numberType == Long.class) {
                        Long resultValue = this.doRealOperation((Long)firstValue, (Long)secondValue);
                        result = new IntegerLiteralType(resultValue.longValue());
                    } else {
                        throw new AssertionError((Object)"unsupport arithmetic upcast type");
                    }
                    return result;
                }
                catch (TypeCoercionException typeCoercionException) {
                    return null;
                }
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        if (numberType == BigDecimal.class) {
            return new ValueType("Ljava.math.BigDecimal;", 2);
        }
        if (numberType == Double.class) {
            return new ValueType("D", 2);
        }
        if (numberType == BigInteger.class) {
            return new ValueType("Ljava.math.BigInteger;", 2);
        }
        return new ValueType("J", 2);
    }

    protected Diagnostic validateNumericArithmetic(ValueType firstArg, ValueType secondArg, Class numberType) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            if (firstArg instanceof LiteralType && secondArg instanceof LiteralType) {
                try {
                    Number firstValue = ((LiteralType)firstArg).coerceToNumber(numberType);
                    Number secondValue = ((LiteralType)secondArg).coerceToNumber(numberType);
                    Number result = null;
                    if (numberType == Double.class) {
                        result = this.doRealOperation((Double)firstValue, (Double)secondValue);
                    } else if (numberType == Long.class) {
                        result = this.doRealOperation((Long)firstValue, (Long)secondValue);
                    } else {
                        throw new AssertionError((Object)"unsupport arithmetic upcast type");
                    }
                    return this._diagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(this.getOperatorName(), result.toString());
                }
                catch (TypeCoercionException typeCoercionException) {
                    return this._diagnosticFactory.create_BINARY_OP_COULD_NOT_COERCE_LITERALS_TO_NUMBERS();
                }
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return this._diagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(this.getOperatorName());
        }
    }
}

