/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.validation.internal.appconfig.ILocalizedMessage;
import org.eclipse.jst.jsf.validation.internal.appconfig.Messages;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public final class DiagnosticFactory {
    public static final int EL_EXPR_MUST_BE_IN_HASH_BRACES_ID = 0;
    public static final int SYNTAX_ERROR_IN_EL_ID = 1;
    public static final int CANNOT_FIND_CLASS_NAME_ID = 2;
    public static final int FULLY_QUALIFIED_NAME_MUST_BE_A_CLASS_ID = 3;
    public static final int CLASS_MUST_BE_INSTANCE_OF_ID = 4;
    public static final int CLASS_MUST_BE_CONCRETE_ID = 5;
    public static final int CLASS_MUST_HAVE_DEFAULT_OR_ADAPTER_CONSTRUCTOR_ID = 6;
    public static final int API_DEPRECATED_AFTER_VERSION_ID = 7;
    public static final int BEAN_PROPERTY_NOT_FOUND_ID = 8;
    public static final int MUST_BE_A_VALID_JAVA_IDENT_ID = 9;
    public static final int BEAN_SCOPE_NOT_VALID_ID = 10;
    public static final int MAP_ENTRIES_CAN_ONLY_BE_SET_ON_MAP_TYPE_ID = 11;
    public static final int LIST_ENTRIES_CAN_ONLY_BE_SET_ON_LIST_TYPE_ID = 12;
    public static final int API_NOT_AVAILABLE_BEFORE_VERSION_ID = 13;
    public static final int APP_CONFIG_IS_NEWER_THAN_JSF_VERSION_ID = 14;
    public static final int APP_CONFIG_IS_OLDER_THAN_JSF_VERSION_ID = 15;
    public static final int LOCALE_FORMAT_NOT_VALID_ID = 16;
    public static final int BEAN_SCOPE_NOT_VALID_JSF2_ID = 17;

    public static IMessage create_EL_EXPR_MUST_BE_IN_HASH_BRACES() {
        return new MyLocalizedMessage(2, Messages.EL_EXPR_MUST_BE_IN_HASH_BRACES_ID, null, 0);
    }

    public static IMessage create_SYNTAX_ERROR_IN_EL() {
        return new MyLocalizedMessage(2, Messages.SYNTAX_ERROR_IN_EL_ID, null, 1);
    }

    public static IMessage create_CANNOT_FIND_CLASS_NAME(String className) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.CANNOT_FIND_CLASS_NAME_ID, className), null, 2);
    }

    public static IMessage create_FULLY_QUALIFIED_NAME_MUST_BE_A_CLASS(String fullyQualifiedName) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.FULLY_QUALIFIED_NAME_MUST_BE_A_CLASS_ID, fullyQualifiedName), null, 3);
    }

    public static IMessage create_CLASS_MUST_BE_INSTANCE_OF(String className, String extensionType, String expectedSuper) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.CLASS_MUST_BE_INSTANCE_OF_ID, className, extensionType, expectedSuper), null, 4);
    }

    public static IMessage create_CLASS_MUST_BE_CONCRETE(String className) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.CLASS_MUST_BE_CONCRETE_ID, className), null, 5);
    }

    public static IMessage create_API_DEPRECATED_AFTER_VERSION_ID(String apiName, String afterVersion, String useInstead) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.API_DEPRECATED_AFTER_VERSION_ID, apiName, afterVersion, useInstead), null, 7);
    }

    public static IMessage create_BEAN_PROPERTY_NOT_FOUND(String propertyName, String beanClassName) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.BEAN_PROPERTY_NOT_FOUND_ID, propertyName, beanClassName), null, 8);
    }

    public static IMessage create_MUST_BE_A_VALID_JAVA_IDENT(String nameOfId) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.MUST_BE_A_VALID_JAVA_IDENT_ID, nameOfId), null, 9);
    }

    public static IMessage create_BEAN_SCOPE_NOT_VALID() {
        return new MyLocalizedMessage(2, Messages.BEAN_SCOPE_NOT_VALID_ID, null, 10);
    }

    public static IMessage create_BEAN_SCOPE_NOT_VALID_JSF2() {
        return new MyLocalizedMessage(2, Messages.BEAN_SCOPE_NOT_VALID_JSF2_ID, null, 17);
    }

    public static IMessage create_MAP_ENTRIES_CAN_ONLY_BE_SET_ON_MAP_TYPE(String targetName) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.MAP_ENTRIES_CAN_ONLY_BE_SET_ON_MAP_TYPE_ID, targetName), null, 11);
    }

    public static IMessage create_LIST_ENTRIES_CAN_ONLY_BE_SET_ON_LIST_TYPE(String targetName) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.LIST_ENTRIES_CAN_ONLY_BE_SET_ON_LIST_TYPE_ID, targetName), null, 12);
    }

    public static IMessage create_API_NOT_AVAILABLE_BEFORE_VERSION(String apiName, String beforeVersion, String useInstead) {
        return new MyLocalizedMessage(2, MessageFormat.format(Messages.API_NOT_AVAILABLE_BEFORE_VERSION_ID, apiName, beforeVersion, useInstead), null, 13);
    }

    public static IMessage create_APP_CONFIG_IS_NEWER_THAN_JSF_VERSION(IFile file) {
        MyLocalizedMessage message = new MyLocalizedMessage(1, Messages.APP_CONFIG_IS_NEWER_THAN_JSF_VERSION_ID, null, 14);
        message.setTargetObject(file);
        return message;
    }

    public static IMessage create_APP_CONFIG_IS_OLDER_THAN_JSF_VERSION(IFile file, String appConfigVersion, String projectVersion) {
        MyLocalizedMessage message = new MyLocalizedMessage(2, MessageFormat.format(Messages.APP_CONFIG_IS_OLDER_THAN_JSF_VERSION_ID, appConfigVersion, projectVersion), null, 15);
        message.setTargetObject(file);
        return message;
    }

    public static IMessage create_LOCALE_FORMAT_NOT_VALID() {
        MyLocalizedMessage message = new MyLocalizedMessage(2, Messages.LOCALE_FORMAT_NOT_VALID_ID, null, 16);
        return message;
    }

    static class MyLocalizedMessage
    extends Message
    implements ILocalizedMessage {
        private final String _message;
        private final int _errorCode;

        public MyLocalizedMessage(int severity, String messageText, IResource targetObject, int errorCode) {
            this(severity, messageText, (Object)targetObject, errorCode);
        }

        private MyLocalizedMessage(int severity, String messageText, Object targetObject, int errorCode) {
            super(JSFCorePlugin.getDefault().getBundle().getSymbolicName(), severity, messageText);
            this._message = messageText;
            this.setTargetObject(targetObject);
            this._errorCode = errorCode;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        @Override
        public int getErrorCode() {
            return this._errorCode;
        }

        public boolean appliesTo(int offset) {
            return offset >= this.getOffset() && offset < this.getOffset() + this.getLength();
        }
    }
}

