/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.datatypes.ELExpression;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.AbstractViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.DTUIViewRoot;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.ViewObjectConstructionStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewObjectMappingService;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XMLViewDefnAdapter
extends AbstractViewDefnAdapter<Node, IDocument> {
    private static final String GENERATED_ID = "_generatedId";

    @Override
    public abstract IDocument getContainer(DTFacesContext var1, String var2);

    @Override
    public String getId(Node viewDefnObject) throws IllegalArgumentException {
        if (viewDefnObject instanceof Element) {
            return ((Element)viewDefnObject).getAttribute("id");
        }
        throw new IllegalArgumentException("Only Elements can define view object ids");
    }

    @Override
    public ViewObject mapToViewObject(Node viewDefnObject, ViewObjectConstructionStrategy<? extends Node> constructionData, IDocument document) {
        switch (viewDefnObject.getNodeType()) {
            case 1: {
                return this.createFromElement((Element)viewDefnObject, constructionData, document);
            }
        }
        return null;
    }

    public ITagElement mapToTagElement(Node viewDefnObject, IDocument viewContainer) {
        if (viewDefnObject instanceof Element) {
            return this.findTagElement((Element)viewDefnObject, viewContainer);
        }
        return null;
    }

    @Override
    public List<Node> getViewDefnRoots(IDocument container) {
        Document doc;
        IDOMContextResolver resolver;
        ArrayList<Node> roots = new ArrayList<Node>();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(container, -1);
        if (context != null && (resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context)) != null && (doc = resolver.getDOMDocument()) != null) {
            roots.add(doc);
        }
        return roots;
    }

    @Override
    public ViewObject findViewObject(Node viewDefnObject, ComponentInfo root) {
        IStructuredDocumentContext context;
        IAdaptable services;
        Object serviceAdapter;
        if (root instanceof DTUIViewRoot && viewDefnObject instanceof Element && (serviceAdapter = (services = ((DTUIViewRoot)root).getServices()).getAdapter(XMLViewObjectMappingService.class)) instanceof XMLViewObjectMappingService && (context = this.getContext(viewDefnObject)) != null) {
            String uri = this.getNamespace((Element)viewDefnObject, context.getStructuredDocument());
            XMLViewObjectMappingService.ElementData elementData = XMLViewObjectMappingService.createElementData(uri, viewDefnObject.getLocalName(), context, Collections.EMPTY_MAP);
            return ((XMLViewObjectMappingService)serviceAdapter).findViewObject(elementData);
        }
        return null;
    }

    private IStructuredDocumentContext getContext(Node viewDefnObject) {
        if (viewDefnObject instanceof IDOMNode) {
            IStructuredDocument sdoc = ((IDOMNode)viewDefnObject).getStructuredDocument();
            return IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)sdoc, viewDefnObject);
        }
        return null;
    }

    @Override
    public Node findViewDefn(ViewObject viewObject, ComponentInfo root) {
        return null;
    }

    @Override
    public abstract DTELExpression getELExpression(IModelContext var1) throws IDTViewHandler.ViewHandlerException;

    protected ViewObject createFromElement(Element element, ViewObjectConstructionStrategy<Element> constructionData, IDocument document) {
        ITagElement tagElement = this.findTagElement(element, document);
        return constructionData.createViewObject(element, tagElement);
    }

    public abstract String getNamespace(Element var1, IDocument var2);

    public abstract String getPrefix(String var1, IDocument var2);

    protected abstract ITagElement findTagElement(Element var1, IDocument var2);

    protected static ITagElement findTagElement(String nodeName, Namespace lib) {
        return lib.getViewElement(nodeName);
    }

    protected static Namespace getTaglib(Collection<? extends Namespace> namespaces, String uri) {
        for (Namespace namespace : namespaces) {
            if (!uri.equals(namespace.getNSUri())) continue;
            return namespace;
        }
        return null;
    }

    public String getGeneratedIdPrefix() {
        return GENERATED_ID;
    }

    public Attr mapAttributeToComponent(Element element, String componentAttrName) {
        return element.getAttributeNode(componentAttrName);
    }

    public static class DTELExpression
    extends ELExpression {
        private final IStructuredDocumentContext _documentContext;
        private final String _originalText;

        public DTELExpression(IStructuredDocumentContext doc, String text) {
            this._documentContext = doc;
            this._originalText = text;
        }

        public String getText() {
            return this._originalText;
        }

        public IStructuredDocumentContext getDocumentContext() {
            return this._documentContext;
        }
    }
}

