/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal;

import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryConfigurationHelper;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReference;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryReferenceServerSupplied;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal.JSFLibraryReferencePluginProvidedImpl;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal.JSFLibraryReferenceServerSuppliedImpl;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.internal.JSFLibraryReferenceUserSpecifiedImpl;

public class JSFLibraryReferenceFacadeFactory {
    public static JSFLibraryReference create(IClasspathEntry classpathEntry) {
        if (JSFLibraryConfigurationHelper.isJSFLibraryContainer(classpathEntry)) {
            return JSFLibraryReferenceFacadeFactory.createReference(classpathEntry);
        }
        return null;
    }

    public static JSFLibraryReferenceServerSupplied createServerSuppliedJSFLibRef() {
        return new JSFLibraryReferenceServerSuppliedImpl();
    }

    private static JSFLibraryReference createReference(IClasspathEntry classpathEntry) {
        String libID = classpathEntry.getPath().segment(1);
        JSFLibraryInternalReference libRef = JSFLibraryRegistryUtil.getInstance().getJSFLibraryReferencebyID(libID);
        if (libRef != null) {
            boolean isDeployed = JSFLibraryReferenceFacadeFactory.getJ2EEModuleDependency(classpathEntry);
            if (libRef.getLibrary() instanceof PluginProvidedJSFLibrary) {
                return new JSFLibraryReferencePluginProvidedImpl(libRef, isDeployed);
            }
            return new JSFLibraryReferenceUserSpecifiedImpl(libRef, isDeployed);
        }
        return null;
    }

    private static boolean getJ2EEModuleDependency(IClasspathEntry classpathEntry) {
        IClasspathAttribute[] attrs = classpathEntry.getExtraAttributes();
        int i = 0;
        while (i < attrs.length) {
            IClasspathAttribute attr = attrs[i];
            if (attr.getName().equals("org.eclipse.jst.component.dependency")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

