/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.json.jsonpath.IJSONPath;
import org.eclipse.json.jsonpath.JSONPath;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONModel;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONPair;
import org.eclipse.wst.json.core.document.IJSONValue;
import org.eclipse.wst.json.core.document.JSONException;
import org.eclipse.wst.json.core.internal.document.JSONArrayImpl;
import org.eclipse.wst.json.core.internal.document.JSONDocumentImpl;
import org.eclipse.wst.json.core.internal.document.JSONModelImpl;
import org.eclipse.wst.json.core.internal.document.JSONObjectImpl;
import org.eclipse.wst.json.core.internal.document.JSONPairImpl;
import org.eclipse.wst.json.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.AbstractNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.NamedNodeMap;

public abstract class JSONNodeImpl
extends AbstractNotifier
implements IJSONNode,
IAdaptable {
    private static final short DOCUMENT_POSITION_PRECEDING = 2;
    private static final short DOCUMENT_POSITION_FOLLOWING = 4;
    private static final short DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    private boolean fDataEditable = true;
    private IStructuredDocumentRegion flatNode = null;
    private JSONNodeImpl nextSibling = null;
    private JSONDocumentImpl ownerDocument = null;
    private JSONNodeImpl parentNode = null;
    private JSONNodeImpl previousSibling = null;
    static final String EMPTY_STRING = "";

    protected JSONNodeImpl() {
    }

    protected JSONNodeImpl(JSONNodeImpl that) {
        if (that != null) {
            this.ownerDocument = that.ownerDocument;
        }
    }

    public Object getAdapter(Class adapter) {
        IJSONModel model = this.getModel();
        return model != null ? Platform.getAdapterManager().getAdapter((Object)model, adapter) : null;
    }

    public boolean contains(int offset) {
        return offset >= this.getStartOffset() && offset < this.getEndOffset();
    }

    protected String createJSONExceptionMessage(short s, String tagName) {
        String result = null;
        result = this.lookupMessage(s) + " " + tagName;
        return result;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    protected String getCharValue(String name) {
        JSONDocumentImpl document = (JSONDocumentImpl)this.getOwnerDocument();
        if (document == null) {
            return null;
        }
        return document.getCharValue(name);
    }

    public IJSONDocument getContainerDocument() {
        IJSONNode parent = null;
        IJSONNode node = this;
        while (node != null) {
            if (node.getNodeType() == -1) {
                return (IJSONDocument)node;
            }
            parent = node.getParentNode();
            if (parent == node) break;
            node = parent;
        }
        return null;
    }

    public int getEndOffset() {
        IJSONNode node = this;
        block0: while (node != null) {
            JSONObjectImpl element;
            IStructuredDocumentRegion endStructuredDocumentRegion;
            if (node.getNodeType() == 0 && (endStructuredDocumentRegion = (element = (JSONObjectImpl)node).getEndStructuredDocumentRegion()) != null) {
                return endStructuredDocumentRegion.getEnd();
            }
            IJSONNode last = node.getLastChild();
            if (last != null) {
                node = last;
                continue;
            }
            IStructuredDocumentRegion lastStructuredDocumentRegion = ((JSONNodeImpl)node).getStructuredDocumentRegion();
            if (lastStructuredDocumentRegion != null) {
                return lastStructuredDocumentRegion.getEnd();
            }
            IJSONNode prev = node.getPreviousSibling();
            if (prev != null) {
                node = prev;
                continue;
            }
            IJSONNode parent = node.getParentNode();
            node = null;
            while (parent != null) {
                JSONObjectImpl element2;
                IStructuredDocumentRegion startStructuredDocumentRegion;
                if (parent.getNodeType() == 0 && (startStructuredDocumentRegion = (element2 = (JSONObjectImpl)parent).getStartStructuredDocumentRegion()) != null) {
                    return startStructuredDocumentRegion.getEnd();
                }
                IJSONNode parentPrev = parent.getPreviousSibling();
                if (parentPrev != null) {
                    node = parentPrev;
                    continue block0;
                }
                parent = parent.getParentNode();
            }
        }
        return 0;
    }

    @Override
    public IStructuredDocumentRegion getEndStructuredDocumentRegion() {
        return null;
    }

    public FactoryRegistry getFactoryRegistry() {
        FactoryRegistry reg;
        IJSONModel model = this.getModel();
        if (model != null && (reg = model.getFactoryRegistry()) != null) {
            return reg;
        }
        return null;
    }

    @Override
    public IJSONNode getFirstChild() {
        return null;
    }

    @Override
    public IStructuredDocumentRegion getFirstStructuredDocumentRegion() {
        return StructuredDocumentRegionUtil.getStructuredDocumentRegion(this.flatNode);
    }

    public int getIndex() {
        IJSONNode parent = this.getParentNode();
        if (parent == null) {
            return -1;
        }
        int index = 0;
        IJSONNode child = parent.getFirstChild();
        while (child != null) {
            if (child == this) {
                return index;
            }
            ++index;
            child = child.getNextSibling();
        }
        return -1;
    }

    @Override
    public IJSONNode getLastChild() {
        return null;
    }

    @Override
    public IStructuredDocumentRegion getLastStructuredDocumentRegion() {
        return StructuredDocumentRegionUtil.getStructuredDocumentRegion(this.flatNode);
    }

    public String getLocalName() {
        return null;
    }

    @Override
    public IJSONModel getModel() {
        if (this.ownerDocument == null) {
            return null;
        }
        return this.ownerDocument.getModel();
    }

    public ITextRegion getNameRegion() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    @Override
    public IJSONNode getNextSibling() {
        return this.nextSibling;
    }

    IJSONNode getNodeAt(int offset) {
        IJSONNode parent = this;
        IJSONNode child = this.getFirstChild();
        while (child != null) {
            IJSONValue value;
            if (child.getEndOffset() == offset) {
                return child;
            }
            if (child.getEndOffset() <= offset) {
                child = child.getNextSibling();
                continue;
            }
            if (child.getStartOffset() > offset) break;
            IStructuredDocumentRegion startStructuredDocumentRegion = child.getStartStructuredDocumentRegion();
            if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.getEnd() > offset) {
                return child;
            }
            parent = child;
            if (parent instanceof JSONPairImpl && ((value = ((JSONPairImpl)parent).getValue()) instanceof JSONObjectImpl || value instanceof JSONArrayImpl)) {
                parent = value;
            }
            child = parent.getFirstChild();
        }
        return parent;
    }

    @Override
    public IJSONDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public IJSONNode getParentNode() {
        return this.parentNode;
    }

    public String getPrefix() {
        return null;
    }

    @Override
    public IJSONNode getPreviousSibling() {
        return this.previousSibling;
    }

    public String getSource() {
        if (this.flatNode == null) {
            return EMPTY_STRING;
        }
        return this.flatNode.getText();
    }

    public int getStartOffset() {
        if (this.flatNode != null) {
            return this.flatNode.getStart();
        }
        JSONNodeImpl prev = (JSONNodeImpl)this.getPreviousSibling();
        if (prev != null) {
            return prev.getEndOffset();
        }
        IJSONNode parent = this.getParentNode();
        if (parent != null && parent.getNodeType() == 0) {
            JSONObjectImpl element = (JSONObjectImpl)parent;
            if (element.hasStartTag()) {
                return element.getStartEndOffset();
            }
            return element.getStartOffset();
        }
        JSONNodeImpl child = (JSONNodeImpl)this.getFirstChild();
        while (child != null) {
            IStructuredDocumentRegion childStructuredDocumentRegion = child.getStructuredDocumentRegion();
            if (childStructuredDocumentRegion != null) {
                return childStructuredDocumentRegion.getStart();
            }
            child = (JSONNodeImpl)child.getFirstChild();
        }
        return 0;
    }

    @Override
    public IStructuredDocumentRegion getStartStructuredDocumentRegion() {
        return this.getFirstStructuredDocumentRegion();
    }

    @Override
    public IStructuredDocument getStructuredDocument() {
        return this.getModel().getStructuredDocument();
    }

    IStructuredDocumentRegion getStructuredDocumentRegion() {
        return this.flatNode;
    }

    public ITextRegion getValueRegion() {
        return null;
    }

    public String getValueSource() throws JSONException {
        return this.getNodeValue();
    }

    public boolean hasAttributes() {
        return false;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    public boolean hasProperties() {
        return false;
    }

    @Override
    public IJSONNode insertBefore(IJSONNode newChild, IJSONNode refChild) throws JSONException {
        throw new JSONException();
    }

    public boolean isChildEditable() {
        return false;
    }

    public boolean isClosed() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isDataEditable() {
        JSONModelImpl model;
        if (!this.fDataEditable && (model = (JSONModelImpl)this.getModel()) != null && model.isReparsing()) {
            return true;
        }
        return this.fDataEditable;
    }

    private String lookupMessage(short s) {
        String result = null;
        result = EMPTY_STRING;
        return result;
    }

    protected void notifyValueChanged() {
        JSONDocumentImpl document = (JSONDocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        JSONModelImpl model = (JSONModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.valueChanged(this);
    }

    @Override
    public IJSONNode removeChild(IJSONNode oldChild) throws JSONException {
        throw new JSONException();
    }

    public void removeChildNodes() {
    }

    public IJSONNode replaceChild(IJSONNode newChild, IJSONNode oldChild) throws JSONException {
        return null;
    }

    void resetStructuredDocumentRegions() {
        JSONNodeImpl child = (JSONNodeImpl)this.getFirstChild();
        while (child != null) {
            child.resetStructuredDocumentRegions();
            child = (JSONNodeImpl)child.getNextSibling();
        }
        this.flatNode = null;
    }

    public void setChildEditable(boolean editable) {
    }

    protected void setNextSibling(IJSONNode nextSibling) {
        this.nextSibling = (JSONNodeImpl)nextSibling;
    }

    @Override
    public void setNodeValue(String nodeValue) {
    }

    protected void setOwnerDocument(IJSONDocument ownerDocument) {
        this.ownerDocument = (JSONDocumentImpl)ownerDocument;
    }

    protected void setOwnerDocument(IJSONDocument ownerDocument, boolean deep) {
        this.ownerDocument = (JSONDocumentImpl)ownerDocument;
        if (deep) {
            JSONNodeImpl child = (JSONNodeImpl)this.getFirstChild();
            while (child != null) {
                child.setOwnerDocument(ownerDocument, deep);
                child = (JSONNodeImpl)child.getNextSibling();
            }
        }
    }

    protected void setParentNode(IJSONNode parentNode) {
        this.parentNode = (JSONNodeImpl)parentNode;
    }

    protected void setPreviousSibling(IJSONNode previousSibling) {
        this.previousSibling = (JSONNodeImpl)previousSibling;
    }

    public void setSource(String source) {
    }

    void setStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        this.flatNode = flatNode;
    }

    public void setValueSource(String source) {
        this.setNodeValue(source);
    }

    public int getLength() {
        int end;
        int result = -1;
        int start = this.getStartOffset();
        if (start >= 0 && (end = this.getEndOffset()) >= 0 && (result = end - start) < -1) {
            result = -1;
        }
        return result;
    }

    @Override
    public IJSONPath getPath() {
        LinkedList<String> names = new LinkedList<String>();
        this.getNames(names, this);
        List copy = names.subList(0, names.size());
        Collections.reverse(copy);
        String[] segments = copy.toArray(new String[0]);
        return new JSONPath(segments);
    }

    private void getNames(List<String> names, IJSONNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof IJSONPair) {
            names.add(((IJSONPair)node).getName());
        }
        this.getNames(names, node.getParentOrPairNode());
    }
}

