/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.OrderBy;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaOrderBy;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.OrderColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.java.GenericJavaOrderColumn2_0;
import org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.OrderColumnAnnotationDefinition2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOrderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaSpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OrderColumnAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaOrderable
extends AbstractJavaContextModel<JavaAttributeMapping>
implements JavaOrderable2_0 {
    protected final JavaOrderable2_0.ParentAdapter parentAdapter;
    protected boolean noOrdering = false;
    protected boolean orderByOrdering = false;
    protected OrderBy orderBy;
    protected boolean orderColumnOrdering = false;
    protected JavaSpecifiedOrderColumn2_0 orderColumn;
    protected OrderColumnAnnotation2_0 nullOrderColumnAnnotation;

    public GenericJavaOrderable(JavaAttributeMapping parent) {
        this(new JavaOrderable2_0.ParentAdapter.Null(parent));
    }

    public GenericJavaOrderable(JavaOrderable2_0.ParentAdapter parentAdapter) {
        super((JavaAttributeMapping)parentAdapter.getOrderableParent());
        this.parentAdapter = parentAdapter;
        this.initNoOrdering();
        this.initOrderBy();
        this.initOrderColumn();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncNoOrdering();
        this.syncOrderBy(monitor);
        this.syncOrderColumn(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateOrderBy(monitor);
        this.updateOrderColumn(monitor);
    }

    @Override
    public boolean isNoOrdering() {
        return this.noOrdering;
    }

    @Override
    public void setNoOrdering() {
        this.removeOrderColumnAnnotation();
        this.removeOrderByAnnotation();
        this.setNoOrdering_(true);
        this.orderBy.setKey(null);
        this.setOrderByOrdering_(false);
        this.setOrderColumnOrdering_(false);
    }

    protected void setNoOrdering_(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    protected void initNoOrdering() {
        this.noOrdering = this.buildNoOrdering();
    }

    protected void syncNoOrdering() {
        this.setNoOrdering_(this.buildNoOrdering());
    }

    protected boolean buildNoOrdering() {
        return this.isJpa2_0Compatible() ? this.buildNoOrdering2_0() : this.buildNoOrdering1_0();
    }

    protected boolean buildNoOrdering2_0() {
        return this.getOrderByAnnotation() == null && this.getOrderColumnAnnotation() == null;
    }

    protected boolean buildNoOrdering1_0() {
        return this.getOrderByAnnotation() == null;
    }

    @Override
    public boolean isOrderByOrdering() {
        return this.orderByOrdering;
    }

    @Override
    public void setOrderByOrdering() {
        this.removeOrderColumnAnnotation();
        if (this.getOrderByAnnotation() == null) {
            this.addOrderByAnnotation();
        }
        this.setNoOrdering_(false);
        this.setOrderByOrdering_(true);
        this.setOrderColumnOrdering_(false);
    }

    protected void setOrderByOrdering_(boolean orderByOrdering) {
        boolean old = this.orderByOrdering;
        this.orderByOrdering = orderByOrdering;
        this.firePropertyChanged("orderByOrdering", old, orderByOrdering);
    }

    @Override
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    protected void initOrderBy() {
        this.orderByOrdering = this.buildOrderByOrdering();
        this.orderBy = this.buildOrderBy();
    }

    protected void syncOrderBy(IProgressMonitor monitor) {
        this.setOrderByOrdering_(this.buildOrderByOrdering());
        this.orderBy.synchronizeWithResourceModel(monitor);
    }

    protected void updateOrderBy(IProgressMonitor monitor) {
        this.orderBy.update(monitor);
    }

    protected boolean buildOrderByOrdering() {
        return this.isJpa2_0Compatible() ? this.buildOrderByOrdering2_0() : this.buildOrderByOrdering1_0();
    }

    protected boolean buildOrderByOrdering2_0() {
        return this.getOrderByAnnotation() != null && this.getOrderColumnAnnotation() == null;
    }

    protected boolean buildOrderByOrdering1_0() {
        return this.getOrderByAnnotation() != null;
    }

    protected OrderBy buildOrderBy() {
        return new GenericJavaOrderBy(this, new OrderByContext());
    }

    protected OrderByAnnotation getOrderByAnnotation() {
        return (OrderByAnnotation)this.getResourceAttribute().getAnnotation("javax.persistence.OrderBy");
    }

    protected OrderByAnnotation addOrderByAnnotation() {
        return (OrderByAnnotation)this.getResourceAttribute().addAnnotation("javax.persistence.OrderBy");
    }

    protected void removeOrderByAnnotation() {
        if (this.getResourceAttribute().getAnnotation("javax.persistence.OrderBy") != null) {
            this.getResourceAttribute().removeAnnotation("javax.persistence.OrderBy");
        }
    }

    @Override
    public boolean isOrderColumnOrdering() {
        return this.orderColumnOrdering;
    }

    @Override
    public void setOrderColumnOrdering() {
        this.removeOrderByAnnotation();
        if (this.getOrderColumnAnnotation() == null) {
            this.addOrderColumnAnnotation();
        }
        this.setNoOrdering_(false);
        this.setOrderByOrdering_(false);
        this.orderBy.setKey(null);
        this.setOrderColumnOrdering_(true);
    }

    protected void setOrderColumnOrdering_(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    @Override
    public JavaSpecifiedOrderColumn2_0 getOrderColumn() {
        return this.orderColumn;
    }

    protected void initOrderColumn() {
        this.orderColumnOrdering = this.buildOrderColumnOrdering();
        this.orderColumn = this.buildOrderColumn();
    }

    protected void syncOrderColumn(IProgressMonitor monitor) {
        this.setOrderColumnOrdering_(this.buildOrderColumnOrdering());
        this.orderColumn.synchronizeWithResourceModel(monitor);
    }

    protected void updateOrderColumn(IProgressMonitor monitor) {
        this.orderColumn.update(monitor);
    }

    protected boolean buildOrderColumnOrdering() {
        return this.isJpa2_0Compatible() ? this.getOrderColumnAnnotation() != null : false;
    }

    protected JavaSpecifiedOrderColumn2_0 buildOrderColumn() {
        OrderColumnParentAdapter columnParentAdapter = new OrderColumnParentAdapter();
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildJavaOrderColumn(columnParentAdapter) : new GenericJavaOrderColumn2_0(columnParentAdapter);
    }

    protected OrderColumnAnnotation2_0 getOrderColumnAnnotation() {
        return (OrderColumnAnnotation2_0)this.getResourceAttribute().getAnnotation("javax.persistence.OrderColumn");
    }

    protected OrderColumnAnnotation2_0 addOrderColumnAnnotation() {
        return (OrderColumnAnnotation2_0)this.getResourceAttribute().addAnnotation("javax.persistence.OrderColumn");
    }

    protected void removeOrderColumnAnnotation() {
        if (this.getResourceAttribute().getAnnotation("javax.persistence.OrderColumn") != null) {
            this.getResourceAttribute().removeAnnotation("javax.persistence.OrderColumn");
        }
    }

    public OrderColumnAnnotation2_0 getNonNullOrderColumnAnnotation() {
        return this.isJpa2_0Compatible() ? (OrderColumnAnnotation2_0)this.getResourceAttribute().getNonNullAnnotation("javax.persistence.OrderColumn") : this.getNullOrderColumnAnnotation();
    }

    protected OrderColumnAnnotation2_0 getNullOrderColumnAnnotation() {
        if (this.nullOrderColumnAnnotation == null) {
            this.nullOrderColumnAnnotation = this.buildNullOrderColumnAnnotation();
        }
        return this.nullOrderColumnAnnotation;
    }

    protected OrderColumnAnnotation2_0 buildNullOrderColumnAnnotation() {
        return (OrderColumnAnnotation2_0)OrderColumnAnnotationDefinition2_0.instance().buildNullAnnotation((JavaResourceAnnotatedElement)this.getResourceAttribute());
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return (JavaAttributeMapping)this.parent;
    }

    protected JavaSpecifiedPersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    @Override
    public JavaResourceAttribute getResourceAttribute() {
        return this.getPersistentAttribute().getResourceAttribute();
    }

    @Override
    public String getDefaultTableName() {
        return this.parentAdapter.getTableName();
    }

    protected Table resolveDbTable(String tableName) {
        return this.parentAdapter.resolveDbTable(tableName);
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return this.orderColumn.getCompletionProposals(pos);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getOrderByAnnotationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    protected TextRange getOrderByAnnotationTextRange() {
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation == null ? null : orderByAnnotation.getTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.getOrderColumnAnnotation() != null && this.getOrderByAnnotation() != null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage((JpaModel)this.getAttributeMapping(), this.getPersistentAttribute().getValidationTextRange(), JptJpaCoreValidationMessages.ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED, this.getPersistentAttribute().getName()));
            } else {
                messages.add(this.buildValidationMessage((JpaModel)this.getAttributeMapping(), this.getOrderByAnnotationTextRange(), JptJpaCoreValidationMessages.ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED, this.getPersistentAttribute().getName()));
            }
        }
        if (this.orderColumnOrdering) {
            this.orderColumn.validate(messages, reporter);
        }
    }

    protected class OrderByContext
    implements GenericJavaOrderBy.Context {
        protected OrderByContext() {
        }

        @Override
        public OrderByAnnotation getAnnotation(boolean addIfAbsent) {
            OrderByAnnotation annotation = GenericJavaOrderable.this.getOrderByAnnotation();
            if (annotation == null && addIfAbsent) {
                annotation = GenericJavaOrderable.this.addOrderByAnnotation();
            }
            return annotation;
        }
    }

    public class OrderColumnParentAdapter
    implements JavaSpecifiedOrderColumn2_0.ParentAdapter {
        @Override
        public JavaOrderable2_0 getColumnParent() {
            return GenericJavaOrderable.this;
        }

        @Override
        public String getDefaultTableName() {
            return GenericJavaOrderable.this.getDefaultTableName();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return GenericJavaOrderable.this.resolveDbTable(tableName);
        }

        @Override
        public String getDefaultColumnName(NamedColumn column) {
            return this.getPersistentAttribute().getName() + "_ORDER";
        }

        @Override
        public TextRange getValidationTextRange() {
            return GenericJavaOrderable.this.getValidationTextRange();
        }

        @Override
        public JpaValidator buildColumnValidator(NamedColumn column) {
            return new OrderColumnValidator((PersistentAttribute)this.getPersistentAttribute(), (SpecifiedOrderColumn2_0)column);
        }

        @Override
        public OrderColumnAnnotation2_0 getColumnAnnotation() {
            return GenericJavaOrderable.this.getNonNullOrderColumnAnnotation();
        }

        @Override
        public void removeColumnAnnotation() {
            GenericJavaOrderable.this.removeOrderColumnAnnotation();
        }

        protected JavaSpecifiedPersistentAttribute getPersistentAttribute() {
            return GenericJavaOrderable.this.getPersistentAttribute();
        }
    }
}

