/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CreateJavaProjectCommand
extends AbstractDataModelOperation {
    private String projectName_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName_);
        if (project != null && !project.exists()) {
            try {
                project.create(ResourcesPlugin.getWorkspace().newProjectDescription(project.getName()), monitor);
                project.open(monitor);
                IProjectDescription desc = project.getDescription();
                desc.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
                ICommand cmd = desc.newCommand();
                cmd.setBuilderName("org.eclipse.jdt.core.javabuilder");
                desc.setBuildSpec(new ICommand[]{cmd});
                project.setDescription(desc, monitor);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                Path projectRoot = new Path(Path.ROOT.append((IPath)new Path(project.getName())).toString());
                javaProject.setRawClasspath(new IClasspathEntry[]{JavaCore.newSourceEntry((IPath)projectRoot), JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER))}, monitor);
                javaProject.setOutputLocation((IPath)projectRoot, monitor);
            }
            catch (CoreException ce) {
                IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_CANNOT_CREATE_JAVA_PROJECT, (Object[])new String[]{this.projectName_}), (Throwable)ce);
                env.getStatusHandler().reportError(status);
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    public void setProjectName(String projectName) {
        this.projectName_ = projectName;
    }
}

