/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.util.AsyncFuture;

public class AsyncFutureMerger<T> {
    private final AtomicReference<AsyncFuture<List<T>>> futureRef;
    private AsyncFuture.Callback<List<T>> callback;
    private SyncCallback syncCallback;
    private final List<T> resultBuffer = new ArrayList<T>();
    private int subOperationCounter = 1;
    private int subOperationSyncCounter = 1;
    private RuntimeException savedException = null;
    private static final RelayOk SOMEONE_CARES_ABOUT_RELAY_OK = new RelayOk(){};

    public AsyncFutureMerger() {
        this.futureRef = new AtomicReference();
        AsyncFuture.initializeReference(this.futureRef, new AsyncFuture.Operation<List<T>>(){

            @Override
            public RelayOk start(AsyncFuture.Callback<List<T>> callback, SyncCallback syncCallback) {
                AsyncFutureMerger.this.callback = callback;
                AsyncFutureMerger.this.syncCallback = syncCallback;
                return SOMEONE_CARES_ABOUT_RELAY_OK;
            }
        });
    }

    public void addSubOperation() {
        assert (!this.futureRef.get().isDone());
        ++this.subOperationCounter;
        ++this.subOperationSyncCounter;
    }

    public void subOperationDone(T result) {
        this.resultBuffer.add(result);
        --this.subOperationCounter;
        if (this.subOperationCounter == 0) {
            this.callback.done(this.resultBuffer);
        }
    }

    public void subOperationDoneSync(RuntimeException exception) {
        if (exception != null && this.savedException == null) {
            this.savedException = exception;
        }
        --this.subOperationSyncCounter;
        if (this.subOperationSyncCounter == 0) {
            this.syncCallback.callbackDone(this.savedException);
        }
    }

    public AsyncFuture<List<T>> getFuture() {
        return this.futureRef.get();
    }
}

