/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class LineReader {
    private static final byte LF_BYTE = 10;
    private static final byte CR_BYTE = 13;
    private final InputStream inputStream;
    private final ByteBuffer buffer = ByteBuffer.allocate(1024);
    private ByteBuffer lineBuffer;

    LineReader(InputStream inputStream) {
        this.buffer.flip();
        this.lineBuffer = ByteBuffer.allocate(20);
        this.inputStream = inputStream;
    }

    public int read(byte[] cbuf, int off, int len) throws IOException {
        if (this.buffer.hasRemaining()) {
            len = Math.min(len, this.buffer.remaining());
            this.buffer.get(cbuf, off, len);
            return len;
        }
        return this.inputStream.read(cbuf, off, len);
    }

    public String readLine(Charset charset) throws IOException {
        this.lineBuffer.clear();
        while (true) {
            if (this.buffer.hasRemaining()) {
                boolean lineEndFound = false;
                int pos = this.buffer.position();
                while (pos < this.buffer.limit()) {
                    if (this.buffer.get(pos) == 10) {
                        lineEndFound = true;
                        break;
                    }
                    ++pos;
                }
                int chunkLen = pos - this.buffer.position();
                if (chunkLen > 0) {
                    if (this.lineBuffer.remaining() < chunkLen) {
                        int newSize = Math.max(this.lineBuffer.capacity() * 2, this.lineBuffer.position() + chunkLen);
                        ByteBuffer newLineBuffer = ByteBuffer.allocate(newSize);
                        this.lineBuffer.flip();
                        newLineBuffer.put(this.lineBuffer);
                        this.lineBuffer = newLineBuffer;
                    }
                    this.buffer.get(this.lineBuffer.array(), this.lineBuffer.position(), chunkLen);
                    this.lineBuffer.position(this.lineBuffer.position() + chunkLen);
                }
                if (lineEndFound) break;
            }
            assert (!this.buffer.hasRemaining());
            this.buffer.clear();
            int readRes = this.inputStream.read(this.buffer.array());
            if (readRes <= 0) {
                if (this.lineBuffer.position() == 0) {
                    return null;
                }
                throw new IOException("End of stream while expecting line end");
            }
            this.buffer.position(readRes);
            this.buffer.flip();
        }
        this.buffer.get();
        if (this.lineBuffer.position() > 0 && this.lineBuffer.get(this.lineBuffer.position() - 1) == 13) {
            this.lineBuffer.position(this.lineBuffer.position() - 1);
        }
        return new String(this.lineBuffer.array(), 0, this.lineBuffer.position(), charset);
    }
}

