/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckPathsBetweenNodes;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;

public final class CheckNullableReturn
implements HotSwapCompilerPass,
NodeTraversal.Callback {
    final AbstractCompiler compiler;
    public static final DiagnosticType NULLABLE_RETURN = DiagnosticType.warning("JSC_NULLABLE_RETURN", "This function''s return type is nullable, but it always returns a non-null value. Consider making the return type non-nullable.");
    public static final DiagnosticType NULLABLE_RETURN_WITH_NAME = DiagnosticType.warning("JSC_NULLABLE_RETURN_WITH_NAME", "The return type of the function \"{0}\" is nullable, but it always returns a non-null value. Consider making the return type non-nullable.");
    private static final Predicate<Node> NULLABLE_RETURN_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node input) {
            if (input == null || !input.isReturn()) {
                return false;
            }
            Node returnValue = input.getFirstChild();
            return returnValue != null && CheckNullableReturn.isNullable(returnValue);
        }
    };

    public CheckNullableReturn(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    public static boolean hasReturnDeclaredNullable(Node n) {
        return n.isBlock() && n.hasChildren() && CheckNullableReturn.isReturnTypeNullable(n.getParent()) && !CheckNullableReturn.hasSingleThrow(n);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (CheckNullableReturn.hasReturnDeclaredNullable(n) && !CheckNullableReturn.canReturnNull(t.getControlFlowGraph())) {
            String fnName = NodeUtil.getNearestFunctionName(parent);
            if (fnName != null && !fnName.isEmpty()) {
                this.compiler.report(t.makeError(parent, NULLABLE_RETURN_WITH_NAME, fnName));
            } else {
                this.compiler.report(t.makeError(parent, NULLABLE_RETURN, new String[0]));
            }
        }
    }

    private static boolean hasSingleThrow(Node blockNode) {
        return blockNode.getChildCount() == 1 && blockNode.getFirstChild().getType() == 49;
    }

    private static boolean isReturnTypeNullable(Node n) {
        if (n == null || !n.isFunction()) {
            return false;
        }
        FunctionType functionType = n.getJSType().toMaybeFunctionType();
        if (functionType == null) {
            return false;
        }
        JSType returnType = functionType.getReturnType();
        if (returnType == null || returnType.isUnknownType() || !returnType.isNullable()) {
            return false;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        return info != null && info.hasReturnType();
    }

    public static boolean canReturnNull(ControlFlowGraph<Node> graph) {
        CheckPathsBetweenNodes<Node, ControlFlowGraph.Branch> test = new CheckPathsBetweenNodes<Node, ControlFlowGraph.Branch>(graph, graph.getEntry(), graph.getImplicitReturn(), NULLABLE_RETURN_PREDICATE, Predicates.alwaysTrue());
        return test.somePathsSatisfyPredicate();
    }

    private static boolean isNullable(Node n) {
        return n.getJSType().isNullable() || n.isOr() && n.getLastChild().isNull();
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        return true;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, originalRoot, this);
    }
}

