/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.graph.LatticeElement;
import java.util.Iterator;
import java.util.List;

interface JoinOp<L extends LatticeElement>
extends Function<List<L>, L> {

    public static abstract class BinaryJoinOp<L extends LatticeElement>
    implements JoinOp<L> {
        public L apply(List<L> values) {
            Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0);
            int size = values.size();
            if (size == 1) {
                return (L)((LatticeElement)values.get(0));
            }
            if (size == 2) {
                return (L)this.apply((LatticeElement)values.get(0), (LatticeElement)values.get(1));
            }
            if (size <= 16) {
                int mid = BinaryJoinOp.computeMidPoint(size);
                return this.apply(this.apply(values.subList(0, mid)), this.apply(values.subList(mid, size)));
            }
            Iterator<L> iter = values.iterator();
            LatticeElement result = (LatticeElement)iter.next();
            while (iter.hasNext()) {
                result = this.apply(result, (LatticeElement)iter.next());
            }
            return (L)result;
        }

        abstract L apply(L var1, L var2);

        static int computeMidPoint(int size) {
            int midpoint = size >>> 1;
            if (size > 4) {
                midpoint &= 0xFFFFFFFE;
            }
            return midpoint;
        }
    }
}

