/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;
import org.eclipse.wst.dtd.ui.internal.properties.section.EntityTypeSection;

public class EntityValueSection
extends AbstractSection {
    private final String VALUE = DTDPropertiesMessages._UI_LABEL_ENTITY_VALUE;
    private final String PUBLIC_ID = DTDPropertiesMessages._UI_LABEL_PUBLIC_ID;
    private final String SYSTEM_ID = DTDPropertiesMessages._UI_LABEL_SYSTEM_ID;
    private Text valueText;
    private Text publicIdText;
    private Text systemIdText;
    private CLabel valueLabel;
    private CLabel publicIdLabel;
    private CLabel systemIdLabel;

    @Override
    public void doHandleEvent(Event event) {
        if (event.widget == this.valueText) {
            Object input = this.getInput();
            String newValue = this.valueText.getText();
            if (input instanceof Entity) {
                Entity entity = (Entity)input;
                entity.setValue(newValue);
            }
        } else if (event.widget == this.publicIdText) {
            Object input = this.getInput();
            String newValue = this.publicIdText.getText();
            if (input instanceof Entity) {
                Entity entity = (Entity)input;
                entity.setPublicID(newValue);
            }
        } else if (event.widget == this.systemIdText) {
            Object input = this.getInput();
            String newValue = this.systemIdText.getText();
            if (input instanceof Entity) {
                Entity entity = (Entity)input;
                entity.setSystemID(newValue);
            }
        }
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.valueLabel = this.getWidgetFactory().createCLabel(composite, this.VALUE);
        Point p = this.valueLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.valueLabel.setLayoutData((Object)data);
        this.valueText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)this.valueLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.valueLabel, 0, 0x1000000);
        this.valueText.setLayoutData((Object)data);
        this.valueText.addListener(24, (Listener)this);
        this.publicIdLabel = this.getWidgetFactory().createCLabel(composite, this.PUBLIC_ID);
        p = this.publicIdLabel.computeSize(-1, -1, false);
        labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.valueLabel, 4);
        this.publicIdLabel.setLayoutData((Object)data);
        this.publicIdText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)this.publicIdLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.publicIdLabel, 0, 0x1000000);
        this.publicIdText.setLayoutData((Object)data);
        this.publicIdText.addListener(24, (Listener)this);
        this.systemIdLabel = this.getWidgetFactory().createCLabel(composite, this.SYSTEM_ID);
        p = this.systemIdLabel.computeSize(-1, -1, false);
        labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.publicIdLabel, 4);
        this.systemIdLabel.setLayoutData((Object)data);
        this.systemIdText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)this.systemIdLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.systemIdLabel, 0, 0x1000000);
        this.systemIdText.setLayoutData((Object)data);
        this.systemIdText.addListener(24, (Listener)this);
    }

    @Override
    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        if (this.isExternalEntity()) {
            this.valueLabel.setVisible(false);
            this.valueText.setVisible(false);
            this.publicIdLabel.setVisible(true);
            this.publicIdText.setVisible(true);
            this.systemIdLabel.setVisible(true);
            this.systemIdText.setVisible(true);
            this.publicIdText.setText("");
            this.systemIdText.setText("");
            if (input != null && input instanceof Entity) {
                Entity entity = (Entity)input;
                this.publicIdText.setText(entity.getPublicID());
                this.systemIdText.setText(entity.getSystemID());
            }
        } else {
            this.valueLabel.setVisible(true);
            this.valueText.setVisible(true);
            this.publicIdLabel.setVisible(false);
            this.publicIdText.setVisible(false);
            this.systemIdLabel.setVisible(false);
            this.systemIdText.setVisible(false);
            this.valueText.setText("");
            if (input != null && input instanceof Entity) {
                this.valueText.setText(((Entity)input).getValue());
            }
        }
        this.setListenerEnabled(true);
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return false;
    }

    private boolean isExternalEntity() {
        return EntityTypeSection.isExternalEntity;
    }
}

