/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OverrideMethodDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTypeCompletionProposal;

public class AnonymousTypeCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private String fDeclarationSignature;
    private IType fSuperType;

    public AnonymousTypeCompletionProposal(IJavaScriptProject jproject, IJavaScriptUnit cu, int start, int length, String constructorCompletion, String displayName, String declarationSignature, int relevance) {
        super(constructorCompletion, cu, start, length, null, displayName, relevance);
        Assert.isNotNull((Object)declarationSignature);
        Assert.isNotNull((Object)jproject);
        Assert.isNotNull((Object)cu);
        this.fDeclarationSignature = declarationSignature;
        this.fSuperType = this.getDeclaringType(jproject, SignatureUtil.stripSignatureToFQN(String.valueOf(declarationSignature)));
        this.setImage(this.getImageForType(this.fSuperType));
        this.setCursorPosition(constructorCompletion.indexOf(40) + 1);
    }

    private int createDummy(String name, StringBuffer buffer) throws JavaScriptModelException {
        String lineDelim = "\n";
        buffer.append("class ");
        buffer.append(name);
        buffer.append(" extends ");
        if (this.fDeclarationSignature != null) {
            buffer.append(Signature.toString((String)this.fDeclarationSignature));
        } else {
            buffer.append(this.fSuperType.getFullyQualifiedParameterizedName());
        }
        int start = buffer.length();
        buffer.append("{");
        buffer.append(lineDelim);
        buffer.append(lineDelim);
        buffer.append("}");
        return start;
    }

    private boolean createStubs(StringBuffer buffer, ImportRewrite importRewrite) throws CoreException {
        if (importRewrite == null) {
            return false;
        }
        if (this.fSuperType == null) {
            return true;
        }
        IJavaScriptUnit copy = null;
        try {
            String name = "Type" + System.currentTimeMillis();
            copy = this.fCompilationUnit.getPrimary().getWorkingCopy(null);
            StringBuffer contents = new StringBuffer();
            int start = 0;
            int end = 0;
            ISourceRange range = this.fSuperType.getSourceRange();
            boolean sameUnit = range != null && this.fCompilationUnit.equals(this.fSuperType.getJavaScriptUnit());
            StringBuffer dummy = new StringBuffer();
            int length = this.createDummy(name, dummy);
            contents.append(this.fCompilationUnit.getBuffer().getContents());
            if (sameUnit) {
                int size = range.getOffset() + range.getLength();
                start = size + length;
                end = contents.length() - size;
                contents.insert(size, dummy.toString());
            } else {
                range = this.fCompilationUnit.getTypes()[0].getSourceRange();
                start = range.getOffset() + length;
                end = contents.length() - range.getOffset();
                contents.insert(range.getOffset(), dummy.toString());
            }
            copy.getBuffer().setContents(contents.toString());
            JavaModelUtil.reconcile(copy);
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setSource(copy);
            JavaScriptUnit unit = (JavaScriptUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            IType type = null;
            IType[] types = copy.getAllTypes();
            int index = 0;
            while (index < types.length) {
                IType result = types[index];
                if (result.getElementName().equals(name)) {
                    type = result;
                    break;
                }
                ++index;
            }
            if (type != null && type.exists()) {
                ITypeBinding binding = null;
                AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(NodeFinder.perform((ASTNode)unit, type.getNameRange()), AbstractTypeDeclaration.class);
                if (declaration != null && (binding = declaration.resolveBinding()) != null) {
                    Object[] selection;
                    IFunctionBinding[] bindings = StubUtility2.getOverridableMethods(unit.getAST(), binding, true);
                    CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.fSuperType.getJavaScriptProject());
                    String[] keys = null;
                    OverrideMethodDialog dialog = new OverrideMethodDialog(JavaScriptPlugin.getActiveWorkbenchShell(), null, type, true);
                    dialog.setGenerateComment(false);
                    dialog.setElementPositionEnabled(false);
                    if (dialog.open() == 0 && (selection = dialog.getResult()) != null) {
                        ArrayList<String> result = new ArrayList<String>(selection.length);
                        int index2 = 0;
                        while (index2 < selection.length) {
                            if (selection[index2] instanceof IFunctionBinding) {
                                result.add(((IBinding)selection[index2]).getKey());
                            }
                            ++index2;
                        }
                        keys = result.toArray(new String[result.size()]);
                        settings.createComments = dialog.getGenerateComment();
                    }
                    if (keys == null) {
                        this.setReplacementString("");
                        this.setReplacementLength(0);
                        return false;
                    }
                    ASTRewrite rewrite = ASTRewrite.create((AST)unit.getAST());
                    ListRewrite rewriter = rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
                    String key = null;
                    FunctionDeclaration stub = null;
                    int index3 = 0;
                    while (index3 < keys.length) {
                        key = keys[index3];
                        int offset = 0;
                        while (offset < bindings.length) {
                            if (key.equals(bindings[offset].getKey())) {
                                stub = StubUtility2.createImplementationStub(copy, rewrite, importRewrite, bindings[offset], binding.getName(), false, settings);
                                if (stub == null) break;
                                rewriter.insertFirst((ASTNode)stub, null);
                                break;
                            }
                            ++offset;
                        }
                        ++index3;
                    }
                    Document document = new Document(copy.getBuffer().getContents());
                    try {
                        rewrite.rewriteAST((IDocument)document, this.fCompilationUnit.getJavaScriptProject().getOptions(true)).apply((IDocument)document, 2);
                        buffer.append(document.get(start, document.getLength() - start - end));
                    }
                    catch (MalformedTreeException exception) {
                        JavaScriptPlugin.log(exception);
                    }
                    catch (BadLocationException exception) {
                        JavaScriptPlugin.log(exception);
                    }
                }
            }
            return true;
        }
        finally {
            if (copy != null) {
                copy.discardWorkingCopy();
            }
        }
    }

    private IType getDeclaringType(IJavaScriptProject project, String typeName) {
        try {
            return project.findType(typeName, null);
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            return null;
        }
    }

    private Image getImageForType(IType type) {
        String imageName = "org.eclipse.wst.jsdt.ui.class_obj.gif";
        return JavaPluginImages.get(imageName);
    }

    public boolean isAutoInsertable() {
        return false;
    }

    @Override
    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        String replacementString = this.getReplacementString();
        StringBuffer buf = new StringBuffer("new A(");
        buf.append(replacementString);
        if (!replacementString.endsWith(")")) {
            buf.append(')');
        }
        if (!this.createStubs(buf, impRewrite)) {
            return false;
        }
        if (document.getChar(offset) != ')') {
            buf.append(';');
        }
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IJavaScriptProject project = this.fCompilationUnit.getJavaScriptProject();
        IRegion region = document.getLineInformationOfOffset(this.getReplacementOffset());
        int indent = Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), project);
        String replacement = CodeFormatterUtil.format(1, buf.toString(), 0, null, lineDelim, project);
        replacement = Strings.changeIndent(replacement, 0, project, CodeFormatterUtil.createIndentString(indent, project), lineDelim);
        this.setReplacementString(replacement.substring(replacement.indexOf(40) + 1));
        int pos = offset;
        while (pos < document.getLength() && Character.isWhitespace(document.getChar(pos))) {
            ++pos;
        }
        if (pos < document.getLength() && document.getChar(pos) == ')') {
            this.setReplacementLength(pos - offset + 1);
        }
        return true;
    }
}

