/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.ProjectLibraryRoot;

public class JavaNavigatorLabelProvider
implements ICommonLabelProvider {
    private final long LABEL_FLAGS = 13196440454323L;
    private PackageExplorerLabelProvider delegeteLabelProvider;
    private PackageExplorerContentProvider fContentProvider;
    private IExtensionStateModel fStateModel;
    private IPropertyChangeListener fLayoutPropertyListener;

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        this.fStateModel = commonContentExtensionSite.getExtensionStateModel();
        this.fContentProvider = (PackageExplorerContentProvider)commonContentExtensionSite.getExtension().getContentProvider();
        this.delegeteLabelProvider = this.createLabelProvider();
        this.delegeteLabelProvider.setIsFlatLayout(this.fStateModel.getBooleanProperty("isLayoutFlat"));
        this.fLayoutPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("isLayoutFlat".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue() != false;
                    JavaNavigatorLabelProvider.this.delegeteLabelProvider.setIsFlatLayout(newValue);
                }
            }
        };
        this.fStateModel.addPropertyChangeListener(this.fLayoutPropertyListener);
    }

    public String getDescription(Object element) {
        return this.formatMessage(element);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        return new PackageExplorerLabelProvider(this.fContentProvider);
    }

    public void dispose() {
        this.delegeteLabelProvider.dispose();
        this.fStateModel.removePropertyChangeListener(this.fLayoutPropertyListener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.delegeteLabelProvider.propertyChange(event);
    }

    public void addLabelDecorator(ILabelDecorator decorator) {
        this.delegeteLabelProvider.addLabelDecorator(decorator);
    }

    public void addListener(ILabelProviderListener listener) {
        this.delegeteLabelProvider.addListener(listener);
    }

    public Color getBackground(Object element) {
        return this.delegeteLabelProvider.getBackground(element);
    }

    public Color getForeground(Object element) {
        return this.delegeteLabelProvider.getForeground(element);
    }

    public Image getImage(Object element) {
        return this.delegeteLabelProvider.getImage(element);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.delegeteLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.delegeteLabelProvider.removeListener(listener);
    }

    public boolean equals(Object obj) {
        return this.delegeteLabelProvider.equals(obj);
    }

    public int hashCode() {
        return this.delegeteLabelProvider.hashCode();
    }

    public String toString() {
        return this.delegeteLabelProvider.toString();
    }

    public String getText(Object element) {
        return this.delegeteLabelProvider.getText(element);
    }

    public void setIsFlatLayout(boolean state) {
        this.delegeteLabelProvider.setIsFlatLayout(state);
    }

    private String formatMessage(Object element) {
        IWorkbenchAdapter adapter;
        if (element instanceof IJavaScriptElement) {
            return this.formatJavaElementMessage((IJavaScriptElement)element);
        }
        if (element instanceof IResource) {
            return this.formatResourceMessage((IResource)element);
        }
        if (element instanceof PackageFragmentRootContainer) {
            return this.formatPackageFragmentRootContainerMessage((PackageFragmentRootContainer)element);
        }
        if (element instanceof ProjectLibraryRoot) {
            return this.formatProjectLibraryRootMessage((ProjectLibraryRoot)element);
        }
        if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            return adapter.getLabel(element);
        }
        return "";
    }

    private String formatProjectLibraryRootMessage(ProjectLibraryRoot element) {
        return String.valueOf(element.getText()) + JavaScriptElementLabels.CONCAT_STRING + this.formatJavaElementMessage((IJavaScriptElement)element.getProject());
    }

    private String formatPackageFragmentRootContainerMessage(PackageFragmentRootContainer element) {
        return String.valueOf(element.getLabel()) + JavaScriptElementLabels.CONCAT_STRING + this.formatJavaElementMessage((IJavaScriptElement)element.getJavaProject());
    }

    private String formatJavaElementMessage(IJavaScriptElement element) {
        return JavaScriptElementLabels.getElementLabel(element, 13196440454323L);
    }

    private String formatResourceMessage(IResource element) {
        IContainer parent = element.getParent();
        if (parent != null && parent.getType() != 8) {
            return String.valueOf(element.getName()) + JavaScriptElementLabels.CONCAT_STRING + parent.getFullPath().makeRelative().toString();
        }
        return element.getName();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }
}

