/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.util.TypeUtil;

public class JDTBeanProperty {
    private final IType type;
    private final String typeSignature;
    private final List<String> typeParameterSignatures;
    private final IMethod getter;
    private final IMethod setter;
    private final String propertyName;

    JDTBeanProperty(String propertyName, IType type, String typeSignature, List<String> typeParameterSignatures, IMethod getter, IMethod setter) {
        this.propertyName = propertyName;
        this.type = type;
        this.typeSignature = typeSignature;
        this.typeParameterSignatures = typeParameterSignatures;
        this.getter = getter;
        this.setter = setter;
    }

    public boolean isReadable() {
        return this.getter != null;
    }

    public boolean isWritable() {
        return this.setter != null;
    }

    public IMethod getGetter() {
        return this.getter;
    }

    public IMethod getSetter() {
        return this.setter;
    }

    public IType getType() {
        return this.type;
    }

    public int getArrayCount() {
        String sig = this.getTypeSignature();
        if (sig == null) {
            return 0;
        }
        return Signature.getArrayCount((String)sig);
    }

    public boolean isEnumType() {
        return TypeUtil.isEnumType(this.getType());
    }

    public String getTypeSignature() {
        return this.typeSignature;
    }

    public List<String> getTypeParameterSignatures() {
        return this.typeParameterSignatures;
    }

    public String toString() {
        return "JDTBeanProperty [name=" + this.propertyName + " typeSignature=" + this.typeSignature + " typeParameterSignatures " + String.valueOf(this.typeParameterSignatures) + "]";
    }
}

