/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jst.jsf.common.internal.policy.IIteratorPolicy;

public class IdentifierOrderedIteratorPolicy<ITERATORTYPE>
implements IIteratorPolicy<ITERATORTYPE> {
    private final Iterable<ITERATORTYPE> _policyOrder;
    private volatile boolean _excludeNonExplicitValues = false;

    public IdentifierOrderedIteratorPolicy(Iterable<ITERATORTYPE> policyOrder) {
        this._policyOrder = policyOrder;
    }

    public boolean isExcludeNonExplicitValues() {
        return this._excludeNonExplicitValues;
    }

    public void setExcludeNonExplicitValues(boolean excludeNonExplicitValues) {
        this._excludeNonExplicitValues = excludeNonExplicitValues;
    }

    @Override
    public Iterator<ITERATORTYPE> getIterator(Collection<ITERATORTYPE> forCollection) {
        boolean excludeNonExplicitValues = this._excludeNonExplicitValues;
        return new MyIterator<ITERATORTYPE>(forCollection, excludeNonExplicitValues, this._policyOrder);
    }

    private static class MyIterator<ITERATORTYPE>
    implements Iterator<ITERATORTYPE> {
        private final List<ITERATORTYPE> _items = new ArrayList<ITERATORTYPE>();
        private final Iterator<ITERATORTYPE> _policyIterator;
        private ITERATORTYPE _next;

        MyIterator(Collection<ITERATORTYPE> collection, boolean excludeNonExplicitValues, Iterable<ITERATORTYPE> policyOrder) {
            this._items.addAll(collection);
            this._policyIterator = policyOrder.iterator();
            this._next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public ITERATORTYPE next() {
            if (this._next != null) {
                ITERATORTYPE next = this._next;
                this._next = this.findNext();
                return next;
            }
            throw new NoSuchElementException("No more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private ITERATORTYPE findNext() {
            while (this._policyIterator.hasNext()) {
                ITERATORTYPE next = this._policyIterator.next();
                if (!this._items.contains(next)) continue;
                this._items.remove(next);
                return next;
            }
            if (this._items.size() > 0) {
                return this._items.remove(0);
            }
            return null;
        }
    }
}

