/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.ui.internal.swt.AbstractComboModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.model.Displayable;
import org.eclipse.jpt.common.utility.tests.internal.model.SimpleDisplayable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractComboModelAdapterTest {
    private Model model;
    private ModifiablePropertyValueModel<SimpleDisplayable> selectedItemHolder;
    private Shell shell;
    private ModifiablePropertyValueModel<Model> subjectHolder;

    protected abstract AbstractComboModelAdapter<SimpleDisplayable> buildEditableComboModelAdapter();

    protected final ListValueModel<SimpleDisplayable> buildEmptyListHolder() {
        return new SimpleListValueModel();
    }

    private List<SimpleDisplayable> buildList() {
        ArrayList<SimpleDisplayable> list = new ArrayList<SimpleDisplayable>();
        this.populateCollection(list);
        return list;
    }

    protected final ListValueModel<SimpleDisplayable> buildListHolder() {
        return new ListAspectAdapter<Model, SimpleDisplayable>(this.subjectHolder, new String[]{"items"}){

            protected ListIterator<SimpleDisplayable> listIterator_() {
                return ((Model)((Object)this.subject)).items();
            }

            protected int size_() {
                return ((Model)((Object)this.subject)).itemsSize();
            }
        };
    }

    protected abstract AbstractComboModelAdapter<SimpleDisplayable> buildReadOnlyComboModelAdapter();

    private SimpleDisplayable buildSelectedItem() {
        return new SimpleDisplayable((Object)"baz");
    }

    private ModifiablePropertyValueModel<SimpleDisplayable> buildSelectedItemHolder() {
        return new PropertyAspectAdapter<Model, SimpleDisplayable>(this.subjectHolder, new String[]{"item"}){

            protected SimpleDisplayable buildValue_() {
                return ((Model)((Object)this.subject)).getItem();
            }

            protected void setValue_(SimpleDisplayable value) {
                ((Model)((Object)this.subject)).setItem(value);
            }
        };
    }

    protected final Transformer<SimpleDisplayable, String> buildStringConverter() {
        return TransformerTools.nullCheck((Transformer)Displayable.DISPLAY_STRING_TRANSFORMER, (Object)"");
    }

    private ModifiablePropertyValueModel<Model> buildSubjectHolder() {
        return new SimplePropertyValueModel();
    }

    public abstract String comboSelectedItem();

    protected abstract boolean emptyComboCanHaveSelectedValue();

    protected abstract String itemAt(int var1);

    protected abstract int itemCounts();

    private void populateCollection(Collection<SimpleDisplayable> c) {
        c.add(new SimpleDisplayable((Object)"foo"));
        c.add(new SimpleDisplayable((Object)"bar"));
        c.add(new SimpleDisplayable((Object)"baz"));
        c.add(new SimpleDisplayable((Object)"joo"));
        c.add(new SimpleDisplayable((Object)"jar"));
        c.add(new SimpleDisplayable((Object)"jaz"));
    }

    protected final ModifiablePropertyValueModel<SimpleDisplayable> selectedItemHolder() {
        return this.selectedItemHolder;
    }

    @Before
    public void setUp() throws Exception {
        this.shell = new Shell(Display.getCurrent());
        this.model = new Model();
        this.subjectHolder = this.buildSubjectHolder();
        this.selectedItemHolder = this.buildSelectedItemHolder();
    }

    protected final Shell shell() {
        return this.shell;
    }

    protected final ModifiablePropertyValueModel<Model> subjectHolder() {
        return this.subjectHolder;
    }

    @After
    public void tearDown() throws Exception {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.shell = null;
        this.subjectHolder = null;
        this.selectedItemHolder = null;
    }

    private void testItems() {
        Assert.assertEquals((String)"The count of items is not in sync with the model", (long)this.model.itemsSize(), (long)this.itemCounts());
        int index = 0;
        while (index < this.model.itemsSize()) {
            Assert.assertEquals((String)("The item at index " + index + " is not the same between the model and the combo"), (Object)this.model.itemAt(index).displayString(), (Object)this.itemAt(index));
            ++index;
        }
    }

    @Test
    public void testNonNullSubjectAfter_AddedAfter_ReadOnly() throws Exception {
        this.buildReadOnlyComboModelAdapter();
        this.testRemoveItems_AddedAfter();
    }

    @Test
    public void testNonNullSubjectAfter_AddedAfter_RemoveItems_Editable() throws Exception {
        this.buildEditableComboModelAdapter();
        this.testRemoveItems_AddedAfter();
    }

    @Test
    public void testNonNullSubjectAfter_AddedBefore_RemoveItems_Editable() throws Exception {
        this.subjectHolder.setValue((Object)this.model);
        this.model.addItems(this.buildList());
        this.buildEditableComboModelAdapter();
        this.testSelectedItem(null);
        this.testItems();
        ArrayList<SimpleDisplayable> items = new ArrayList<SimpleDisplayable>();
        items.add(this.model.itemAt(0));
        items.add(this.model.itemAt(3));
        this.model.removeItems(items.iterator());
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_AddedBefore_RemoveItems_ReadOnly() throws Exception {
        this.subjectHolder.setValue((Object)this.model);
        this.model.addItems(this.buildList());
        this.buildReadOnlyComboModelAdapter();
        this.testSelectedItem(null);
        this.testItems();
        ArrayList<SimpleDisplayable> items = new ArrayList<SimpleDisplayable>();
        items.add(this.model.itemAt(0));
        items.add(this.model.itemAt(3));
        this.model.removeItems(items.iterator());
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_NullSelectedItem_ItemsAfterAfter_Editable() throws Exception {
        this.buildEditableComboModelAdapter();
        this.subjectHolder.setValue((Object)this.model);
        this.model.addItems(this.buildList());
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_NullSelectedItem_ItemsAfterAfter_ReadOnly() throws Exception {
        this.buildReadOnlyComboModelAdapter();
        this.subjectHolder.setValue((Object)this.model);
        this.model.addItems(this.buildList());
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_NullSelectedItem_ItemsAfterBefore_Editable() throws Exception {
        this.buildEditableComboModelAdapter();
        this.model.addItems(this.buildList());
        this.subjectHolder.setValue((Object)this.model);
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_NullSelectedItem_ItemsAfterBefore_ReadOnly() throws Exception {
        this.buildReadOnlyComboModelAdapter();
        this.model.addItems(this.buildList());
        this.subjectHolder.setValue((Object)this.model);
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_NullSelectedItem_ItemsBefore_Editable() throws Exception {
        this.model.addItems(this.buildList());
        this.buildEditableComboModelAdapter();
        this.subjectHolder.setValue((Object)this.model);
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_NullSelectedItem_ItemsBefore_ReadOnly() throws Exception {
        this.model.addItems(this.buildList());
        this.buildReadOnlyComboModelAdapter();
        this.subjectHolder.setValue((Object)this.model);
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_NullSelectedItem_NoItems_Editable() throws Exception {
        this.buildEditableComboModelAdapter();
        this.subjectHolder.setValue((Object)this.model);
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_NullSelectedItem_NoItems_ReadOnly() throws Exception {
        this.buildReadOnlyComboModelAdapter();
        this.subjectHolder.setValue((Object)this.model);
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectAfter_SelectedItemChanged_ReadOnly() throws Exception {
        this.subjectHolder.setValue((Object)this.model);
        this.model.addItems(this.buildList());
        SimpleDisplayable selectedItem = this.model.itemAt(0);
        AbstractComboModelAdapter<SimpleDisplayable> adapter = this.buildEditableComboModelAdapter();
        SelectionListener selectionListener = new SelectionListener();
        adapter.addSelectionChangeListener((AbstractComboModelAdapter.SelectionChangeListener)selectionListener);
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.testSelectedItem(null);
        this.testSelectedItemChanged(selectedItem, selectionListener);
    }

    @Test
    public void testNonNullSubjectBefore_NonNullSelectedItemAfter_Editable() throws Exception {
        SimpleDisplayable selectedItem = this.buildSelectedItem();
        this.subjectHolder.setValue((Object)this.model);
        this.buildEditableComboModelAdapter();
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        this.testSelectedItem(selectedItem);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NonNullSelectedItemAfter_Items_Editable() throws Exception {
        SimpleDisplayable selectedItem = this.buildSelectedItem();
        this.subjectHolder.setValue((Object)this.model);
        this.buildEditableComboModelAdapter();
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        this.testSelectedItem(selectedItem);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NonNullSelectedItemAfter_Items_ReadOnly() throws Exception {
        List<SimpleDisplayable> list = this.buildList();
        SimpleDisplayable selectedItem = list.get(0);
        this.subjectHolder.setValue((Object)this.model);
        this.buildReadOnlyComboModelAdapter();
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        this.testSelectedItem(selectedItem);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NonNullSelectedItemAfter_ReadOnly() throws Exception {
        List<SimpleDisplayable> list = this.buildList();
        SimpleDisplayable selectedItem = list.get(0);
        this.subjectHolder.setValue((Object)this.model);
        this.buildReadOnlyComboModelAdapter();
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        this.testSelectedItem(selectedItem);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NonNullSelectedItemBefore_Editable() throws Exception {
        this.model.addItems(this.buildList());
        SimpleDisplayable selectedItem = this.model.itemAt(0);
        this.subjectHolder.setValue((Object)this.model);
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        this.model.clearItemCalledFlag();
        this.buildEditableComboModelAdapter();
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.testSelectedItem(selectedItem);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NonNullSelectedItemBefore_Items_Editable() throws Exception {
        this.model.addItems(this.buildList());
        SimpleDisplayable selectedItem = this.model.itemAt(0);
        this.subjectHolder.setValue((Object)this.model);
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        this.model.clearItemCalledFlag();
        this.buildEditableComboModelAdapter();
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.testSelectedItem(selectedItem);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NonNullSelectedItemBefore_Items_ReadOnly() throws Exception {
        List<SimpleDisplayable> list = this.buildList();
        SimpleDisplayable selectedItem = list.get(0);
        this.subjectHolder.setValue((Object)this.model);
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        this.model.clearItemCalledFlag();
        this.buildReadOnlyComboModelAdapter();
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.testSelectedItem(selectedItem);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NonNullSelectedItemBefore_ReadOnly() throws Exception {
        List<SimpleDisplayable> list = this.buildList();
        SimpleDisplayable selectedItem = list.get(0);
        this.subjectHolder.setValue((Object)this.model);
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        this.model.clearItemCalledFlag();
        this.buildReadOnlyComboModelAdapter();
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.testSelectedItem(selectedItem);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NullSelectedItem_Items_Editable() throws Exception {
        this.subjectHolder.setValue((Object)this.model);
        this.buildEditableComboModelAdapter();
        Assert.assertFalse((String)"The item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertNull((String)"The selected item is supposed to remain null", (Object)this.model.getItem());
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NullSelectedItem_Items_ReadOnly() throws Exception {
        this.subjectHolder.setValue((Object)this.model);
        this.buildEditableComboModelAdapter();
        Assert.assertFalse((String)"The item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertNull((String)"The selected item is supposed to remain null", (Object)this.model.getItem());
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NullSelectedItem_NoItems_Editable() throws Exception {
        this.subjectHolder.setValue((Object)this.model);
        this.buildEditableComboModelAdapter();
        Assert.assertFalse((String)"The item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertNull((String)"The selected item is supposed to remain null", (Object)this.model.getItem());
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_NullSelectedItem_NoItems_ReadOnly() throws Exception {
        this.subjectHolder.setValue((Object)this.model);
        this.buildEditableComboModelAdapter();
        Assert.assertFalse((String)"The item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertNull((String)"The selected item is supposed to remain null", (Object)this.model.getItem());
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNonNullSubjectBefore_SelectedItemChanged_Editable() throws Exception {
        this.model.addItems(this.buildList());
        SimpleDisplayable selectedItem = this.model.itemAt(3);
        this.subjectHolder.setValue((Object)this.model);
        AbstractComboModelAdapter<SimpleDisplayable> adapter = this.buildEditableComboModelAdapter();
        SelectionListener selectionListener = new SelectionListener();
        adapter.addSelectionChangeListener((AbstractComboModelAdapter.SelectionChangeListener)selectionListener);
        Assert.assertFalse((String)"The selected item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.testSelectedItem(null);
        this.testSelectedItemChanged(selectedItem, selectionListener);
    }

    private void testNullSubject() throws Exception {
        Assert.assertNull((String)"The selected item should be null", (Object)this.selectedItemHolder.getValue());
        this.selectedItemHolder.setValue((Object)this.buildSelectedItem());
        Assert.assertFalse((String)"The item wasn't supposed to be modified", (boolean)this.model.isSetItemCalled());
        this.testSelectedItem(null);
        this.testItems();
    }

    @Test
    public void testNullSubject_NullSelectedItem_Items_Editable() throws Exception {
        this.buildEditableComboModelAdapter();
        this.testNullSubject();
        this.testItems();
        this.testSelectedItem(null);
    }

    @Test
    public void testNullSubject_NullSelectedItem_Items_ReadOnly() throws Exception {
        this.buildReadOnlyComboModelAdapter();
        this.testNullSubject();
        this.testItems();
        this.testSelectedItem(null);
    }

    @Test
    public void testNullSubject_NullSelectedItem_NoItems_Editable() throws Exception {
        this.buildEditableComboModelAdapter();
        this.testNullSubject();
        this.testItems();
        this.testSelectedItem(null);
    }

    @Test
    public void testNullSubject_NullSelectedItem_NoItems_ReadOnly() throws Exception {
        this.buildReadOnlyComboModelAdapter();
        this.testNullSubject();
        this.testItems();
        this.testSelectedItem(null);
    }

    private void testRemoveItems_AddedAfter() {
        this.subjectHolder.setValue((Object)this.model);
        this.model.addItems(this.buildList());
        this.testSelectedItem(null);
        this.testItems();
        this.testSelectedItem(null);
        ArrayList<SimpleDisplayable> items = new ArrayList<SimpleDisplayable>();
        items.add(this.model.itemAt(0));
        items.add(this.model.itemAt(3));
        this.model.removeItems(items.iterator());
        this.testItems();
        this.testSelectedItem(null);
    }

    private void testSelectedItem(SimpleDisplayable selectedItem) {
        if (selectedItem == null) {
            Assert.assertNull((String)"The selected item is supposed to be null", (Object)this.model.getItem());
            Assert.assertEquals((String)"The combo's selected item should be null", (Object)"", (Object)this.comboSelectedItem());
        } else if (!this.emptyComboCanHaveSelectedValue()) {
            Assert.assertEquals((String)"The selected item wasn't set correctly", (Object)selectedItem, (Object)this.model.getItem());
            Assert.assertEquals((String)"The combo's selected item should be null", (Object)"", (Object)this.comboSelectedItem());
        } else {
            Assert.assertEquals((String)"The selected item wasn't set correctly", (Object)selectedItem, (Object)this.model.getItem());
            Assert.assertEquals((String)"The selected item wasn't set correctly", (Object)selectedItem.displayString(), (Object)this.comboSelectedItem());
        }
    }

    private void testSelectedItemChanged(SimpleDisplayable selectedItem, SelectionListener selectionListener) {
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        Assert.assertTrue((String)"The SelectionListener was supposed to be notified", (boolean)selectionListener.isListenerNotified());
        Assert.assertSame((String)"The SelectionListener was supposed to be notified", (Object)selectedItem, (Object)selectionListener.getItem());
        this.testSelectedItem(selectedItem);
        selectedItem = this.model.itemAt(1);
        this.model.clearItemCalledFlag();
        selectionListener.clearInfo();
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        Assert.assertTrue((String)"The SelectionListener was supposed to be notified", (boolean)selectionListener.isListenerNotified());
        Assert.assertSame((String)"The SelectionListener was supposed to be notified", (Object)selectedItem, (Object)selectionListener.getItem());
        this.testSelectedItem(selectedItem);
        selectedItem = null;
        this.model.clearItemCalledFlag();
        selectionListener.clearInfo();
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertNull((String)"The selected item wasn't set properly", (Object)this.model.getItem());
        Assert.assertTrue((String)"The SelectionListener was supposed to be notified", (boolean)selectionListener.isListenerNotified());
        Assert.assertSame((String)"The SelectionListener was supposed to be notified", (Object)selectedItem, (Object)selectionListener.getItem());
        this.testSelectedItem(selectedItem);
        selectedItem = this.model.itemAt(2);
        this.model.clearItemCalledFlag();
        selectionListener.clearInfo();
        this.model.setItem(selectedItem);
        Assert.assertTrue((String)"The selected item was supposed to be modified", (boolean)this.model.isSetItemCalled());
        Assert.assertSame((String)"The selected item wasn't set properly", (Object)selectedItem, (Object)this.model.getItem());
        Assert.assertTrue((String)"The SelectionListener was supposed to be notified", (boolean)selectionListener.isListenerNotified());
        Assert.assertSame((String)"The SelectionListener was supposed to be notified", (Object)selectedItem, (Object)selectionListener.getItem());
        this.testSelectedItem(selectedItem);
    }

    private static class Model
    extends AbstractModel {
        private SimpleDisplayable item;
        private List<SimpleDisplayable> items = new ArrayList<SimpleDisplayable>();
        private boolean setItemCalled;
        static final String ITEM_PROPERTY = "item";
        static final String ITEMS_LIST = "items";

        private Model() {
        }

        void addItems(Iterator<SimpleDisplayable> items) {
            this.addItemsToList(items, this.items, ITEMS_LIST);
        }

        void addItems(List<SimpleDisplayable> items) {
            this.addItemsToList(items, this.items, ITEMS_LIST);
        }

        void clearItemCalledFlag() {
            this.setItemCalled = false;
        }

        SimpleDisplayable getItem() {
            return this.item;
        }

        boolean isSetItemCalled() {
            return this.setItemCalled;
        }

        SimpleDisplayable itemAt(int index) {
            return this.items.get(index);
        }

        ListIterator<SimpleDisplayable> items() {
            return this.items.listIterator();
        }

        int itemsSize() {
            return this.items.size();
        }

        void removeItems(Iterator<SimpleDisplayable> items) {
            this.removeItemsFromList(items, this.items, ITEMS_LIST);
        }

        void setItem(SimpleDisplayable item) {
            this.setItemCalled = true;
            SimpleDisplayable oldItem = this.item;
            this.item = item;
            this.firePropertyChanged(ITEM_PROPERTY, oldItem, item);
        }
    }

    private class SelectionListener
    implements AbstractComboModelAdapter.SelectionChangeListener<SimpleDisplayable> {
        private SimpleDisplayable item;
        private boolean listenerNotified;

        private SelectionListener() {
        }

        void clearInfo() {
            this.listenerNotified = false;
            this.item = null;
        }

        SimpleDisplayable getItem() {
            return this.item;
        }

        public boolean isListenerNotified() {
            return this.listenerNotified;
        }

        public void selectionChanged(AbstractComboModelAdapter.SelectionChangeEvent<SimpleDisplayable> e) {
            this.listenerNotified = true;
            this.item = (SimpleDisplayable)e.selectedItem();
        }
    }
}

