/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.PipedTransportService;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.transport.ListenerKey;
import org.eclipse.wst.jsdt.debug.transport.TransportService;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;

public class DebugSessionTest
extends TestCase {
    boolean complete = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceiveEvent() throws IOException, InterruptedException, TimeoutException, DisconnectedException {
        PipedTransportService service = new PipedTransportService();
        ListenerKey key = service.startListening("9000");
        Thread t = new Thread((TransportService)service, key){
            private final /* synthetic */ TransportService val$service;
            private final /* synthetic */ ListenerKey val$key;
            {
                this.val$service = transportService;
                this.val$key = listenerKey;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Connection c = null;
                DebugSession runtime = null;
                try {
                    try {
                        c = this.val$service.accept(this.val$key, 5000L, 5000L);
                        DebugSessionTest.assertNotNull((Object)c);
                        runtime = new DebugSession(c);
                        runtime.send((Packet)new EventPacket("test"));
                        Thread thread = Thread.currentThread();
                        synchronized (thread) {
                            Thread.currentThread().wait();
                            return;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        DebugSessionTest.fail();
                        if (runtime == null) return;
                        runtime.dispose();
                        return;
                    }
                    catch (DisconnectedException disconnectedException) {
                        DebugSessionTest.fail();
                        if (runtime == null) return;
                        runtime.dispose();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        DebugSessionTest.fail();
                        if (runtime == null) return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        runtime.dispose();
                        return;
                    }
                }
                finally {
                    if (runtime != null) {
                        runtime.dispose();
                    }
                }
            }
        };
        t.start();
        Connection c = service.attach("9000", 5000L, 5000L);
        DebugSessionTest.assertNotNull((Object)c);
        DebugSession session = new DebugSession(c);
        try {
            EventPacket event = (EventPacket)session.receive("event", 5000);
            DebugSessionTest.assertTrue((boolean)event.getEvent().equals("test"));
        }
        catch (Throwable throwable) {
            session.dispose();
            Thread thread = t;
            synchronized (thread) {
                t.notify();
            }
            throw throwable;
        }
        session.dispose();
        Thread thread = t;
        synchronized (thread) {
            t.notify();
        }
        t.join(5000L);
        service.stopListening(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendRequestReceiveResponse() throws IOException, InterruptedException, DisconnectedException, TimeoutException {
        PipedTransportService service = new PipedTransportService();
        ListenerKey key = service.startListening("9000");
        Thread t = new Thread((TransportService)service, key){
            private final /* synthetic */ TransportService val$service;
            private final /* synthetic */ ListenerKey val$key;
            {
                this.val$service = transportService;
                this.val$key = listenerKey;
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        t.start();
        Connection c = service.attach("9000", 5000L, 5000L);
        DebugSessionTest.assertNotNull((Object)c);
        DebugSession session = new DebugSession(c);
        try {
            RhinoRequest request = new RhinoRequest("test");
            session.send((Packet)request);
            Response response = session.receiveResponse(request.getSequence(), 5000);
            DebugSessionTest.assertTrue((boolean)response.getCommand().equals("test"));
            DebugSessionTest.assertTrue((response.getRequestSequence() == request.getSequence() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            session.dispose();
            Thread thread = t;
            synchronized (thread) {
                t.notify();
            }
            throw throwable;
        }
        session.dispose();
        Thread thread = t;
        synchronized (thread) {
            t.notify();
        }
        t.join(5000L);
        service.stopListening(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendEvent() throws IOException, InterruptedException {
        PipedTransportService service = new PipedTransportService();
        ListenerKey key = service.startListening("9000");
        Thread t = new Thread((TransportService)service, key){
            private final /* synthetic */ TransportService val$service;
            private final /* synthetic */ ListenerKey val$key;
            {
                this.val$service = transportService;
                this.val$key = listenerKey;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Connection c = null;
                DebugSession runtime = null;
                try {
                    try {
                        c = this.val$service.accept(this.val$key, 5000L, 5000L);
                        DebugSessionTest.assertNotNull((Object)c);
                        runtime = new DebugSession(c);
                        runtime.send((Packet)new EventPacket("test"));
                        Thread thread = Thread.currentThread();
                        synchronized (thread) {
                            if (DebugSessionTest.this.complete) return;
                            Thread.currentThread().wait(5000L);
                            return;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        DebugSessionTest.fail();
                        if (runtime == null) return;
                        runtime.dispose();
                        return;
                    }
                    catch (DisconnectedException e) {
                        e.printStackTrace();
                        if (runtime == null) return;
                        runtime.dispose();
                        return;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        if (runtime == null) return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        runtime.dispose();
                        return;
                    }
                }
                finally {
                    if (runtime != null) {
                        runtime.dispose();
                    }
                }
            }
        };
        t.start();
        Connection c = service.attach("9000", 5000L, 5000L);
        DebugSessionTest.assertNotNull((Object)c);
        try {
            Packet packet = c.readPacket();
            DebugSessionTest.assertTrue((boolean)(packet instanceof EventPacket));
            EventPacket event = (EventPacket)packet;
            DebugSessionTest.assertTrue((boolean)event.getEvent().equals("test"));
        }
        catch (Throwable throwable) {
            c.close();
            Thread thread = t;
            synchronized (thread) {
                this.complete = true;
                t.notify();
            }
            throw throwable;
        }
        c.close();
        Thread thread = t;
        synchronized (thread) {
            this.complete = true;
            t.notify();
        }
        t.join(5000L);
        service.stopListening(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReceiveRequestSendResponse() throws IOException, InterruptedException {
        PipedTransportService service = new PipedTransportService();
        ListenerKey key = service.startListening("9000");
        Thread t = new Thread((TransportService)service, key){
            private final /* synthetic */ TransportService val$service;
            private final /* synthetic */ ListenerKey val$key;
            {
                this.val$service = transportService;
                this.val$key = listenerKey;
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        t.start();
        Connection c = service.attach("9000", 5000L, 5000L);
        DebugSessionTest.assertNotNull((Object)c);
        try {
            RhinoRequest request = new RhinoRequest("test");
            c.writePacket((Packet)request);
            Packet packet = c.readPacket();
            DebugSessionTest.assertTrue((boolean)(packet instanceof Response));
            Response response = (Response)packet;
            DebugSessionTest.assertTrue((boolean)response.getCommand().equals("test"));
            DebugSessionTest.assertTrue((response.getRequestSequence() == request.getSequence() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            c.close();
            Thread thread = t;
            synchronized (thread) {
                t.notify();
            }
            throw throwable;
        }
        c.close();
        Thread thread = t;
        synchronized (thread) {
            t.notify();
        }
        t.join(5000L);
        service.stopListening(key);
    }
}

