/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Objects;

public final class ConstructorArgs {
    private final Constructor<?> constructor;
    private final Object[] initArgs;

    public ConstructorArgs(Constructor<?> constructor, Object ... initArgs) {
        this.constructor = Objects.requireNonNull(constructor);
        this.initArgs = ConstructorArgs.validateArgs(constructor, initArgs);
    }

    private static Object[] validateArgs(Constructor<?> constructor, Object[] initArgs) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        if (initArgs.length != paramTypes.length) {
            throw new IllegalArgumentException("Number of provided arguments doesn't match constructor ones");
        }
        for (int i = 0; i < initArgs.length; ++i) {
            Class<?> paramType = paramTypes[i];
            Object arg = initArgs[i];
            if (paramType.isPrimitive()) {
                if (arg == null) {
                    throw new IllegalArgumentException("Null argument for primitive param " + i);
                }
                try {
                    Field field = arg.getClass().getDeclaredField("TYPE");
                    Class argType = (Class)field.get(null);
                    if (paramType.equals(argType)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw ConstructorArgs.throwException(paramType, arg);
                }
                throw ConstructorArgs.throwException(paramType, arg);
            }
            if (arg == null || paramType.isAssignableFrom(arg.getClass())) continue;
            throw ConstructorArgs.throwException(paramType, arg);
        }
        return initArgs;
    }

    private static IllegalArgumentException throwException(Class<?> paramType, Object arg) {
        return new IllegalArgumentException(arg + " isn't of type " + paramType);
    }

    public Object[] getInitArgs() {
        return this.initArgs;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }
}

