/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.BufferedModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class BufferedModifiablePropertyValueModelTests
extends TestCase {
    private Employee employee;
    private ModifiablePropertyValueModel<Employee> employeeHolder;
    PropertyChangeEvent employeeEvent;
    private ModifiablePropertyValueModel<Integer> idAdapter;
    private ModifiablePropertyValueModel<String> nameAdapter;
    private ModifiablePropertyValueModel<Date> hireDateAdapter;
    PropertyChangeEvent adapterEvent;
    private BufferedModifiablePropertyValueModel.Trigger trigger;
    private BufferedModifiablePropertyValueModel<Integer> bufferedIDHolder;
    private BufferedModifiablePropertyValueModel<String> bufferedNameHolder;
    private BufferedModifiablePropertyValueModel<Date> bufferedHireDateHolder;
    PropertyChangeEvent bufferedEvent;

    public BufferedModifiablePropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.employee = new Employee(17, "Freddy", new Date());
        this.employeeHolder = new SimplePropertyValueModel((Object)this.employee);
        this.trigger = new BufferedModifiablePropertyValueModel.Trigger();
        this.idAdapter = this.buildIDAdapter((PropertyValueModel<Employee>)this.employeeHolder);
        this.bufferedIDHolder = new BufferedModifiablePropertyValueModel(this.idAdapter, (PropertyValueModel)this.trigger);
        this.nameAdapter = this.buildNameAdapter((PropertyValueModel<Employee>)this.employeeHolder);
        this.bufferedNameHolder = new BufferedModifiablePropertyValueModel(this.nameAdapter, (PropertyValueModel)this.trigger);
        this.hireDateAdapter = this.buildHireDateAdapter((PropertyValueModel<Employee>)this.employeeHolder);
        this.bufferedHireDateHolder = new BufferedModifiablePropertyValueModel(this.hireDateAdapter, (PropertyValueModel)this.trigger);
    }

    private ModifiablePropertyValueModel<Integer> buildIDAdapter(PropertyValueModel<Employee> eHolder) {
        return new PropertyAspectAdapter<Employee, Integer>(eHolder, new String[]{"id"}){

            protected Integer buildValue_() {
                return new Integer(((Employee)((Object)this.subject)).getID());
            }

            protected void setValue_(Integer value) {
                ((Employee)((Object)this.subject)).setID(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildNameAdapter(PropertyValueModel<Employee> eHolder) {
        return new PropertyAspectAdapter<Employee, String>(eHolder, new String[]{"name"}){

            protected String buildValue_() {
                return ((Employee)((Object)this.subject)).getName();
            }

            protected void setValue_(String value) {
                ((Employee)((Object)this.subject)).setName(value);
            }
        };
    }

    private ModifiablePropertyValueModel<Date> buildHireDateAdapter(PropertyValueModel<Employee> eHolder) {
        return new PropertyAspectAdapter<Employee, Date>(eHolder, new String[]{"hireDate"}){

            protected Date buildValue_() {
                return ((Employee)((Object)this.subject)).getHireDate();
            }

            protected void setValue_(Date value) {
                ((Employee)((Object)this.subject)).setHireDate(value);
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetValue() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedIDHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.bufferedIDHolder.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.bufferedNameHolder.getValue()));
        Date temp = this.employee.getHireDate();
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.bufferedHireDateHolder.getValue());
        this.bufferedIDHolder.setValue((Object)new Integer(323));
        BufferedModifiablePropertyValueModelTests.assertEquals((int)17, (int)this.employee.getID());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.bufferedIDHolder.getValue());
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        this.bufferedHireDateHolder.setValue(null);
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals(null, (Object)this.bufferedHireDateHolder.getValue());
    }

    public void testTriggerAccept() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedIDHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedIDHolder.setValue((Object)new Integer(323));
        BufferedModifiablePropertyValueModelTests.assertEquals((int)17, (int)this.employee.getID());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.bufferedIDHolder.getValue());
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        Date temp = this.employee.getHireDate();
        this.bufferedHireDateHolder.setValue(null);
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals(null, (Object)this.bufferedHireDateHolder.getValue());
        this.trigger.accept();
        BufferedModifiablePropertyValueModelTests.assertEquals((int)323, (int)this.employee.getID());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.idAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.bufferedIDHolder.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals(null, (Object)this.employee.getHireDate());
        BufferedModifiablePropertyValueModelTests.assertEquals(null, (Object)this.hireDateAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals(null, (Object)this.bufferedHireDateHolder.getValue());
    }

    public void testTriggerReset() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedIDHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedIDHolder.setValue((Object)new Integer(323));
        BufferedModifiablePropertyValueModelTests.assertEquals((int)17, (int)this.employee.getID());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.bufferedIDHolder.getValue());
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        Date temp = this.employee.getHireDate();
        this.bufferedHireDateHolder.setValue(null);
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals(null, (Object)this.bufferedHireDateHolder.getValue());
        this.trigger.reset();
        BufferedModifiablePropertyValueModelTests.assertEquals((int)17, (int)this.employee.getID());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.bufferedIDHolder.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.bufferedHireDateHolder.getValue());
    }

    public void testLazyListening() {
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedIDHolder.hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedHireDateHolder.hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.idAdapter).hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.nameAdapter).hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.hireDateAdapter).hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("id"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("name"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("hireDate"));
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedIDHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedIDHolder.hasAnyPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.hasAnyPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedHireDateHolder.hasAnyPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.idAdapter).hasAnyPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.nameAdapter).hasAnyPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.hireDateAdapter).hasAnyPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasAnyPropertyChangeListeners("id"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasAnyPropertyChangeListeners("name"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasAnyPropertyChangeListeners("hireDate"));
        this.bufferedIDHolder.removePropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.removePropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.removePropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedIDHolder.hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedHireDateHolder.hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.idAdapter).hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.nameAdapter).hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.hireDateAdapter).hasNoPropertyChangeListeners("value"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("id"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("name"));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("hireDate"));
    }

    public void testPropertyChange1() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        ChangeListener adapterListener = this.buildAdapterListener();
        this.nameAdapter.addPropertyChangeListener("value", (PropertyChangeListener)adapterListener);
        ChangeListener employeeListener = this.buildEmployeeListener();
        this.employee.addPropertyChangeListener("name", (PropertyChangeListener)employeeListener);
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addChangeListener(bufferedListener);
        ChangeListener adapterListener = this.buildAdapterListener();
        this.nameAdapter.addChangeListener(adapterListener);
        ChangeListener employeeListener = this.buildEmployeeListener();
        this.employee.addChangeListener(employeeListener);
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.bufferedNameHolder.setValue((Object)"Ripley");
        this.verifyEvent(this.bufferedEvent, this.bufferedNameHolder, "value", "Freddy", "Ripley");
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.adapterEvent);
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.employeeEvent);
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.bufferedNameHolder.setValue((Object)"Charlie");
        this.verifyEvent(this.bufferedEvent, this.bufferedNameHolder, "value", "Ripley", "Charlie");
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.adapterEvent);
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.employeeEvent);
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.trigger.accept();
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.bufferedEvent);
        this.verifyEvent(this.adapterEvent, this.nameAdapter, "value", "Freddy", "Charlie");
        this.verifyEvent(this.employeeEvent, (Object)this.employee, "name", "Freddy", "Charlie");
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.bufferedNameHolder.setValue((Object)"Jason");
        this.verifyEvent(this.bufferedEvent, this.bufferedNameHolder, "value", "Charlie", "Jason");
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.adapterEvent);
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.employeeEvent);
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.trigger.reset();
        this.verifyEvent(this.bufferedEvent, this.bufferedNameHolder, "value", "Jason", "Charlie");
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.adapterEvent);
        BufferedModifiablePropertyValueModelTests.assertNull((Object)this.employeeEvent);
    }

    public void testBuffering1() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.isBuffering());
    }

    public void testBuffering2() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Freddy");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertFalse((boolean)this.bufferedNameHolder.isBuffering());
    }

    public void testBuffering3() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.isBuffering());
        this.bufferedNameHolder.setValue((Object)"Freddy");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedModifiablePropertyValueModelTests.assertFalse((boolean)this.bufferedNameHolder.isBuffering());
    }

    public void testChangeConflict1() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        this.nameAdapter.setValue((Object)"Jason");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Jason", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Jason", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        this.trigger.accept();
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
    }

    public void testChangeConflict2() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedModifiablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.isBuffering());
        this.nameAdapter.setValue((Object)"Ripley");
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)this.employee.getName());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.nameAdapter.getValue()));
        BufferedModifiablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedModifiablePropertyValueModelTests.assertFalse((boolean)this.bufferedNameHolder.isBuffering());
    }

    private ChangeListener buildBufferedListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                BufferedModifiablePropertyValueModelTests.this.bufferedEvent = e;
            }
        };
    }

    private ChangeListener buildAdapterListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                BufferedModifiablePropertyValueModelTests.this.adapterEvent = e;
            }
        };
    }

    private ChangeListener buildEmployeeListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                BufferedModifiablePropertyValueModelTests.this.employeeEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent event, Object source, String propertyName, Object oldValue, Object newValue) {
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        BufferedModifiablePropertyValueModelTests.assertEquals((String)propertyName, (String)event.getPropertyName());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)oldValue, (Object)event.getOldValue());
        BufferedModifiablePropertyValueModelTests.assertEquals((Object)newValue, (Object)event.getNewValue());
    }

    class Employee
    extends AbstractModel {
        private int id;
        public static final String ID_PROPERTY = "id";
        private String name;
        public static final String NAME_PROPERTY = "name";
        private Date hireDate;
        public static final String HIRE_DATE_PROPERTY = "hireDate";

        Employee(int id, String name, Date hireDate) {
            this.id = id;
            this.name = name;
            this.hireDate = hireDate;
        }

        int getID() {
            return this.id;
        }

        void setID(int id) {
            int old = this.id;
            this.id = id;
            this.firePropertyChanged(ID_PROPERTY, old, id);
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        Date getHireDate() {
            return this.hireDate;
        }

        void setHireDate(Date hireDate) {
            Date old = this.hireDate;
            this.hireDate = hireDate;
            this.firePropertyChanged(HIRE_DATE_PROPERTY, old, hireDate);
        }

        public void toString(StringBuilder sb) {
            sb.append(this.name);
        }
    }
}

