/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.io.NullReader;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class NullReaderTests
extends TestCase {
    private Reader nullReader;

    public NullReaderTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.nullReader = NullReader.instance();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testClose() throws IOException {
        this.nullReader.close();
    }

    public void testRead() throws IOException {
        NullReaderTests.assertEquals((int)-1, (int)this.nullReader.read());
    }

    public void testReadCharArray() throws IOException {
        char[] expected = new char[10];
        Arrays.fill(expected, 'a');
        char[] actual = new char[10];
        Arrays.fill(actual, 'a');
        NullReaderTests.assertEquals((int)-1, (int)this.nullReader.read(actual));
        NullReaderTests.assertTrue((boolean)Arrays.equals(actual, expected));
    }

    public void testReadCharArrayIntInt() throws IOException {
        char[] expected = new char[10];
        Arrays.fill(expected, 'a');
        char[] actual = new char[10];
        Arrays.fill(actual, 'a');
        NullReaderTests.assertEquals((int)-1, (int)this.nullReader.read(actual, 2, 5));
        NullReaderTests.assertTrue((boolean)Arrays.equals(actual, expected));
    }

    public void testSkip() throws IOException {
        NullReaderTests.assertEquals((long)0L, (long)this.nullReader.skip(5L));
    }

    public void testMark() {
        boolean exCaught = false;
        try {
            this.nullReader.mark(5);
        }
        catch (IOException iOException) {
            exCaught = true;
        }
        NullReaderTests.assertTrue((boolean)exCaught);
    }

    public void testMarkSupported() {
        NullReaderTests.assertFalse((boolean)this.nullReader.markSupported());
    }

    public void testReady() {
        NullReaderTests.assertFalse((boolean)this.nullReader.markSupported());
    }

    public void testReset() {
        boolean exCaught = false;
        try {
            this.nullReader.reset();
        }
        catch (IOException iOException) {
            exCaught = true;
        }
        NullReaderTests.assertTrue((boolean)exCaught);
    }
}

