/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.deque.ArrayDeque;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.deque.DequeTests;

public class ArrayDequeTests
extends DequeTests {
    public ArrayDequeTests(String name) {
        super(name);
    }

    @Override
    Deque<String> buildDeque() {
        return DequeTools.arrayDeque();
    }

    public void testConstructor_IAE() {
        boolean exCaught = false;
        try {
            ArrayDeque queue = DequeTools.arrayDeque((int)-1);
            ArrayDequeTests.fail((String)("bogus deque: " + queue));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayDequeTests.assertTrue((boolean)exCaught);
    }

    public void testEnsureCapacity() {
        ArrayDeque queue = DequeTools.arrayDeque((int)0);
        queue.ensureCapacity(7);
        ArrayDequeTests.assertEquals((int)7, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
    }

    public void testTrimToSize() {
        ArrayDeque queue = DequeTools.arrayDeque((int)10);
        queue.enqueueTail((Object)"foo");
        queue.enqueueTail((Object)"bar");
        queue.trimToSize();
        ArrayDequeTests.assertEquals((int)2, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
    }

    public void testTrimToSize_noChange() {
        ArrayDeque queue = DequeTools.arrayDeque((int)2);
        queue.enqueueTail((Object)"foo");
        queue.enqueueTail((Object)"bar");
        queue.trimToSize();
        ArrayDequeTests.assertEquals((int)2, (int)((Object[])ObjectTools.get((Object)queue, (String)"elements")).length);
    }

    public void testCollectionConstructor() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("first");
        c.add("second");
        c.add("third");
        c.add("fourth");
        c.add("fifth");
        c.add("sixth");
        c.add("seventh");
        c.add("eighth");
        c.add("ninth");
        c.add("tenth");
        ArrayDeque queue = DequeTools.arrayDeque(c);
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.peekHead()));
        queue.enqueueTail((Object)"eleventh");
        queue.enqueueTail((Object)"twelfth");
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.peekHead()));
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"third", (String)((String)queue.peekHead()));
        ArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testWrappedElementsTail() {
        Deque<String> queue = this.buildDeque();
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"first");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"second");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"third");
        queue.enqueueTail((Object)"fourth");
        queue.enqueueTail((Object)"fifth");
        queue.enqueueTail((Object)"sixth");
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueHead()));
        queue.enqueueTail((Object)"seventh");
        queue.enqueueTail((Object)"eighth");
        queue.enqueueTail((Object)"ninth");
        queue.enqueueTail((Object)"tenth");
        queue.enqueueTail((Object)"eleventh");
        queue.enqueueTail((Object)"twelfth");
        ArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testWrappedElementsHead() {
        Deque<String> queue = this.buildDeque();
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"first");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"second");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"third");
        queue.enqueueHead((Object)"fourth");
        queue.enqueueHead((Object)"fifth");
        queue.enqueueHead((Object)"sixth");
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueTail()));
        queue.enqueueHead((Object)"seventh");
        queue.enqueueHead((Object)"eighth");
        queue.enqueueHead((Object)"ninth");
        queue.enqueueHead((Object)"tenth");
        queue.enqueueHead((Object)"eleventh");
        queue.enqueueHead((Object)"twelfth");
        ArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededTail() {
        Deque<String> queue = this.buildDeque();
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"first");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"second");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"third");
        queue.enqueueTail((Object)"fourth");
        queue.enqueueTail((Object)"fifth");
        queue.enqueueTail((Object)"sixth");
        queue.enqueueTail((Object)"seventh");
        queue.enqueueTail((Object)"eighth");
        queue.enqueueTail((Object)"ninth");
        queue.enqueueTail((Object)"tenth");
        queue.enqueueTail((Object)"eleventh");
        queue.enqueueTail((Object)"twelfth");
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededHead() {
        Deque<String> queue = this.buildDeque();
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"first");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"second");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"third");
        queue.enqueueHead((Object)"fourth");
        queue.enqueueHead((Object)"fifth");
        queue.enqueueHead((Object)"sixth");
        queue.enqueueHead((Object)"seventh");
        queue.enqueueHead((Object)"eighth");
        queue.enqueueHead((Object)"ninth");
        queue.enqueueHead((Object)"tenth");
        queue.enqueueHead((Object)"eleventh");
        queue.enqueueHead((Object)"twelfth");
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededWithWrappedElementsTail() {
        Deque<String> queue = this.buildDeque();
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"first");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"second");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"third");
        queue.enqueueTail((Object)"fourth");
        queue.enqueueTail((Object)"fifth");
        queue.enqueueTail((Object)"sixth");
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueHead()));
        queue.enqueueTail((Object)"seventh");
        queue.enqueueTail((Object)"eighth");
        queue.enqueueTail((Object)"ninth");
        queue.enqueueTail((Object)"tenth");
        queue.enqueueTail((Object)"eleventh");
        queue.enqueueTail((Object)"twelfth");
        queue.enqueueTail((Object)"thirteenth");
        queue.enqueueTail((Object)"fourteenth");
        queue.enqueueTail((Object)"fifteenth");
        ArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"thirteenth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"fourteenth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertEquals((String)"fifteenth", (String)((String)queue.dequeueHead()));
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testArrayCapacityExceededWithWrappedElementsHead() {
        Deque<String> queue = this.buildDeque();
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"first");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"second");
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueHead((Object)"third");
        queue.enqueueHead((Object)"fourth");
        queue.enqueueHead((Object)"fifth");
        queue.enqueueHead((Object)"sixth");
        ArrayDequeTests.assertEquals((String)"first", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"second", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertFalse((boolean)queue.isEmpty());
        ArrayDequeTests.assertEquals((String)"third", (String)((String)queue.dequeueTail()));
        queue.enqueueHead((Object)"seventh");
        queue.enqueueHead((Object)"eighth");
        queue.enqueueHead((Object)"ninth");
        queue.enqueueHead((Object)"tenth");
        queue.enqueueHead((Object)"eleventh");
        queue.enqueueHead((Object)"twelfth");
        queue.enqueueHead((Object)"thirteenth");
        queue.enqueueHead((Object)"fourteenth");
        queue.enqueueHead((Object)"fifteenth");
        ArrayDequeTests.assertEquals((String)"fourth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"fifth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"sixth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"seventh", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"eighth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"ninth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"tenth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"eleventh", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"twelfth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"thirteenth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"fourteenth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertEquals((String)"fifteenth", (String)((String)queue.dequeueTail()));
        ArrayDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testSerialization_empty() throws Exception {
        ArrayDeque original = new ArrayDeque(3);
        Deque clone = (Deque)TestTools.serialize(original);
        ArrayDequeTests.assertNotSame((Object)original, (Object)clone);
        ArrayDequeTests.assertTrue((boolean)original.isEmpty());
        ArrayDequeTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.enqueueTail((Object)"fourth");
        ArrayDequeTests.assertFalse((boolean)original.isEmpty());
        ArrayDequeTests.assertTrue((boolean)clone.isEmpty());
    }

    public void testSerialization_fullArray() throws Exception {
        ArrayDeque queue = new ArrayDeque(3);
        queue.enqueueTail((Object)"first");
        queue.enqueueTail((Object)"second");
        queue.enqueueTail((Object)"third");
        this.verifyClone((Deque<String>)queue, (Deque<String>)((Deque)TestTools.serialize(queue)));
    }

    public void testSerialization_wrappedArray() throws Exception {
        ArrayDeque queue = new ArrayDeque(3);
        queue.enqueueTail((Object)"first");
        queue.enqueueTail((Object)"second");
        queue.enqueueTail((Object)"third");
        queue.dequeueHead();
        queue.enqueueTail((Object)"fourth");
        this.verifyClone((Deque<String>)queue, (Deque<String>)((Deque)TestTools.serialize(queue)));
    }
}

