/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import java.lang.reflect.Field;
import java.util.Collection;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.SystemTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.collection.BagTests;

public class HashBagTests
extends BagTests {
    public HashBagTests(String name) {
        super(name);
    }

    @Override
    protected Bag<String> buildBag_() {
        return new HashBag();
    }

    @Override
    protected Bag<String> buildBag(Collection<String> c) {
        return new HashBag(c);
    }

    @Override
    protected Bag<String> buildBag(int initialCapacity, float loadFactor) {
        return new HashBag(initialCapacity, loadFactor);
    }

    public void testHashingDistribution() throws Exception {
        Bag<String> bigBag = this.buildBag();
        int i = 0;
        while (i < 10000) {
            bigBag.add((Object)("object" + i));
            ++i;
        }
        Field field = bigBag.getClass().getDeclaredField("table");
        field.setAccessible(true);
        Object[] table = (Object[])field.get(bigBag);
        int bucketCount = table.length;
        int filledBucketCount = 0;
        Object[] objectArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                ++filledBucketCount;
            }
            ++n2;
        }
        float loadFactor = (float)filledBucketCount / (float)bucketCount;
        if ((double)loadFactor < 0.2 || (double)loadFactor > 0.8) {
            String msg = "poor load factor: " + loadFactor;
            if (SystemTools.jvmIsSun()) {
                HashBagTests.fail((String)msg);
            } else {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + '.' + this.getName() + " - " + msg);
                TestTools.printSystemProperties();
            }
        }
    }
}

